/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.utilities.streamer.HoodieStreamerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieStreamerMetrics {
    @Test
    public void testHoodieStreamerMetricsForErrorTableIfEnabled() throws InterruptedException {
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().on(true).withPath("/tmp/path1").withReporterType("INMEMORY").build();
        HoodieStreamerMetrics metrics = new HoodieStreamerMetrics(metricsConfig, HoodieStorageUtils.getStorage((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf()));
        Timer.Context timerContext = metrics.getErrorTableWriteTimerContext();
        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        long duration = timerContext.stop();
        metrics.updateErrorTableCommitDuration(duration);
        MetricRegistry registry = metrics.getMetrics().getRegistry();
        Assertions.assertEquals((int)1, (int)registry.getGauges().size());
        Assertions.assertEquals((Object)".deltastreamer.errorTableCommitDuration", registry.getGauges().firstKey());
    }

    @Test
    public void testHoodieStreamerMetricsForErrorTableIfDisabled() {
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().on(false).withPath("/tmp/path2").withReporterType("INMEMORY").build();
        HoodieStreamerMetrics metrics = new HoodieStreamerMetrics(metricsConfig, HoodieStorageUtils.getStorage((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf()));
        Timer.Context timerContext = metrics.getErrorTableWriteTimerContext();
        Assertions.assertNull((Object)timerContext);
        metrics.updateErrorTableCommitDuration(0L);
        Assertions.assertNull((Object)metrics.getMetrics());
    }
}

