/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.utilities.exception.HoodieStreamerException;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.hudi.utilities.streamer.StreamerCheckpointUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestStreamerCheckpointUtils
extends SparkClientFunctionalTestHarness {
    private TypedProperties props;
    private HoodieStreamer.Config streamerConfig;
    protected HoodieTableMetaClient metaClient;

    @BeforeEach
    public void setUp() throws IOException {
        this.metaClient = HoodieTestUtils.init((String)this.basePath(), (HoodieTableType)HoodieTableType.COPY_ON_WRITE);
        this.props = new TypedProperties();
        this.streamerConfig = new HoodieStreamer.Config();
        this.streamerConfig.tableType = HoodieTableType.COPY_ON_WRITE.name();
    }

    @Test
    public void testEmptyTimelineCase() throws IOException {
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)checkpoint.isEmpty());
    }

    @Test
    public void testIgnoreCheckpointCaseEmptyIgnoreKey() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "ckp_key");
        extraMetadata.put("deltastreamer.checkpoint.ignore_key", "");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.ignoreCheckpoint = "ignore_checkpoint_1";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)checkpoint.isEmpty());
    }

    @Test
    public void testIgnoreCheckpointCaseIgnoreKeyMismatch() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "ckp_key");
        extraMetadata.put("deltastreamer.checkpoint.ignore_key", "ignore_checkpoint_2");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.ignoreCheckpoint = "ignore_checkpoint_1";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)checkpoint.isEmpty());
    }

    @Test
    public void testThrowExceptionCase() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "");
        extraMetadata.put("deltastreamer.checkpoint.reset_key", "old-reset-key");
        this.createCommit(commitTime, extraMetadata);
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        HoodieStreamerException exception = (HoodieStreamerException)Assertions.assertThrows(HoodieStreamerException.class, () -> StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unable to find previous checkpoint"));
    }

    @Test
    public void testNewCheckpointV2WithResetKeyCase() throws IOException {
        String commitTime = "0000000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "");
        extraMetadata.put("deltastreamer.checkpoint.reset_key", "old-reset-key");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.checkpoint = "earliest";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.KafkaSource";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"earliest", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testNewCheckpointV1WithResetKeyCase() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.reset_key", "old-reset-key");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.checkpoint = "earliest";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.KafkaSource";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "1");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"earliest", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testReuseCheckpointCase() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "earliest-0-100");
        extraMetadata.put("deltastreamer.checkpoint.ignore_key", "");
        extraMetadata.put("deltastreamer.checkpoint.reset_key", "");
        this.createCommit(commitTime, extraMetadata);
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertEquals((Object)"earliest-0-100", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    public void testNewCheckpointV2NoMetadataCase() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.checkpoint = "earliest";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.KafkaSource";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV2));
        Assertions.assertEquals((Object)"earliest", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testNewCheckpointV1NoMetadataCase() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.checkpoint = "earliest";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.KafkaSource";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "1");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"earliest", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    private void createCommit(String commitTime, Map<String, String> extraMetadata) throws IOException {
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", commitTime, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        timeline.createNewInstant(instant);
        timeline.saveAsComplete(instant, HoodieCommonTestHarness.getCommitMetadata((HoodieTableMetaClient)this.metaClient, (String)this.basePath(), (String)"partition1", (String)commitTime, (int)2, extraMetadata));
        this.metaClient.reloadActiveTimeline();
    }

    @Test
    public void testIgnoreCheckpointNullKeyCase() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "some-checkpoint");
        extraMetadata.put("deltastreamer.checkpoint.ignore_key", "");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.ignoreCheckpoint = "ignore_checkpoint_1";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)checkpoint.isEmpty());
    }

    @Test
    public void testNewCheckpointWithEmptyResetKey() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "old-checkpoint");
        extraMetadata.put("deltastreamer.checkpoint.reset_key", "");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.checkpoint = "new-checkpoint";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"new-checkpoint", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testNewCheckpointWithDifferentResetKey() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put("deltastreamer.checkpoint.key", "old-checkpoint");
        extraMetadata.put("deltastreamer.checkpoint.reset_key", "different-reset-key");
        this.createCommit(commitTime, extraMetadata);
        this.streamerConfig.checkpoint = "new-checkpoint";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"new-checkpoint", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testMergeOnReadWithDeltaCommits() throws IOException {
        this.metaClient = HoodieTestUtils.init((String)this.basePath(), (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        this.streamerConfig.tableType = HoodieTableType.MERGE_ON_READ.name();
        String commitTime = "20240120000000";
        String deltaCommitTime = "20240120000001";
        HashMap<String, String> commitMetadata = new HashMap<String, String>();
        commitMetadata.put("deltastreamer.checkpoint.key", "commit-cp");
        this.createCommit(commitTime, commitMetadata);
        HashMap<String, String> deltaCommitMetadata = new HashMap<String, String>();
        deltaCommitMetadata.put("deltastreamer.checkpoint.key", "deltacommit-cp");
        this.createDeltaCommit(deltaCommitTime, deltaCommitMetadata);
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertEquals((Object)"deltacommit-cp", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testMergeOnReadWithoutDeltaCommits() throws IOException {
        this.metaClient = HoodieTestUtils.init((String)this.basePath(), (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        this.streamerConfig.tableType = HoodieTableType.MERGE_ON_READ.name();
        String commitTime = "20240120000000";
        HashMap<String, String> commitMetadata = new HashMap<String, String>();
        commitMetadata.put("deltastreamer.checkpoint.key", "commit-cp");
        this.createCommit(commitTime, commitMetadata);
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointBetweenConfigAndPrevCommit((HoodieTimeline)this.metaClient.getActiveTimeline(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
        Assertions.assertEquals((Object)"commit-cp", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    private void createDeltaCommit(String deltaCommitTime, Map<String, String> extraMetadata) throws IOException {
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", deltaCommitTime, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
        timeline.createNewInstant(instant);
        timeline.saveAsComplete(instant, HoodieCommonTestHarness.getCommitMetadata((HoodieTableMetaClient)this.metaClient, (String)this.basePath(), (String)"partition1", (String)deltaCommitTime, (int)2, extraMetadata));
        this.metaClient.reloadActiveTimeline();
    }

    @Test
    public void testCreateNewCheckpointV2WithNullTimeline() throws IOException {
        this.streamerConfig.checkpoint = "test-cp";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.KafkaSource";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "2");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointToResumeFrom((Option)Option.empty(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"test-cp", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testCreateNewCheckpointV1WithNullTimeline() throws IOException {
        this.streamerConfig.checkpoint = "test-cp";
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "1");
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointToResumeFrom((Option)Option.empty(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertTrue((boolean)(checkpoint.get() instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"test-cp", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testEmptyTimelineAndNullCheckpoint() throws IOException {
        this.streamerConfig.checkpoint = null;
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointToResumeFrom((Option)Option.empty(), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertTrue((boolean)checkpoint.isEmpty());
    }

    @Test
    public void testTimelineWithCheckpointOverridesConfigCheckpoint() throws IOException {
        String commitTime = "20240120000000";
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("deltastreamer.checkpoint.key", "commit-cp");
        this.createCommit(commitTime, metadata);
        this.streamerConfig.checkpoint = "config-cp";
        Option checkpoint = StreamerCheckpointUtils.resolveCheckpointToResumeFrom((Option)Option.of((Object)this.metaClient.getActiveTimeline()), (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)"config-cp", (Object)((Checkpoint)checkpoint.get()).getCheckpointKey());
    }

    @Test
    public void testAssertNoCheckpointOverrideDuringUpgradeSuccess() throws IOException {
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setDatabaseName("dataset").setTableName("testTable").setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_1).setTableVersion(HoodieTableVersion.SIX).setTableType(HoodieTableType.MERGE_ON_READ).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath());
        this.streamerConfig.checkpoint = null;
        this.streamerConfig.ignoreCheckpoint = null;
        this.props.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "true");
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "8");
        StreamerCheckpointUtils.assertNoCheckpointOverrideDuringUpgradeForHoodieIncSource((HoodieTableMetaClient)this.metaClient, (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
    }

    @Test
    public void testAssertNoCheckpointOverrideDuringUpgradeFailure() throws IOException {
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setDatabaseName("dataset").setTableName("testTable").setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_1).setTableVersion(HoodieTableVersion.SIX).setTableType(HoodieTableType.MERGE_ON_READ).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath());
        this.streamerConfig.checkpoint = "test-cp";
        this.streamerConfig.targetBasePath = "dummyVal";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.S3EventsHoodieIncrSource";
        this.props.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "true");
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "8");
        Assertions.assertThrows(HoodieUpgradeDowngradeException.class, () -> StreamerCheckpointUtils.assertNoCheckpointOverrideDuringUpgradeForHoodieIncSource((HoodieTableMetaClient)this.metaClient, (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props));
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.NotAHoodieIncrSource";
        this.streamerConfig.checkpoint = "test-cp";
        StreamerCheckpointUtils.assertNoCheckpointOverrideDuringUpgradeForHoodieIncSource((HoodieTableMetaClient)this.metaClient, (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
    }

    @Test
    public void testAssertNoCheckpointOverrideDuringUpgradeWithIgnoreCheckpoint() throws IOException {
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setDatabaseName("dataset").setTableName("testTable").setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_1).setTableVersion(HoodieTableVersion.SIX).setTableType(HoodieTableType.MERGE_ON_READ).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath());
        this.streamerConfig.ignoreCheckpoint = "ignore-cp";
        this.streamerConfig.targetBasePath = "dummyVal";
        this.streamerConfig.sourceClassName = "org.apache.hudi.utilities.sources.GcsEventsHoodieIncrSource";
        this.props.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "true");
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "8");
        Assertions.assertThrows(HoodieUpgradeDowngradeException.class, () -> StreamerCheckpointUtils.assertNoCheckpointOverrideDuringUpgradeForHoodieIncSource((HoodieTableMetaClient)this.metaClient, (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props));
    }

    @Test
    public void testAssertNoCheckpointOverrideDuringUpgradeWithAutoUpgradeDisabledVersion6() throws IOException {
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setDatabaseName("dataset").setTableName("testTable").setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_1).setTableVersion(HoodieTableVersion.SIX).setTableType(HoodieTableType.MERGE_ON_READ).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath());
        this.streamerConfig.checkpoint = "test-cp";
        this.streamerConfig.targetBasePath = "dummyVal";
        this.props.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "false");
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "6");
        StreamerCheckpointUtils.assertNoCheckpointOverrideDuringUpgradeForHoodieIncSource((HoodieTableMetaClient)this.metaClient, (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
    }

    @Test
    public void testAssertNoCheckpointOverrideDuringUpgradeWithAutoUpgradeDisabledVersion8() throws IOException {
        this.metaClient = HoodieTableMetaClient.newTableBuilder().setDatabaseName("dataset").setTableName("testTable").setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_1).setTableVersion(HoodieTableVersion.EIGHT).setTableType(HoodieTableType.MERGE_ON_READ).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath());
        this.streamerConfig.checkpoint = "test-cp";
        this.streamerConfig.targetBasePath = "dummyVal";
        this.props.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "false");
        this.props.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "8");
        StreamerCheckpointUtils.assertNoCheckpointOverrideDuringUpgradeForHoodieIncSource((HoodieTableMetaClient)this.metaClient, (HoodieStreamer.Config)this.streamerConfig, (TypedProperties)this.props);
    }
}

