/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.testutils;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

public class CloudObjectTestUtils {
    public static void setMessagesInQueue(SqsClient sqs, Path path) {
        ReceiveMessageResponse receiveMessageResult = (ReceiveMessageResponse)ReceiveMessageResponse.builder().build();
        String approximateNumberOfMessages = "0";
        if (path != null) {
            String body = "{\n  \"Type\" : \"Notification\",\n  \"MessageId\" : \"1\",\n  \"TopicArn\" : \"arn:aws:sns:foo:123:foo-bar\",\n  \"Subject\" : \"Amazon S3 Notification\",\n  \"Message\" : \"{\\\"Records\\\":[{\\\"eventVersion\\\":\\\"2.1\\\",\\\"eventSource\\\":\\\"aws:s3\\\",\\\"awsRegion\\\":\\\"us-west-2\\\",\\\"eventTime\\\":\\\"2021-07-27T09:05:36.755Z\\\",\\\"eventName\\\":\\\"ObjectCreated:Copy\\\",\\\"userIdentity\\\":{\\\"principalId\\\":\\\"AWS:test\\\"},\\\"requestParameters\\\":{\\\"sourceIPAddress\\\":\\\"0.0.0.0\\\"},\\\"responseElements\\\":{\\\"x-amz-request-id\\\":\\\"test\\\",\\\"x-amz-id-2\\\":\\\"foobar\\\"},\\\"s3\\\":{\\\"s3SchemaVersion\\\":\\\"1.0\\\",\\\"configurationId\\\":\\\"foobar\\\",\\\"bucket\\\":{\\\"name\\\":\\\"" + path.getParent().toString().replace("hdfs://", "") + "\\\",\\\"ownerIdentity\\\":{\\\"principalId\\\":\\\"foo\\\"},\\\"arn\\\":\\\"arn:aws:s3:::foo\\\"},\\\"object\\\":{\\\"key\\\":\\\"" + path.getName() + "\\\",\\\"size\\\":123,\\\"eTag\\\":\\\"test\\\",\\\"sequencer\\\":\\\"1\\\"}}}]}\"}";
            Message message = (Message)Message.builder().receiptHandle("1").messageId("1").body(body).build();
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(message);
            receiveMessageResult = (ReceiveMessageResponse)ReceiveMessageResponse.builder().messages(messages).build();
            approximateNumberOfMessages = "1";
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ApproximateNumberOfMessages", approximateNumberOfMessages);
        Mockito.when((Object)sqs.receiveMessage((ReceiveMessageRequest)ArgumentMatchers.any(ReceiveMessageRequest.class))).thenReturn((Object)receiveMessageResult);
        Mockito.when((Object)sqs.getQueueAttributes((GetQueueAttributesRequest)ArgumentMatchers.any(GetQueueAttributesRequest.class))).thenReturn(GetQueueAttributesResponse.builder().attributesWithStrings(attributes).build());
    }

    public static void deleteMessagesInQueue(SqsClient sqs) {
        Mockito.when((Object)sqs.deleteMessageBatch((DeleteMessageBatchRequest)ArgumentMatchers.any(DeleteMessageBatchRequest.class))).thenReturn(DeleteMessageBatchResponse.builder().build());
    }
}

