/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.testutils;

import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.params.provider.Arguments;

public class SanitizationTestUtils {
    public static String invalidCharMask = (String)HoodieStreamerConfig.SCHEMA_FIELD_NAME_INVALID_CHAR_MASK.defaultValue();

    private static String sanitizeIfNeeded(String src, boolean shouldSanitize) {
        return shouldSanitize ? HoodieAvroUtils.sanitizeName((String)src, (String)invalidCharMask) : src;
    }

    protected static StructType getSchemaWithProperNaming() {
        StructType addressStruct = new StructType(new StructField[]{new StructField("state", DataTypes.StringType, true, Metadata.empty()), new StructField("street", DataTypes.StringType, true, Metadata.empty()), new StructField("zip", DataTypes.LongType, true, Metadata.empty())});
        StructType personStruct = new StructType(new StructField[]{new StructField("address", (DataType)addressStruct, true, Metadata.empty()), new StructField("name", DataTypes.StringType, true, Metadata.empty()), new StructField("occupation", DataTypes.StringType, true, Metadata.empty()), new StructField("place", DataTypes.StringType, true, Metadata.empty())});
        return personStruct;
    }

    protected static StructType getSchemaWithBadAvroNamingForStructType(boolean shouldSanitize) {
        StructType addressStruct = new StructType(new StructField[]{new StructField(SanitizationTestUtils.sanitizeIfNeeded("@state.", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("@@stree@t@", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("8@_zip", shouldSanitize), DataTypes.LongType, true, Metadata.empty())});
        StructType personStruct = new StructType(new StructField[]{new StructField(SanitizationTestUtils.sanitizeIfNeeded("@_addr*$ess", shouldSanitize), (DataType)addressStruct, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("9name", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("_occu9pation", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("@plac.e.", shouldSanitize), DataTypes.StringType, true, Metadata.empty())});
        return personStruct;
    }

    protected static StructType getSchemaWithBadAvroNamingForArrayType(boolean shouldSanitize) {
        StructType addressStruct = new StructType(new StructField[]{new StructField(SanitizationTestUtils.sanitizeIfNeeded("@state.", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("@@stree@t@", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("8@_zip", shouldSanitize), DataTypes.LongType, true, Metadata.empty())});
        StructType personStruct = new StructType(new StructField[]{new StructField(SanitizationTestUtils.sanitizeIfNeeded("@name", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("@arr@", shouldSanitize), (DataType)new ArrayType((DataType)addressStruct, true), true, Metadata.empty())});
        return personStruct;
    }

    protected static StructType getSchemaWithBadAvroNamingForMapType(boolean shouldSanitize) {
        StructType addressStruct = new StructType(new StructField[]{new StructField(SanitizationTestUtils.sanitizeIfNeeded("@state.", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("@@stree@t@", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("8@_zip", shouldSanitize), DataTypes.LongType, true, Metadata.empty())});
        StructType personStruct = new StructType(new StructField[]{new StructField(SanitizationTestUtils.sanitizeIfNeeded("@name", shouldSanitize), DataTypes.StringType, true, Metadata.empty()), new StructField(SanitizationTestUtils.sanitizeIfNeeded("@map9", shouldSanitize), (DataType)new MapType(DataTypes.StringType, (DataType)addressStruct, true), true, Metadata.empty())});
        return personStruct;
    }

    public static Schema generateProperFormattedSchema() {
        Schema addressSchema = (Schema)SchemaBuilder.record((String)"Address").fields().requiredString("streetaddress").requiredString("city").endRecord();
        Schema personSchema = (Schema)SchemaBuilder.record((String)"Person").fields().requiredString("firstname").requiredString("lastname").name("address").type(addressSchema).noDefault().endRecord();
        return personSchema;
    }

    public static Schema generateRenamedSchemaWithDefaultReplacement() {
        Schema addressSchema = (Schema)SchemaBuilder.record((String)"__Address").fields().nullableString("__stree9add__ress", "@@@any_address").requiredString("cit__y__").endRecord();
        Schema personSchema = (Schema)SchemaBuilder.record((String)"Person").fields().requiredString("__firstname").requiredString("__lastname").name("address").type(addressSchema).noDefault().endRecord();
        return personSchema;
    }

    public static Schema generateRenamedSchemaWithConfiguredReplacement() {
        Schema addressSchema = (Schema)SchemaBuilder.record((String)"_Address").fields().nullableString("_stree9add_ress", "@@@any_address").requiredString("cit_y_").endRecord();
        Schema personSchema = (Schema)SchemaBuilder.record((String)"Person").fields().requiredString("_firstname").requiredString("_lastname").name("address").type(addressSchema).noDefault().endRecord();
        return personSchema;
    }

    public static Stream<Arguments> provideDataFiles() {
        return Stream.of(Arguments.of((Object[])new Object[]{"src/test/resources/data/avro_sanitization.json", "src/test/resources/data/avro_sanitization.json", SanitizationTestUtils.getSchemaWithProperNaming(), SanitizationTestUtils.getSchemaWithProperNaming()}), Arguments.of((Object[])new Object[]{"src/test/resources/data/avro_sanitization_bad_naming_in.json", "src/test/resources/data/avro_sanitization_bad_naming_out.json", SanitizationTestUtils.getSchemaWithBadAvroNamingForStructType(false), SanitizationTestUtils.getSchemaWithBadAvroNamingForStructType(true)}), Arguments.of((Object[])new Object[]{"src/test/resources/data/avro_sanitization_bad_naming_nested_array_in.json", "src/test/resources/data/avro_sanitization_bad_naming_nested_array_out.json", SanitizationTestUtils.getSchemaWithBadAvroNamingForArrayType(false), SanitizationTestUtils.getSchemaWithBadAvroNamingForArrayType(true)}), Arguments.of((Object[])new Object[]{"src/test/resources/data/avro_sanitization_bad_naming_nested_map_in.json", "src/test/resources/data/avro_sanitization_bad_naming_nested_map_out.json", SanitizationTestUtils.getSchemaWithBadAvroNamingForMapType(false), SanitizationTestUtils.getSchemaWithBadAvroNamingForMapType(true)}));
    }
}

