/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.util.JavaScalaConverters;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.SqlTransformerConfig;
import org.apache.hudi.utilities.exception.HoodieSnapshotExporterException;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSnapshotExporter {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSnapshotExporter.class);

    public void export(JavaSparkContext jsc, Config cfg) throws IOException {
        FileSystem outputFs = HadoopFSUtils.getFs((String)cfg.targetOutputPath, (Configuration)jsc.hadoopConfiguration());
        if (outputFs.exists(new Path(cfg.targetOutputPath))) {
            throw new HoodieSnapshotExporterException("The target output path already exists.");
        }
        FileSystem sourceFs = HadoopFSUtils.getFs((String)cfg.sourceBasePath, (Configuration)jsc.hadoopConfiguration());
        HoodieTableMetaClient tableMetadata = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)sourceFs.getConf())).setBasePath(cfg.sourceBasePath).build();
        String latestCommitTimestamp = (String)this.getLatestCommitTimestamp(tableMetadata).orElseThrow(() -> {
            throw new HoodieSnapshotExporterException("No commits present. Nothing to snapshot.");
        });
        LOG.info(String.format("Starting to snapshot latest version files which are also no-late-than %s.", latestCommitTimestamp));
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(jsc);
        List<String> partitions = this.getPartitions((HoodieEngineContext)engineContext, cfg, (HoodieStorage)new HoodieHadoopStorage(sourceFs));
        if (partitions.isEmpty()) {
            throw new HoodieSnapshotExporterException("The source dataset has 0 partition to snapshot.");
        }
        LOG.info(String.format("The job needs to export %d partitions.", partitions.size()));
        if (cfg.outputFormat.equals("hudi")) {
            this.exportAsHudi(jsc, sourceFs, cfg, partitions, latestCommitTimestamp, tableMetadata);
        } else {
            this.exportAsNonHudi(jsc, sourceFs, cfg, partitions, latestCommitTimestamp);
        }
        this.createSuccessTag(outputFs, cfg);
    }

    private Option<String> getLatestCommitTimestamp(HoodieTableMetaClient tableMetadata) {
        Option latestCommit = tableMetadata.getActiveTimeline().getWriteTimeline().filterCompletedInstants().lastInstant();
        return latestCommit.isPresent() ? Option.of((Object)((HoodieInstant)latestCommit.get()).requestedTime()) : Option.empty();
    }

    private List<String> getPartitions(HoodieEngineContext engineContext, Config cfg, HoodieStorage storage) {
        return FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)storage, (String)cfg.sourceBasePath, (boolean)true);
    }

    private void createSuccessTag(FileSystem fs, Config cfg) throws IOException {
        Path successTagPath = new Path(cfg.targetOutputPath + "/_SUCCESS");
        if (!fs.exists(successTagPath)) {
            LOG.info(String.format("Creating _SUCCESS under target output path: %s", cfg.targetOutputPath));
            fs.createNewFile(successTagPath);
        }
    }

    private void exportAsNonHudi(JavaSparkContext jsc, FileSystem sourceFs, Config cfg, List<String> partitions, String latestCommitTimestamp) throws IOException {
        Option<Transformer> transformer;
        Partitioner defaultPartitioner = dataset -> {
            Dataset hoodieDroppedDataset = dataset.drop(JavaScalaConverters.convertJavaIteratorToScalaIterator(HoodieRecord.HOODIE_META_COLUMNS.iterator()).toSeq());
            return StringUtils.isNullOrEmpty((String)cfg.outputPartitionField) ? hoodieDroppedDataset.write() : hoodieDroppedDataset.repartition(new Column[]{new Column(cfg.outputPartitionField)}).write().partitionBy(new String[]{cfg.outputPartitionField});
        };
        Partitioner partitioner = StringUtils.isNullOrEmpty((String)cfg.outputPartitioner) ? defaultPartitioner : (Partitioner)ReflectionUtils.loadClass((String)cfg.outputPartitioner);
        HoodieSparkEngineContext context = new HoodieSparkEngineContext(jsc);
        context.setJobStatus(this.getClass().getSimpleName(), "Exporting as non-HUDI dataset: " + cfg.targetOutputPath);
        TableFileSystemView.BaseFileOnlyView fsView = this.getBaseFileOnlyView((HoodieEngineContext)context, sourceFs, cfg);
        Iterator exportingFilePaths = jsc.parallelize(partitions, partitions.size()).flatMap((FlatMapFunction & Serializable)partition -> fsView.getLatestBaseFilesBeforeOrOn(partition, latestCommitTimestamp).map(BaseFile::getPath).iterator()).toLocalIterator();
        Dataset<Row> sourceDataset = new SQLContext(jsc).read().parquet(JavaScalaConverters.convertJavaIteratorToScalaIterator((Iterator)exportingFilePaths).toSeq());
        if (!StringUtils.isNullOrEmpty((String)cfg.transformerClassName) && (transformer = UtilHelpers.createTransformer((Option<List<String>>)Option.of(Collections.singletonList(cfg.transformerClassName)), Option::empty, false)).isPresent()) {
            TypedProperties transformerProps = new TypedProperties();
            transformerProps.setPropertyIfNonNull(SqlTransformerConfig.TRANSFORMER_SQL.key(), (Object)cfg.transformerSql);
            transformerProps.setPropertyIfNonNull(SqlTransformerConfig.TRANSFORMER_SQL_FILE.key(), (Object)cfg.transformerSqlFile);
            sourceDataset = ((Transformer)transformer.get()).apply(jsc, SparkSession.builder().getOrCreate(), sourceDataset, transformerProps);
        }
        partitioner.partition(sourceDataset).format(cfg.outputFormat).mode(SaveMode.ErrorIfExists).save(cfg.targetOutputPath);
    }

    private void exportAsHudi(JavaSparkContext jsc, FileSystem sourceFs, Config cfg, List<String> partitions, String latestCommitTimestamp, HoodieTableMetaClient metaClient) throws IOException {
        int parallelism = cfg.parallelism == 0 ? jsc.defaultParallelism() : cfg.parallelism;
        HoodieSparkEngineContext context = new HoodieSparkEngineContext(jsc);
        TableFileSystemView.BaseFileOnlyView fsView = this.getBaseFileOnlyView((HoodieEngineContext)context, sourceFs, cfg);
        StorageConfiguration storageConf = context.getStorageConf();
        context.setJobStatus(this.getClass().getSimpleName(), "Exporting as HUDI dataset");
        List partitionAndFileList = context.flatMap(partitions, (SerializableFunction & Serializable)partition -> {
            StoragePath partitionMetaFile;
            List filePaths = fsView.getLatestBaseFilesBeforeOrOn(partition, latestCommitTimestamp).map(f -> Pair.of((Object)partition, (Object)f.getPath())).collect(Collectors.toList());
            HoodieStorage storage = HoodieStorageUtils.getStorage((String)cfg.sourceBasePath, (StorageConfiguration)storageConf);
            if (storage.exists(partitionMetaFile = (StoragePath)HoodiePartitionMetadata.getPartitionMetafilePath((HoodieStorage)storage, (StoragePath)FSUtils.constructAbsolutePath((String)cfg.sourceBasePath, (String)partition)).get())) {
                filePaths.add(Pair.of((Object)partition, (Object)partitionMetaFile.toString()));
            }
            return filePaths.stream();
        }, parallelism);
        context.foreach(partitionAndFileList, (SerializableConsumer & Serializable)partitionAndFile -> {
            String partition = (String)partitionAndFile.getLeft();
            Path sourceFilePath = new Path((String)partitionAndFile.getRight());
            Path toPartitionPath = HadoopFSUtils.constructAbsolutePathInHadoopPath((String)cfg.targetOutputPath, (String)partition);
            FileSystem executorSourceFs = HadoopFSUtils.getFs((String)cfg.sourceBasePath, (StorageConfiguration)storageConf.newInstance());
            FileSystem executorOutputFs = HadoopFSUtils.getFs((String)cfg.targetOutputPath, (StorageConfiguration)storageConf.newInstance());
            if (!executorOutputFs.exists(toPartitionPath)) {
                executorOutputFs.mkdirs(toPartitionPath);
            }
            FileUtil.copy((FileSystem)executorSourceFs, (Path)sourceFilePath, (FileSystem)executorOutputFs, (Path)new Path(toPartitionPath, sourceFilePath.getName()), (boolean)false, (boolean)true, (Configuration)executorOutputFs.getConf());
        }, parallelism);
        LOG.info(String.format("Copying .commit files which are no-late-than %s.", latestCommitTimestamp));
        List commitFilesListToCopy = Arrays.stream(sourceFs.listStatus(new Path(cfg.sourceBasePath + "/" + ".hoodie" + "/" + "timeline"))).filter(fileStatus -> {
            Path path = fileStatus.getPath();
            if (path.getName().equals("hoodie.properties")) {
                return true;
            }
            if (fileStatus.isDirectory()) {
                return false;
            }
            String instantTime = metaClient.getInstantFileNameParser().extractTimestamp(path.getName());
            return InstantComparison.compareTimestamps((String)instantTime, (BiPredicate)InstantComparison.LESSER_THAN_OR_EQUALS, (String)latestCommitTimestamp);
        }).collect(Collectors.toList());
        commitFilesListToCopy.addAll(Arrays.stream(sourceFs.listStatus(new Path(cfg.sourceBasePath + "/" + ".hoodie" + "/" + "hoodie.properties"))).collect(Collectors.toList()));
        FileStatus[] commitFilesToCopy = (FileStatus[])commitFilesListToCopy.stream().toArray(FileStatus[]::new);
        context.foreach(Arrays.asList(commitFilesToCopy), (SerializableConsumer & Serializable)commitFile -> {
            Path targetFilePath = commitFile.getPath().getName().endsWith("hoodie.properties") ? new Path(cfg.targetOutputPath + "/" + ".hoodie" + "/" + commitFile.getPath().getName()) : new Path(cfg.targetOutputPath + "/" + ".hoodie" + "/" + "timeline" + "/" + commitFile.getPath().getName());
            FileSystem executorSourceFs = HadoopFSUtils.getFs((String)cfg.sourceBasePath, (Configuration)((Configuration)storageConf.unwrapCopyAs(Configuration.class)));
            FileSystem executorOutputFs = HadoopFSUtils.getFs((String)cfg.targetOutputPath, (Configuration)((Configuration)storageConf.unwrapCopyAs(Configuration.class)));
            if (!executorOutputFs.exists(targetFilePath.getParent())) {
                executorOutputFs.mkdirs(targetFilePath.getParent());
            }
            FileUtil.copy((FileSystem)executorSourceFs, (Path)commitFile.getPath(), (FileSystem)executorOutputFs, (Path)targetFilePath, (boolean)false, (boolean)true, (Configuration)executorOutputFs.getConf());
        }, parallelism);
    }

    private TableFileSystemView.BaseFileOnlyView getBaseFileOnlyView(HoodieEngineContext engineContext, FileSystem sourceFs, Config cfg) {
        HoodieTableMetaClient tableMetadata = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)sourceFs.getConf())).setBasePath(cfg.sourceBasePath).build();
        return HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)tableMetadata, (HoodieTimeline)tableMetadata.getActiveTimeline().getWriteTimeline().filterCompletedInstants());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Config cfg = new Config();
        new JCommander((Object)cfg, null, args);
        if (!HoodieSnapshotExporter.areTransformerOptionsValid(cfg)) {
            System.exit(1);
        }
        SparkConf sparkConf = UtilHelpers.buildSparkConf("Hoodie-snapshot-exporter", "local[*]");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        LOG.info("Initializing spark job.");
        try {
            new HoodieSnapshotExporter().export(jsc, cfg);
        }
        finally {
            jsc.stop();
        }
    }

    public static boolean areTransformerOptionsValid(Config config) {
        boolean valid = true;
        if (!StringUtils.isNullOrEmpty((String)config.transformerClassName)) {
            switch (config.transformerClassName) {
                case "org.apache.hudi.utilities.transform.SqlQueryBasedTransformer": {
                    if (!StringUtils.isNullOrEmpty((String)config.transformerSql)) break;
                    LOG.error("--transformer-sql is required when using SqlQueryBasedTransformer");
                    valid = false;
                    break;
                }
                case "org.apache.hudi.utilities.transform.SqlFileBasedTransformer": {
                    if (!StringUtils.isNullOrEmpty((String)config.transformerSqlFile)) break;
                    LOG.error("--transformer-sql-file is required when using SqlFileBasedTransformer");
                    valid = false;
                    break;
                }
            }
        }
        return valid;
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--source-base-path"}, description="Base path for the source Hudi dataset to be snapshotted", required=true)
        public String sourceBasePath;
        @Parameter(names={"--target-output-path"}, description="Base path for the target output files (snapshots)", required=true)
        public String targetOutputPath;
        @Parameter(names={"--output-format"}, description="Output format for the exported dataset; accept these values: json|parquet|orc|hudi", required=true, validateValueWith={OutputFormatValidator.class})
        public String outputFormat;
        @Parameter(names={"--output-partition-field"}, description="A field to be used by Spark repartitioning")
        public String outputPartitionField = null;
        @Parameter(names={"--output-partitioner"}, description="A class to facilitate custom repartitioning")
        public String outputPartitioner = null;
        @Parameter(names={"--parallelism", "-pl"}, description="Parallelism for file listing")
        public int parallelism = 0;
        @Parameter(names={"--transformer-class"}, description="A subclass of org.apache.hudi.utilities.transform.Transformer. Allows transforming raw source Dataset to a target Dataset (conforming to target schema) before writing. Default: Not set. Available transformers: org.apache.hudi.utilities.transform.SqlQueryBasedTransformer, org.apache.hudi.utilities.transform.SqlFileBasedTransformer, org.apache.hudi.utilities.transform.FlatteningTransformer, org.apache.hudi.utilities.transform.AWSDmsTransformer.")
        public String transformerClassName = null;
        @Parameter(names={"--transformer-sql"}, description="sql-query template be used to transform the source before writing to Hudi data-set. The query should reference the source as a table named \"<SRC>\".")
        public String transformerSql = null;
        @Parameter(names={"--transformer-sql-file"}, description="File with a SQL query to be executed during write. The query should reference the source as a table named \"<SRC>\".")
        public String transformerSqlFile = null;
    }

    public static class OutputFormatValidator
    implements IValueValidator<String> {
        public static final String HUDI = "hudi";
        public static final List<String> FORMATS = CollectionUtils.createImmutableList((Object[])new String[]{"json", "parquet", "orc", "hudi"});

        public void validate(String name, String value) {
            if (value == null || !FORMATS.contains(value)) {
                throw new ParameterException(String.format("Invalid output format: value:%s: supported formats:%s", value, FORMATS));
            }
        }
    }

    @FunctionalInterface
    public static interface Partitioner {
        public DataFrameWriter<Row> partition(Dataset<Row> var1);
    }
}

