/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.callback.kafka;

import java.util.Properties;
import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.callback.common.HoodieWriteCommitCallbackMessage;
import org.apache.hudi.callback.util.HoodieWriteCommitCallbackUtil;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.utilities.callback.kafka.HoodieWriteCommitKafkaCallbackConfig;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieWriteCommitKafkaCallback
implements HoodieWriteCommitCallback {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteCommitKafkaCallback.class);
    private final HoodieConfig hoodieConfig;
    private final String bootstrapServers;
    private final String topic;

    public HoodieWriteCommitKafkaCallback(HoodieWriteConfig config) {
        this.hoodieConfig = config;
        this.bootstrapServers = config.getString(HoodieWriteCommitKafkaCallbackConfig.BOOTSTRAP_SERVERS);
        this.topic = config.getString(HoodieWriteCommitKafkaCallbackConfig.TOPIC);
        this.validateKafkaConfig();
    }

    public void call(HoodieWriteCommitCallbackMessage callbackMessage) {
        String callbackMsg = HoodieWriteCommitCallbackUtil.convertToJsonString((Object)callbackMessage);
        try (KafkaProducer<String, String> producer = this.createProducer(this.hoodieConfig);){
            ProducerRecord<String, String> record = this.buildProducerRecord(this.hoodieConfig, callbackMsg);
            producer.send(record).get();
            LOG.info("Send callback message succeed");
        }
        catch (Exception e) {
            LOG.error("Send kafka callback msg failed : ", (Throwable)e);
        }
    }

    public KafkaProducer<String, String> createProducer(HoodieConfig hoodieConfig) {
        Properties kafkaProducerProps = new Properties();
        kafkaProducerProps.setProperty("bootstrap.servers", this.bootstrapServers);
        kafkaProducerProps.setProperty("acks", hoodieConfig.getStringOrDefault(HoodieWriteCommitKafkaCallbackConfig.ACKS));
        kafkaProducerProps.setProperty("retries", hoodieConfig.getStringOrDefault(HoodieWriteCommitKafkaCallbackConfig.RETRIES));
        kafkaProducerProps.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        kafkaProducerProps.setProperty("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        LOG.debug("Callback kafka producer init with configs: " + HoodieWriteCommitCallbackUtil.convertToJsonString((Object)kafkaProducerProps));
        return new KafkaProducer(kafkaProducerProps);
    }

    private ProducerRecord<String, String> buildProducerRecord(HoodieConfig hoodieConfig, String callbackMsg) {
        String partition = hoodieConfig.getString(HoodieWriteCommitKafkaCallbackConfig.PARTITION);
        if (null != partition) {
            return new ProducerRecord(this.topic, Integer.valueOf(partition), (Object)hoodieConfig.getString(HoodieWriteConfig.TBL_NAME), (Object)callbackMsg);
        }
        return new ProducerRecord(this.topic, (Object)hoodieConfig.getString(HoodieWriteConfig.TBL_NAME), (Object)callbackMsg);
    }

    private void validateKafkaConfig() {
        ValidationUtils.checkArgument((!StringUtils.isNullOrEmpty((String)this.bootstrapServers) ? 1 : 0) != 0, (String)String.format("Config %s can not be null or empty", HoodieWriteCommitKafkaCallbackConfig.BOOTSTRAP_SERVERS.key()));
        ValidationUtils.checkArgument((!StringUtils.isNullOrEmpty((String)this.topic) ? 1 : 0) != 0, (String)String.format("Config %s can not be null or empty", HoodieWriteCommitKafkaCallbackConfig.TOPIC.key()));
    }

    private static class ProducerSendCallback
    implements Callback {
        private ProducerSendCallback() {
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (null != metadata) {
                LOG.info(String.format("message offset=%s partition=%s timestamp=%s topic=%s", metadata.offset(), metadata.partition(), metadata.timestamp(), metadata.topic()));
            }
            if (null != exception) {
                LOG.error("Send kafka callback msg failed : ", (Throwable)exception);
            }
        }
    }
}

