/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import org.apache.avro.Schema;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.hudi.utilities.schema.SchemaProvider;

public class SchemaProviderWithPostProcessor
extends SchemaProvider {
    private final SchemaProvider schemaProvider;
    private final Option<SchemaPostProcessor> schemaPostProcessor;

    public SchemaProviderWithPostProcessor(SchemaProvider schemaProvider, Option<SchemaPostProcessor> schemaPostProcessor) {
        super(null, null);
        this.schemaProvider = schemaProvider;
        this.schemaPostProcessor = schemaPostProcessor;
    }

    @Override
    public Schema getSourceSchema() {
        Schema sourceSchema = this.schemaProvider.getSourceSchema();
        return (Schema)this.schemaPostProcessor.map(processor -> processor.processSchema(sourceSchema)).orElse((Object)sourceSchema);
    }

    @Override
    public Schema getTargetSchema() {
        Schema targetSchema = this.schemaProvider.getTargetSchema();
        return (Schema)this.schemaPostProcessor.map(processor -> processor.processSchema(targetSchema)).orElse((Object)targetSchema);
    }

    public SchemaProvider getOriginalSchemaProvider() {
        return this.schemaProvider;
    }
}

