/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;
import org.apache.hudi.utilities.schema.converter.JsonToAvroSchemaConverterConfig;

public class JsonToAvroSchemaConverter
implements SchemaRegistryProvider.SchemaConverter {
    private static final String CONNECT_PARAMETERS = "connect.parameters";
    private static final String CONNECT_DECIMAL_PRECISION = "connect.decimal.precision";
    private static final String CONNECT_TYPE = "connect.type";
    private static final ObjectMapper MAPPER = JsonUtils.getObjectMapper();
    private static final Map<String, String> JSON_TO_AVRO_TYPE = Stream.of({"string", "string"}, {"null", "null"}, {"boolean", "boolean"}, {"integer", "long"}, {"number", "double"}).collect(Collectors.collectingAndThen(Collectors.toMap(p -> p[0], p -> p[1]), Collections::unmodifiableMap));
    private static final Pattern SYMBOL_REGEX = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private static final String LONG_TYPE = "long";
    private static final String DOUBLE_TYPE = "double";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String STRING_TYPE = "string";
    private static final String DEFAULT_FIELD = "default";
    private static final String TYPE = "type";
    private static final String TITLE = "title";
    private static final String RECORD = "record";
    private static final String ARRAY = "array";
    private final boolean convertDefaultValueType;
    private final boolean stripDefaultValueQuotes;

    public JsonToAvroSchemaConverter(TypedProperties config) {
        this.convertDefaultValueType = ConfigUtils.getBooleanWithAltKeys((Properties)config, JsonToAvroSchemaConverterConfig.CONVERT_DEFAULT_VALUE_TYPE);
        this.stripDefaultValueQuotes = ConfigUtils.getBooleanWithAltKeys((Properties)config, JsonToAvroSchemaConverterConfig.STRIP_DEFAULT_VALUE_QUOTES);
    }

    @Override
    public String convert(ParsedSchema parsedSchema) throws IOException {
        JsonSchema jsonSchema = (JsonSchema)parsedSchema;
        JsonNode jsonNode = MAPPER.readTree(jsonSchema.canonicalString());
        ObjectNode avroRecord = this.convertJsonNodeToAvroNode(jsonNode, new AtomicInteger(1), new HashSet<String>());
        return avroRecord.toString();
    }

    private ObjectNode convertJsonNodeToAvroNode(JsonNode jsonNode, AtomicInteger schemaCounter, Set<String> seenNames) {
        ObjectNode avroRecord = MAPPER.createObjectNode().put(TYPE, RECORD).put("name", JsonToAvroSchemaConverter.getAvroSchemaRecordName(jsonNode)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonNode));
        Option<String> namespace = JsonToAvroSchemaConverter.getAvroSchemaRecordNamespace(jsonNode);
        if (namespace.isPresent()) {
            avroRecord.put("namespace", (String)namespace.get());
        }
        if (jsonNode.hasNonNull("properties")) {
            avroRecord.set("fields", (JsonNode)this.convertProperties(jsonNode.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonNode), schemaCounter, seenNames));
        } else {
            avroRecord.set("fields", (JsonNode)MAPPER.createArrayNode());
        }
        return avroRecord;
    }

    private ArrayNode convertProperties(JsonNode jsonProperties, Set<String> required, AtomicInteger schemaCounter, Set<String> seenNames) {
        ArrayList avroFields = new ArrayList();
        jsonProperties.fieldNames().forEachRemaining(name -> avroFields.add(this.tryConvertNestedProperty((String)name, jsonProperties.get(name), schemaCounter, seenNames).or(() -> this.tryConvertArrayProperty((String)name, jsonProperties.get(name), schemaCounter, seenNames)).or(() -> JsonToAvroSchemaConverter.tryConvertEnumProperty(name, jsonProperties.get(name), schemaCounter, seenNames)).orElseGet(() -> this.convertProperty((String)name, jsonProperties.get(name), required.contains(name), schemaCounter, seenNames, false))));
        return MAPPER.createArrayNode().addAll(avroFields);
    }

    private Option<JsonNode> tryConvertNestedProperty(String name, JsonNode jsonProperty, AtomicInteger schemaCounter, Set<String> seenNames) {
        if (!JsonToAvroSchemaConverter.isJsonNestedType(jsonProperty)) {
            return Option.empty();
        }
        JsonNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set(TYPE, MAPPER.createObjectNode().put(TYPE, RECORD).put("name", JsonToAvroSchemaConverter.getAvroTypeName(jsonProperty, name, schemaCounter, seenNames)).set("fields", (JsonNode)this.convertProperties(jsonProperty.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonProperty), schemaCounter, seenNames)));
        return Option.of((Object)avroNode);
    }

    private Option<JsonNode> tryConvertArrayProperty(String name, JsonNode jsonProperty, AtomicInteger schemaCounter, Set<String> seenNames) {
        if (!JsonToAvroSchemaConverter.isJsonArrayType(jsonProperty)) {
            return Option.empty();
        }
        JsonNode jsonItems = jsonProperty.get("items");
        String itemName = JsonToAvroSchemaConverter.getAvroTypeName(jsonItems, name, schemaCounter, seenNames) + "_child";
        JsonNode avroItems = JsonToAvroSchemaConverter.isJsonNestedType(jsonItems) ? MAPPER.createObjectNode().put(TYPE, RECORD).put("name", itemName).set("fields", (JsonNode)this.convertProperties(jsonItems.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonItems), schemaCounter, seenNames)) : this.convertProperty(itemName, jsonItems, true, schemaCounter, seenNames, true);
        JsonNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set(TYPE, MAPPER.createObjectNode().put(TYPE, ARRAY).set("items", avroItems));
        return Option.of((Object)avroNode);
    }

    private static Option<JsonNode> tryConvertEnumProperty(String name, JsonNode jsonProperty, AtomicInteger schemaCounter, Set<String> seenNames) {
        if (!JsonToAvroSchemaConverter.isJsonEnumType(jsonProperty)) {
            return Option.empty();
        }
        ArrayList enums = new ArrayList();
        jsonProperty.get("enum").iterator().forEachRemaining(e -> enums.add(e.asText()));
        TextNode avroType = enums.stream().allMatch(e -> SYMBOL_REGEX.matcher((CharSequence)e).matches()) ? MAPPER.createObjectNode().put(TYPE, "enum").put("name", JsonToAvroSchemaConverter.getAvroTypeName(jsonProperty, name, schemaCounter, seenNames)).set("symbols", jsonProperty.get("enum")) : TextNode.valueOf((String)STRING_TYPE);
        JsonNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set(TYPE, (JsonNode)avroType);
        return Option.of((Object)avroNode);
    }

    private JsonNode convertProperty(String name, JsonNode jsonProperty, boolean isRequired, AtomicInteger schemaCounter, Set<String> seenNames, boolean isArrayType) {
        JsonNode defaultNode;
        ObjectNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty));
        boolean nullable = !isRequired;
        HashSet avroSimpleTypeSet = new HashSet();
        ArrayList defaultValueList = new ArrayList();
        ArrayList<Object> avroComplexTypeSet = new ArrayList<Object>();
        boolean unionType = false;
        if (jsonProperty.hasNonNull("oneOf") || jsonProperty.hasNonNull("allOf")) {
            unionType = true;
            Option oneOfTypes = Option.ofNullable((Object)jsonProperty.get("oneOf"));
            Pair<Pair<Set<String>, List<JsonNode>>, List<JsonNode>> allOneOfTypes = this.getAllTypesFromOneOfAllOfTypes((Option<JsonNode>)oneOfTypes, name, schemaCounter, seenNames);
            avroSimpleTypeSet.addAll((Collection)((Pair)allOneOfTypes.getLeft()).getLeft());
            defaultValueList.addAll((Collection)((Pair)allOneOfTypes.getLeft()).getRight());
            avroComplexTypeSet.addAll((Collection)allOneOfTypes.getRight());
            Option allOfTypes = Option.ofNullable((Object)jsonProperty.get("allOf"));
            Object allAllOfTypes = this.getAllTypesFromOneOfAllOfTypes((Option<JsonNode>)allOfTypes, name, schemaCounter, seenNames);
            avroSimpleTypeSet.addAll((Collection)((Pair)allAllOfTypes.getLeft()).getLeft());
            avroComplexTypeSet.addAll((Collection)allAllOfTypes.getRight());
        } else if (jsonProperty.has(TYPE)) {
            Pair<Set<String>, Option<JsonNode>> types = this.getPrimitiveTypeFromType(jsonProperty);
            avroSimpleTypeSet.addAll((Collection)types.getLeft());
            if (((Option)types.getRight()).isPresent()) {
                avroComplexTypeSet.add(((Option)types.getRight()).get());
            }
        }
        List<String> avroTypes = new ArrayList<String>();
        if (nullable || avroSimpleTypeSet.contains("null")) {
            avroTypes.add("null");
        }
        avroSimpleTypeSet.remove("null");
        avroTypes.addAll(avroSimpleTypeSet);
        Object object = jsonProperty.has(DEFAULT_FIELD) ? jsonProperty.get(DEFAULT_FIELD) : (defaultNode = avroComplexTypeSet.isEmpty() && avroSimpleTypeSet.size() == 1 && !defaultValueList.isEmpty() ? (JsonNode)defaultValueList.get(0) : NullNode.getInstance());
        if (jsonProperty.has(DEFAULT_FIELD) || avroComplexTypeSet.isEmpty() && avroSimpleTypeSet.size() == 1 && !defaultValueList.isEmpty()) {
            if (this.convertDefaultValueType && avroComplexTypeSet.isEmpty() && avroSimpleTypeSet.size() == 1) {
                String defaultType = (String)avroSimpleTypeSet.stream().findFirst().get();
                switch (defaultType) {
                    case "long": {
                        defaultNode = LongNode.valueOf((long)Long.parseLong(defaultNode.asText()));
                        break;
                    }
                    case "double": {
                        defaultNode = DoubleNode.valueOf((double)Double.parseDouble(defaultNode.asText()));
                        break;
                    }
                    case "boolean": {
                        defaultNode = BooleanNode.valueOf((boolean)Boolean.parseBoolean(defaultNode.asText()));
                        break;
                    }
                    case "string": {
                        if (!this.stripDefaultValueQuotes) break;
                        defaultNode = TextNode.valueOf((String)JsonToAvroSchemaConverter.stripQuotesFromStringValue(defaultNode.asText()));
                        break;
                    }
                }
            }
            avroNode.set(DEFAULT_FIELD, defaultNode);
        } else if (nullable) {
            avroNode.set(DEFAULT_FIELD, defaultNode);
        }
        avroTypes = JsonToAvroSchemaConverter.arrangeTypeOrderOnDefault(avroTypes, defaultNode);
        List allTypes = avroTypes.stream().map(TextNode::valueOf).collect(Collectors.toList());
        allTypes.addAll(avroComplexTypeSet);
        ArrayNode typeValue = MAPPER.createArrayNode().addAll(allTypes);
        avroNode.set(TYPE, (JsonNode)(allTypes.size() > 1 ? typeValue : (JsonNode)allTypes.get(0)));
        return unionType && isArrayType ? typeValue : avroNode;
    }

    protected Pair<Set<String>, Option<JsonNode>> getPrimitiveTypeFromType(JsonNode jsonNode) {
        if (!jsonNode.has(TYPE)) {
            return Pair.of(Collections.emptySet(), (Object)Option.empty());
        }
        JsonNode typeNode = jsonNode.get(TYPE);
        if (!typeNode.isArray() && typeNode.asText().equals("number") && jsonNode.has(TITLE) && "org.apache.kafka.connect.data.Decimal".equals(jsonNode.get(TITLE).asText())) {
            return JsonToAvroSchemaConverter.convertKafkaConnectDecimal(jsonNode);
        }
        HashSet<String> avroSimpleTypeSet = new HashSet<String>();
        String jsonType = jsonNode.get(TYPE).asText();
        if (!jsonType.equals("object") && !jsonType.equals(ARRAY)) {
            avroSimpleTypeSet.add(JSON_TO_AVRO_TYPE.get(jsonType));
        }
        return Pair.of(avroSimpleTypeSet, (Object)Option.empty());
    }

    private static Pair<Set<String>, Option<JsonNode>> convertKafkaConnectDecimal(JsonNode jsonNode) {
        String connectType;
        String precision;
        String scale = "0";
        if (jsonNode.has(CONNECT_PARAMETERS)) {
            JsonNode parameters = jsonNode.get(CONNECT_PARAMETERS);
            if (!parameters.has(CONNECT_DECIMAL_PRECISION)) {
                throw new IllegalArgumentException("Missing connect.decimal.precision from properties in decimal type");
            }
            precision = parameters.get(CONNECT_DECIMAL_PRECISION).asText();
            if (parameters.has("scale")) {
                scale = parameters.get("scale").asText();
            }
        } else {
            throw new IllegalArgumentException("Missing connect.parameters from decimal type in json schema");
        }
        if (jsonNode.has(CONNECT_TYPE) && !(connectType = jsonNode.get(CONNECT_TYPE).asText()).equals("bytes")) {
            throw new IllegalArgumentException(connectType + " is not a supported type for decimal");
        }
        ObjectNode avroNode = MAPPER.createObjectNode().put(TYPE, "bytes").put("logicalType", "decimal").put("precision", Integer.valueOf(precision)).put("scale", Integer.valueOf(scale));
        return Pair.of(Collections.emptySet(), (Object)Option.of((Object)avroNode));
    }

    private Pair<Pair<Set<String>, List<JsonNode>>, List<JsonNode>> getAllTypesFromOneOfAllOfTypes(Option<JsonNode> jsonUnionType, String name, AtomicInteger schemaCounter, Set<String> seenNames) {
        HashSet avroSimpleTypeSet = new HashSet();
        ArrayList defaultValueList = new ArrayList();
        ArrayList avroComplexTypeSet = new ArrayList();
        if (jsonUnionType.isPresent()) {
            ((JsonNode)jsonUnionType.get()).elements().forEachRemaining(e -> {
                Pair<Set<String>, Option<JsonNode>> types = this.getPrimitiveTypeFromType((JsonNode)e);
                if (((Set)types.getLeft()).isEmpty() && !((Option)types.getRight()).isPresent()) {
                    if (JsonToAvroSchemaConverter.isJsonNestedType(e)) {
                        avroComplexTypeSet.add(((JsonNode)this.tryConvertNestedProperty(name, (JsonNode)e, schemaCounter, seenNames).get()).get(TYPE));
                        return;
                    } else if (JsonToAvroSchemaConverter.isJsonArrayType(e)) {
                        avroComplexTypeSet.add(((JsonNode)this.tryConvertArrayProperty(name, (JsonNode)e, schemaCounter, seenNames).get()).get(TYPE));
                        return;
                    } else {
                        if (!JsonToAvroSchemaConverter.isJsonEnumType(e)) throw new RuntimeException("unknown complex type encountered");
                        avroComplexTypeSet.add(((JsonNode)JsonToAvroSchemaConverter.tryConvertEnumProperty(name, e, schemaCounter, seenNames).get()).get(TYPE));
                    }
                    return;
                } else {
                    avroSimpleTypeSet.addAll((Collection)types.getLeft());
                    if (((Option)types.getRight()).isPresent()) {
                        avroComplexTypeSet.add(((Option)types.getRight()).get());
                    }
                    if (!e.has(DEFAULT_FIELD)) return;
                    defaultValueList.add(e.get(DEFAULT_FIELD));
                }
            });
        }
        return Pair.of((Object)Pair.of(avroSimpleTypeSet, defaultValueList), avroComplexTypeSet);
    }

    private static List<String> arrangeTypeOrderOnDefault(List<String> avroTypes, JsonNode defaultNode) {
        if (defaultNode == null || defaultNode.isNull()) {
            return avroTypes;
        }
        HashSet<String> avroTypesSet = new HashSet<String>(avroTypes);
        if (defaultNode.isInt() || defaultNode.isBigInteger() || defaultNode.isIntegralNumber()) {
            return JsonToAvroSchemaConverter.modifyListOrderingBasedOnDefaultValue(avroTypes, avroTypesSet, LONG_TYPE);
        }
        if (defaultNode.isNumber() || defaultNode.isBigDecimal() || defaultNode.isDouble() || defaultNode.isFloatingPointNumber()) {
            return JsonToAvroSchemaConverter.modifyListOrderingBasedOnDefaultValue(avroTypes, avroTypesSet, DOUBLE_TYPE);
        }
        if (defaultNode.isTextual()) {
            return JsonToAvroSchemaConverter.modifyListOrderingBasedOnDefaultValue(avroTypes, avroTypesSet, STRING_TYPE);
        }
        if (defaultNode.isBoolean()) {
            return JsonToAvroSchemaConverter.modifyListOrderingBasedOnDefaultValue(avroTypes, avroTypesSet, BOOLEAN_TYPE);
        }
        return avroTypes;
    }

    private static List<String> modifyListOrderingBasedOnDefaultValue(List<String> typeList, Set<String> avroTypesSet, String type) {
        ArrayList<String> modifiedAvroTypeList = new ArrayList<String>();
        if (avroTypesSet.contains(type)) {
            modifiedAvroTypeList.add(type);
            avroTypesSet.remove(type);
            modifiedAvroTypeList.addAll(avroTypesSet);
            return modifiedAvroTypeList;
        }
        return typeList;
    }

    private static boolean isJsonNestedType(JsonNode jsonNode) {
        return jsonNode.has(TYPE) && Objects.equals(jsonNode.get(TYPE).asText(), "object");
    }

    private static boolean isJsonArrayType(JsonNode jsonNode) {
        return jsonNode.has(TYPE) && Objects.equals(jsonNode.get(TYPE).asText(), ARRAY);
    }

    private static boolean isJsonEnumType(JsonNode jsonNode) {
        return jsonNode.hasNonNull("enum") && jsonNode.get("enum").isArray();
    }

    private static Option<String> getAvroSchemaRecordNamespace(JsonNode jsonNode) {
        if (jsonNode.hasNonNull("$id")) {
            String host = URI.create(jsonNode.get("$id").asText()).getHost();
            String avroNamespace = Stream.of(host.split("\\.")).map(JsonToAvroSchemaConverter::sanitizeAsAvroName).collect(Collectors.joining("."));
            return Option.of((Object)avroNamespace);
        }
        return Option.empty();
    }

    private static String getAvroSchemaRecordName(JsonNode jsonNode) {
        if (jsonNode.hasNonNull(TITLE)) {
            return JsonToAvroSchemaConverter.sanitizeAsAvroName(jsonNode.get(TITLE).asText());
        }
        if (jsonNode.hasNonNull("$id")) {
            String host = URI.create(jsonNode.get("$id").asText()).getHost();
            String domain = JsonToAvroSchemaConverter.removeSuffixBy(host, 46);
            return JsonToAvroSchemaConverter.sanitizeAsAvroName(JsonToAvroSchemaConverter.getSuffixBy(domain, 46));
        }
        return "no_name";
    }

    private static String sanitizeAsAvroName(String s) {
        return s.replaceAll("[^A-Za-z0-9_]+", "_");
    }

    private static Set<String> getRequired(JsonNode jsonNode) {
        if (!jsonNode.hasNonNull("required")) {
            return Collections.emptySet();
        }
        JsonNode requiredNode = jsonNode.get("required");
        HashSet<String> required = new HashSet<String>(requiredNode.size());
        jsonNode.get("required").elements().forEachRemaining(e -> required.add(e.asText()));
        return required;
    }

    private static String getAvroTypeName(JsonNode jsonNode, String defaultName, AtomicInteger schemaCounter, Set<String> seenNames) {
        String typeName;
        String string = typeName = jsonNode.hasNonNull(TITLE) ? jsonNode.get(TITLE).asText() : defaultName;
        if (!seenNames.contains(typeName)) {
            seenNames.add(typeName);
            return typeName;
        }
        String modifiedTypeName = typeName + schemaCounter.getAndIncrement();
        seenNames.add(modifiedTypeName);
        return modifiedTypeName;
    }

    private static String getAvroDoc(JsonNode jsonNode) {
        return jsonNode.hasNonNull("description") ? jsonNode.get("description").asText() : "";
    }

    public static String getSuffixBy(String input, int ch) {
        int i = input.lastIndexOf(ch);
        if (i == -1) {
            return input;
        }
        return input.substring(i);
    }

    public static String removeSuffixBy(String input, int ch) {
        int i = input.lastIndexOf(ch);
        if (i == -1) {
            return input;
        }
        return input.substring(0, i);
    }

    public static String stripQuotesFromStringValue(String input) {
        if (input != null && input.length() >= 2 && input.charAt(0) == '\"' && input.charAt(input.length() - 1) == '\"') {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }
}

