/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.JsonKafkaPostProcessorConfig;
import org.apache.hudi.utilities.exception.HoodieSourcePostProcessException;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.KafkaSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.hudi.utilities.sources.processor.JsonKafkaSourcePostProcessor;
import org.apache.hudi.utilities.streamer.DefaultStreamContext;
import org.apache.hudi.utilities.streamer.SourceProfileSupplier;
import org.apache.hudi.utilities.streamer.StreamContext;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonKafkaSource
extends KafkaSource<JavaRDD<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonKafkaSource.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieIngestionMetrics metrics) {
        this(properties, sparkContext, sparkSession, metrics, (StreamContext)new DefaultStreamContext(schemaProvider, (Option<SourceProfileSupplier>)Option.empty()));
    }

    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, HoodieIngestionMetrics metrics, StreamContext streamContext) {
        super(properties, sparkContext, sparkSession, Source.SourceType.JSON, metrics, new DefaultStreamContext(UtilHelpers.getSchemaProviderForKafkaSource(streamContext.getSchemaProvider(), properties, sparkContext), streamContext.getSourceProfileSupplier()));
        this.props.put((Object)"key.deserializer", (Object)StringDeserializer.class.getName());
        this.props.put((Object)"value.deserializer", (Object)ConfigUtils.getStringWithAltKeys((Properties)this.props, Config.KAFKA_JSON_VALUE_DESERIALIZER_CLASS, (boolean)true));
        this.offsetGen = new KafkaOffsetGen(this.props);
    }

    @Override
    protected JavaRDD<String> toBatch(OffsetRange[] offsetRanges) {
        String deserializerClass = this.props.getString("value.deserializer");
        JavaRDD kafkaRDD = KafkaUtils.createRDD((JavaSparkContext)this.sparkContext, this.offsetGen.getKafkaParams(), (OffsetRange[])offsetRanges, (LocationStrategy)LocationStrategies.PreferConsistent()).filter((Function & Serializable)x -> JsonKafkaSource.filterForNullValues(x.value(), deserializerClass));
        return this.postProcess(this.maybeAppendKafkaOffsets((JavaRDD<ConsumerRecord<Object, Object>>)kafkaRDD, deserializerClass));
    }

    protected JavaRDD<String> maybeAppendKafkaOffsets(JavaRDD<ConsumerRecord<Object, Object>> kafkaRDD, String deserializerClass) {
        if (this.shouldAddOffsets) {
            return kafkaRDD.mapPartitions((FlatMapFunction & Serializable)partitionIterator -> {
                TaskContext taskContext = TaskContext.get();
                LOG.info("Converting Kafka source objects to strings with stageId : {}, stage attempt no: {}, taskId : {}, task attempt no : {}, task attempt id : {} ", new Object[]{taskContext.stageId(), taskContext.stageAttemptNumber(), taskContext.partitionId(), taskContext.attemptNumber(), taskContext.taskAttemptId()});
                return new CloseableMappingIterator(ClosableIterator.wrap((Iterator)partitionIterator), consumerRecord -> {
                    String recordKey;
                    String record;
                    try {
                        record = JsonKafkaSource.getValueAsString(consumerRecord.value(), deserializerClass);
                        recordKey = StringUtils.objToString((Object)consumerRecord.key());
                    }
                    catch (JsonProcessingException e) {
                        throw new HoodieException((Throwable)e);
                    }
                    try {
                        ObjectNode jsonNode = (ObjectNode)OBJECT_MAPPER.readTree(record);
                        jsonNode.put("_hoodie_kafka_source_offset", consumerRecord.offset());
                        jsonNode.put("_hoodie_kafka_source_partition", consumerRecord.partition());
                        jsonNode.put("_hoodie_kafka_source_timestamp", consumerRecord.timestamp());
                        if (recordKey != null) {
                            jsonNode.put("_hoodie_kafka_source_key", recordKey);
                        }
                        return OBJECT_MAPPER.writeValueAsString((Object)jsonNode);
                    }
                    catch (Throwable e) {
                        return record;
                    }
                });
            });
        }
        return kafkaRDD.map((Function & Serializable)consumerRecord -> {
            try {
                return JsonKafkaSource.getValueAsString(consumerRecord.value(), deserializerClass);
            }
            catch (JsonProcessingException e) {
                throw new HoodieException((Throwable)e);
            }
        });
    }

    private JavaRDD<String> postProcess(JavaRDD<String> jsonStringRDD) {
        JsonKafkaSourcePostProcessor processor;
        String postProcessorClassName = ConfigUtils.getStringWithAltKeys((Properties)this.props, JsonKafkaPostProcessorConfig.JSON_KAFKA_PROCESSOR_CLASS, (boolean)true);
        if (StringUtils.isNullOrEmpty((String)postProcessorClassName)) {
            return jsonStringRDD;
        }
        try {
            processor = UtilHelpers.createJsonKafkaSourcePostProcessor(postProcessorClassName, this.props);
        }
        catch (IOException e) {
            throw new HoodieSourcePostProcessException("Could not init " + postProcessorClassName, e);
        }
        return processor.process(jsonStringRDD);
    }

    private static Boolean filterForNullValues(Object value, String valueDeserializerClass) {
        if (value == null) {
            return false;
        }
        if (valueDeserializerClass.equals(StringDeserializer.class.getName())) {
            return StringUtils.nonEmpty((String)((String)value));
        }
        return true;
    }

    private static String getValueAsString(Object value, String valueDeserializerClass) throws JsonProcessingException {
        if (StringDeserializer.class.getName().equals(valueDeserializerClass)) {
            return (String)value;
        }
        return OBJECT_MAPPER.writeValueAsString(value);
    }

    public static class Config {
        public static final ConfigProperty<String> KAFKA_JSON_VALUE_DESERIALIZER_CLASS = ConfigProperty.key((String)"hoodie.deltastreamer.source.kafka.json.value.deserializer.class").defaultValue((Object)StringDeserializer.class.getName()).sinceVersion("1.1.0").withDocumentation("Kafka Json Payload Deserializer Class");
    }
}

