/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.config.ParquetDFSSourceConfig;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.helpers.DFSPathSelector;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class ParquetDFSSource
extends RowSource {
    private final DFSPathSelector pathSelector;

    public ParquetDFSSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        this.pathSelector = DFSPathSelector.createSourceSelector(props, this.sparkContext.hadoopConfiguration());
    }

    @Override
    public Pair<Option<Dataset<Row>>, Checkpoint> fetchNextBatch(Option<Checkpoint> lastCheckpoint, long sourceLimit) {
        Pair<Option<String>, Checkpoint> selectPathsWithMaxModificationTime = this.pathSelector.getNextFilePathsAndMaxModificationTime(this.sparkContext, lastCheckpoint, sourceLimit);
        return (Pair)((Option)selectPathsWithMaxModificationTime.getLeft()).map(pathStr -> Pair.of((Object)Option.of(this.fromFiles((String)pathStr)), (Object)selectPathsWithMaxModificationTime.getRight())).orElseGet(() -> Pair.of((Object)Option.empty(), (Object)selectPathsWithMaxModificationTime.getRight()));
    }

    private Dataset<Row> fromFiles(String pathStr) {
        boolean mergeSchemaOption = ConfigUtils.getBooleanWithAltKeys((Properties)this.props, ParquetDFSSourceConfig.PARQUET_DFS_MERGE_SCHEMA);
        return this.sparkSession.read().option("mergeSchema", mergeSchemaOption).parquet(pathStr.split(","));
    }
}

