/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers.gcs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.sources.helpers.gcs.MessageValidity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataMessage {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataMessage.class);
    private final PubsubMessage message;
    private static final String EVENT_NAME_OBJECT_FINALIZE = "OBJECT_FINALIZE";
    private static final String ATTR_EVENT_TYPE = "eventType";
    private static final String ATTR_OBJECT_ID = "objectId";
    private static final String ATTR_OVERWROTE_GENERATION = "overwroteGeneration";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public MetadataMessage(PubsubMessage message) {
        this.message = message;
    }

    public String toStringUtf8() {
        return this.message.getData().toStringUtf8();
    }

    public MessageValidity shouldBeProcessed() {
        if (!this.isNewFileCreation()) {
            return new MessageValidity(MessageValidity.ProcessingDecision.DO_SKIP, "eventType: " + this.getEventType() + ". Not a file creation message.");
        }
        if (this.isOverwriteOfExistingFile()) {
            return new MessageValidity(MessageValidity.ProcessingDecision.DO_SKIP, "eventType: " + this.getEventType() + ". Overwrite of existing objectId: " + this.getObjectId() + " with generation number: " + this.getOverwroteGeneration());
        }
        try {
            if (this.isEmptyFile()) {
                return new MessageValidity(MessageValidity.ProcessingDecision.DO_SKIP, "Object " + this.getObjectId() + " is empty.");
            }
        }
        catch (IOException e) {
            LOG.error("Exception while extracting the size for object " + this.getObjectId(), (Throwable)e);
        }
        return MessageValidity.DEFAULT_VALID_MESSAGE;
    }

    private boolean isOverwriteOfExistingFile() {
        return !StringUtils.isNullOrEmpty((String)this.getOverwroteGeneration());
    }

    private boolean isNewFileCreation() {
        return EVENT_NAME_OBJECT_FINALIZE.equals(this.getEventType());
    }

    private boolean isEmptyFile() throws IOException {
        String sizeValue = this.getDataField("size");
        long size = Long.parseLong(sizeValue);
        return size <= 0L;
    }

    public String getEventType() {
        return this.getAttr(ATTR_EVENT_TYPE);
    }

    public String getObjectId() {
        return this.getAttr(ATTR_OBJECT_ID);
    }

    public String getOverwroteGeneration() {
        return this.getAttr(ATTR_OVERWROTE_GENERATION);
    }

    private String getAttr(String attrName) {
        return (String)this.message.getAttributesMap().get(attrName);
    }

    private String getDataField(String fieldName) throws IOException {
        JsonNode root = (JsonNode)OBJECT_MAPPER.readValue(this.toStringUtf8(), JsonNode.class);
        JsonNode fieldNode = root.get(fieldName);
        return fieldNode.asText();
    }
}

