/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.exception.HoodieTransformPlanException;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class ChainedTransformer
implements Transformer {
    private static final String ID_TRANSFORMER_CLASS_NAME_DELIMITER = ":";
    protected final List<TransformerInfo> transformers;
    private final Supplier<Option<Schema>> sourceSchemaSupplier;

    public ChainedTransformer(List<Transformer> transformersList) {
        this.transformers = new ArrayList<TransformerInfo>(transformersList.size());
        for (Transformer transformer : transformersList) {
            this.transformers.add(new TransformerInfo(transformer));
        }
        this.sourceSchemaSupplier = Option::empty;
    }

    public ChainedTransformer(List<String> configuredTransformers, Supplier<Option<Schema>> sourceSchemaSupplier) {
        this.transformers = new ArrayList<TransformerInfo>(configuredTransformers.size());
        this.sourceSchemaSupplier = sourceSchemaSupplier;
        HashSet<String> identifiers = new HashSet<String>();
        for (String configuredTransformer : configuredTransformers) {
            if (!configuredTransformer.contains(ID_TRANSFORMER_CLASS_NAME_DELIMITER)) {
                this.transformers.add(new TransformerInfo((Transformer)ReflectionUtils.loadClass((String)configuredTransformer)));
                continue;
            }
            String[] splits = configuredTransformer.split(ID_TRANSFORMER_CLASS_NAME_DELIMITER);
            if (splits.length > 2) {
                throw new HoodieTransformPlanException("There should only be one colon in a configured transformer");
            }
            String id = splits[0];
            this.validateIdentifier(id, identifiers, configuredTransformer);
            Transformer transformer = (Transformer)ReflectionUtils.loadClass((String)splits[1]);
            this.transformers.add(new TransformerInfo(transformer, id));
        }
        if (!this.transformers.stream().allMatch(rec$ -> ((TransformerInfo)rec$).hasIdentifier()) && !this.transformers.stream().noneMatch(rec$ -> ((TransformerInfo)rec$).hasIdentifier())) {
            throw new HoodieTransformPlanException("Either all transformers should have identifier or none should");
        }
    }

    public List<String> getTransformersNames() {
        return this.transformers.stream().map(t -> t.getTransformer().getClass().getName()).collect(Collectors.toList());
    }

    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        Dataset<Row> dataset = rowDataset;
        for (TransformerInfo transformerInfo : this.transformers) {
            Transformer transformer = transformerInfo.getTransformer();
            dataset = transformer.apply(jsc, sparkSession, dataset, transformerInfo.getProperties(properties, this.transformers));
        }
        return dataset;
    }

    private void validateIdentifier(String id, Set<String> identifiers, String configuredTransformer) {
        if (StringUtils.isNullOrEmpty((String)id)) {
            throw new HoodieTransformPlanException(String.format("Transformer identifier is empty for %s", configuredTransformer));
        }
        if (identifiers.contains(id)) {
            throw new HoodieTransformPlanException(String.format("Duplicate identifier %s found for transformer %s", id, configuredTransformer));
        }
        identifiers.add(id);
    }

    private StructType getExpectedTransformedSchema(TransformerInfo transformerInfo, JavaSparkContext jsc, SparkSession sparkSession, Option<StructType> incomingStructOpt, Option<Dataset<Row>> rowDatasetOpt, TypedProperties properties) {
        Option<Schema> sourceSchemaOpt = this.sourceSchemaSupplier.get();
        if (!sourceSchemaOpt.isPresent() && !rowDatasetOpt.isPresent()) {
            throw new HoodieTransformPlanException("Either source schema or source dataset should be available to fetch the schema");
        }
        StructType incomingStruct = (StructType)incomingStructOpt.orElseGet(() -> sourceSchemaOpt.isPresent() ? AvroConversionUtils.convertAvroSchemaToStructType((Schema)((Schema)sourceSchemaOpt.get())) : ((Dataset)rowDatasetOpt.get()).schema());
        return transformerInfo.getTransformer().transformedSchema(jsc, sparkSession, incomingStruct, properties).asNullable();
    }

    @Override
    public StructType transformedSchema(JavaSparkContext jsc, SparkSession sparkSession, StructType incomingStruct, TypedProperties properties) {
        Option expectedTargetStructOpt = Option.ofNullable((Object)incomingStruct);
        for (TransformerInfo transformerInfo : this.transformers) {
            expectedTargetStructOpt = Option.of((Object)this.getExpectedTransformedSchema(transformerInfo, jsc, sparkSession, (Option<StructType>)expectedTargetStructOpt, (Option<Dataset<Row>>)Option.empty(), properties));
        }
        return (StructType)expectedTargetStructOpt.get();
    }

    protected static class TransformerInfo {
        private final Transformer transformer;
        private final Option<String> idOpt;

        private TransformerInfo(Transformer transformer, String id) {
            this.transformer = transformer;
            this.idOpt = Option.of((Object)id);
        }

        private TransformerInfo(Transformer transformer) {
            this.transformer = transformer;
            this.idOpt = Option.empty();
        }

        protected Transformer getTransformer() {
            return this.transformer;
        }

        private boolean hasIdentifier() {
            return this.idOpt.isPresent();
        }

        protected TypedProperties getProperties(TypedProperties properties, List<TransformerInfo> transformers) {
            Set transformerIds = transformers.stream().map(transformerInfo -> (String)transformerInfo.idOpt.orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
            TypedProperties transformerProps = properties;
            if (this.idOpt.isPresent()) {
                String id = (String)this.idOpt.get();
                transformerProps = TypedProperties.copy((Properties)properties);
                HashMap overrideKeysMap = new HashMap();
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String keyId = key.replaceAll(".*\\.", "");
                    if (keyId.equals(id)) {
                        overrideKeysMap.put(key.substring(0, key.length() - (id.length() + 1)), entry.getValue());
                    }
                    if (!transformerIds.contains(keyId)) continue;
                    transformerProps.remove((Object)key);
                }
                transformerProps.putAll(overrideKeysMap);
            }
            return transformerProps;
        }
    }
}

