/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.schema;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hugegraph.controller.BaseController;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.LabelUpdateEntity;
import org.apache.hugegraph.entity.schema.Property;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.PropertyKeyEntity;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaLabelEntity;
import org.apache.hugegraph.entity.schema.Timefiable;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.service.schema.EdgeLabelService;
import org.apache.hugegraph.service.schema.PropertyKeyService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.structure.constant.IdStrategy;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/schema"})
public class SchemaController
extends BaseController {
    @Autowired
    private PropertyKeyService pkService;
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private EdgeLabelService elService;

    @GetMapping(value={"graphview"})
    public SchemaView displayInSchemaView(@PathVariable(value="connId") int connId) {
        List<PropertyKeyEntity> propertyKeys = this.pkService.list(connId);
        List<VertexLabelEntity> vertexLabels = this.vlService.list(connId);
        List<EdgeLabelEntity> edgeLabels = this.elService.list(connId);
        ArrayList<Map<String, Object>> vertices = new ArrayList<Map<String, Object>>(vertexLabels.size());
        for (VertexLabelEntity entity : vertexLabels) {
            LinkedHashMap<String, Object> vertex = new LinkedHashMap<String, Object>();
            vertex.put("id", entity.getName());
            vertex.put("label", entity.getName());
            if (entity.getIdStrategy() == IdStrategy.PRIMARY_KEY) {
                vertex.put("primary_keys", entity.getPrimaryKeys());
            } else {
                vertex.put("primary_keys", new ArrayList());
            }
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            this.fillProperties(properties, entity, propertyKeys);
            vertex.put("properties", properties);
            vertex.put("~style", entity.getStyle());
            vertices.add(vertex);
        }
        ArrayList<Map<String, Object>> edges = new ArrayList<Map<String, Object>>(edgeLabels.size());
        for (EdgeLabelEntity entity : edgeLabels) {
            LinkedHashMap<String, Object> edge = new LinkedHashMap<String, Object>();
            String edgeId = String.format("%s-%s->%s", entity.getSourceLabel(), entity.getName(), entity.getTargetLabel());
            edge.put("id", edgeId);
            edge.put("label", entity.getName());
            edge.put("source", entity.getSourceLabel());
            edge.put("target", entity.getTargetLabel());
            if (entity.isLinkMultiTimes()) {
                edge.put("sort_keys", entity.getSortKeys());
            } else {
                edge.put("sort_keys", new ArrayList());
            }
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            this.fillProperties(properties, entity, propertyKeys);
            edge.put("properties", properties);
            edge.put("~style", entity.getStyle());
            edges.add(edge);
        }
        return new SchemaView(vertices, edges);
    }

    private void fillProperties(Map<String, String> properties, SchemaLabelEntity entity, List<PropertyKeyEntity> propertyKeys) {
        for (Property property : entity.getProperties()) {
            String name = property.getName();
            PropertyKeyEntity pkEntity = this.findPropertyKey(propertyKeys, name);
            properties.put(name, pkEntity.getDataType().string());
        }
    }

    private PropertyKeyEntity findPropertyKey(List<PropertyKeyEntity> entities, String name) {
        for (PropertyKeyEntity entity : entities) {
            if (!entity.getName().equals(name)) continue;
            return entity;
        }
        throw new InternalException("schema.propertykey.not-exist", name);
    }

    public <T extends SchemaEntity> IPage<T> listInPage(Function<Integer, List<T>> fetcher, int connId, String content, String nameOrder, int pageNo, int pageSize) {
        Boolean nameOrderAsc = null;
        if (!StringUtils.isEmpty((Object)nameOrder)) {
            Ex.check("asc".equals(nameOrder) || "desc".equals(nameOrder), "common.name-order.invalid", nameOrder);
            nameOrderAsc = "asc".equals(nameOrder);
        }
        List<T> entities = fetcher.apply(connId);
        if (!StringUtils.isEmpty((Object)content)) {
            entities = entities.stream().filter(c -> c.getName().contains(content)).collect(Collectors.toList());
            if (nameOrderAsc != null) {
                this.sortByName(entities, nameOrderAsc);
            } else {
                this.sortByRelativity(entities, content);
            }
        } else if (nameOrderAsc != null) {
            this.sortByName(entities, nameOrderAsc);
        } else {
            this.sortByCreateTime(entities, false);
        }
        return PageUtil.page(entities, pageNo, pageSize);
    }

    public <T extends SchemaEntity> void sortByName(List<T> entities, boolean asc) {
        if (asc) {
            entities.sort(Comparator.comparing(SchemaEntity::getName));
        } else {
            entities.sort(Comparator.comparing(SchemaEntity::getName).reversed());
        }
    }

    public <T extends SchemaEntity> void sortByCreateTime(List<T> entities, boolean asc) {
        Comparator dateAscComparator = (o1, o2) -> {
            assert (o1 instanceof Timefiable);
            assert (o2 instanceof Timefiable);
            Date t1 = ((Timefiable)((Object)o1)).getCreateTime();
            Date t2 = ((Timefiable)((Object)o2)).getCreateTime();
            if (t1 == null && t2 == null) {
                return 0;
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return t1.compareTo(t2);
        };
        if (asc) {
            entities.sort(dateAscComparator);
        } else {
            entities.sort(dateAscComparator.reversed());
        }
    }

    public <T extends SchemaEntity> void sortByRelativity(List<T> entities, String content) {
        Comparator occurrencesComparator = (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            int count1 = StringUtils.countOccurrencesOf((String)name1, (String)content);
            int count2 = StringUtils.countOccurrencesOf((String)name2, (String)content);
            return count2 - count1;
        };
        entities.sort(occurrencesComparator);
    }

    public static void checkProperties(PropertyKeyService service, Set<Property> properties, boolean mustNullable, int connId) {
        if (properties == null) {
            return;
        }
        for (Property property : properties) {
            String pkName = property.getName();
            service.checkExist(pkName, connId);
            Ex.check(mustNullable, property::isNullable, "schema.propertykey.must-be-nullable", pkName);
        }
    }

    public static void checkPropertyIndexes(SchemaLabelEntity entity, int connId) {
        List<PropertyIndex> propertyIndexes = entity.getPropertyIndexes();
        if (propertyIndexes != null) {
            for (PropertyIndex propertyIndex : propertyIndexes) {
                Ex.check(propertyIndex.getOwner() == null, "common.param.must-be-null", "property_index.owner");
                Ex.check(propertyIndex.getName() != null, "common.param.cannot-be-null", "property_index.name");
                Ex.check(propertyIndex.getSchemaType() != null, "common.param.cannot-be-null", "property_index.type");
                Ex.check(propertyIndex.getFields() != null, "common.param.cannot-be-null", "property_index.fields");
            }
        }
    }

    public static void checkParamsValid(PropertyKeyService service, LabelUpdateEntity entity, int connId) {
        SchemaController.checkProperties(service, entity.getAppendProperties(), true, connId);
    }

    private static class SchemaView {
        @JsonProperty(value="vertices")
        private List<Map<String, Object>> vertices;
        @JsonProperty(value="edges")
        private List<Map<String, Object>> edges;

        public SchemaView(List<Map<String, Object>> vertices, List<Map<String, Object>> edges) {
            this.vertices = vertices;
            this.edges = edges;
        }
    }
}

