/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.entity.schema.ConflictStatus;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.PropertyKeyEntity;
import org.apache.hugegraph.entity.schema.SchemaConflict;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.springframework.util.CollectionUtils;

public class ConflictDetail {
    @JsonProperty(value="type")
    private SchemaType type;
    @JsonProperty(value="propertykey_conflicts")
    private List<SchemaConflict<PropertyKeyEntity>> pkConflicts;
    @JsonProperty(value="propertyindex_conflicts")
    private List<SchemaConflict<PropertyIndex>> piConflicts;
    @JsonProperty(value="vertexlabel_conflicts")
    private List<SchemaConflict<VertexLabelEntity>> vlConflicts;
    @JsonProperty(value="edgelabel_conflicts")
    private List<SchemaConflict<EdgeLabelEntity>> elConflicts;

    @JsonCreator
    public ConflictDetail(SchemaType type) {
        this.type = type;
        this.pkConflicts = new ArrayList<SchemaConflict<PropertyKeyEntity>>();
        this.piConflicts = new ArrayList<SchemaConflict<PropertyIndex>>();
        this.vlConflicts = new ArrayList<SchemaConflict<VertexLabelEntity>>();
        this.elConflicts = new ArrayList<SchemaConflict<EdgeLabelEntity>>();
    }

    public <T extends SchemaEntity> List<SchemaConflict<T>> getConflicts(SchemaType type) {
        switch (type) {
            case PROPERTY_KEY: {
                return this.pkConflicts;
            }
            case PROPERTY_INDEX: {
                return this.piConflicts;
            }
            case VERTEX_LABEL: {
                return this.vlConflicts;
            }
            case EDGE_LABEL: {
                return this.elConflicts;
            }
        }
        throw new AssertionError((Object)String.format("Unknown schema type '%s'", new Object[]{type}));
    }

    public void add(PropertyKeyEntity entity, ConflictStatus status) {
        this.pkConflicts.add(new SchemaConflict<PropertyKeyEntity>(entity, status));
    }

    public void add(PropertyIndex entity, ConflictStatus status) {
        this.piConflicts.add(new SchemaConflict<PropertyIndex>(entity, status));
    }

    public void add(VertexLabelEntity entity, ConflictStatus status) {
        this.vlConflicts.add(new SchemaConflict<VertexLabelEntity>(entity, status));
    }

    public void add(EdgeLabelEntity entity, ConflictStatus status) {
        this.elConflicts.add(new SchemaConflict<EdgeLabelEntity>(entity, status));
    }

    public boolean anyPropertyKeyConflict(Collection<String> names) {
        return this.anyConflict(this.pkConflicts, names);
    }

    public boolean anyPropertyIndexConflict(Collection<String> names) {
        return this.anyConflict(this.piConflicts, names);
    }

    public boolean anyVertexLabelConflict(Collection<String> names) {
        return this.anyConflict(this.vlConflicts, names);
    }

    private <T extends SchemaEntity> boolean anyConflict(List<SchemaConflict<T>> conflicts, Collection<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return false;
        }
        return conflicts.stream().anyMatch(conflict -> {
            String name = conflict.getEntity().getName();
            return conflict.getStatus().isConflicted() && names.contains(name);
        });
    }

    public boolean hasConflict() {
        for (SchemaConflict<PropertyKeyEntity> schemaConflict : this.pkConflicts) {
            if (!schemaConflict.getStatus().isConflicted()) continue;
            return true;
        }
        for (SchemaConflict<SchemaEntity> schemaConflict : this.piConflicts) {
            if (!schemaConflict.getStatus().isConflicted()) continue;
            return true;
        }
        for (SchemaConflict<SchemaEntity> schemaConflict : this.vlConflicts) {
            if (!schemaConflict.getStatus().isConflicted()) continue;
            return true;
        }
        for (SchemaConflict<SchemaEntity> schemaConflict : this.elConflicts) {
            if (!schemaConflict.getStatus().isConflicted()) continue;
            return true;
        }
        return false;
    }

    public static ConflictDetailBuilder builder() {
        return new ConflictDetailBuilder();
    }

    public SchemaType getType() {
        return this.type;
    }

    public List<SchemaConflict<PropertyKeyEntity>> getPkConflicts() {
        return this.pkConflicts;
    }

    public List<SchemaConflict<PropertyIndex>> getPiConflicts() {
        return this.piConflicts;
    }

    public List<SchemaConflict<VertexLabelEntity>> getVlConflicts() {
        return this.vlConflicts;
    }

    public List<SchemaConflict<EdgeLabelEntity>> getElConflicts() {
        return this.elConflicts;
    }

    @JsonProperty(value="type")
    public void setType(SchemaType type) {
        this.type = type;
    }

    @JsonProperty(value="propertykey_conflicts")
    public void setPkConflicts(List<SchemaConflict<PropertyKeyEntity>> pkConflicts) {
        this.pkConflicts = pkConflicts;
    }

    @JsonProperty(value="propertyindex_conflicts")
    public void setPiConflicts(List<SchemaConflict<PropertyIndex>> piConflicts) {
        this.piConflicts = piConflicts;
    }

    @JsonProperty(value="vertexlabel_conflicts")
    public void setVlConflicts(List<SchemaConflict<VertexLabelEntity>> vlConflicts) {
        this.vlConflicts = vlConflicts;
    }

    @JsonProperty(value="edgelabel_conflicts")
    public void setElConflicts(List<SchemaConflict<EdgeLabelEntity>> elConflicts) {
        this.elConflicts = elConflicts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConflictDetail)) {
            return false;
        }
        ConflictDetail other = (ConflictDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<SchemaConflict<PropertyKeyEntity>> this$pkConflicts = this.getPkConflicts();
        List<SchemaConflict<PropertyKeyEntity>> other$pkConflicts = other.getPkConflicts();
        if (this$pkConflicts == null ? other$pkConflicts != null : !((Object)this$pkConflicts).equals(other$pkConflicts)) {
            return false;
        }
        List<SchemaConflict<PropertyIndex>> this$piConflicts = this.getPiConflicts();
        List<SchemaConflict<PropertyIndex>> other$piConflicts = other.getPiConflicts();
        if (this$piConflicts == null ? other$piConflicts != null : !((Object)this$piConflicts).equals(other$piConflicts)) {
            return false;
        }
        List<SchemaConflict<VertexLabelEntity>> this$vlConflicts = this.getVlConflicts();
        List<SchemaConflict<VertexLabelEntity>> other$vlConflicts = other.getVlConflicts();
        if (this$vlConflicts == null ? other$vlConflicts != null : !((Object)this$vlConflicts).equals(other$vlConflicts)) {
            return false;
        }
        List<SchemaConflict<EdgeLabelEntity>> this$elConflicts = this.getElConflicts();
        List<SchemaConflict<EdgeLabelEntity>> other$elConflicts = other.getElConflicts();
        return !(this$elConflicts == null ? other$elConflicts != null : !((Object)this$elConflicts).equals(other$elConflicts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConflictDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<SchemaConflict<PropertyKeyEntity>> $pkConflicts = this.getPkConflicts();
        result = result * 59 + ($pkConflicts == null ? 43 : ((Object)$pkConflicts).hashCode());
        List<SchemaConflict<PropertyIndex>> $piConflicts = this.getPiConflicts();
        result = result * 59 + ($piConflicts == null ? 43 : ((Object)$piConflicts).hashCode());
        List<SchemaConflict<VertexLabelEntity>> $vlConflicts = this.getVlConflicts();
        result = result * 59 + ($vlConflicts == null ? 43 : ((Object)$vlConflicts).hashCode());
        List<SchemaConflict<EdgeLabelEntity>> $elConflicts = this.getElConflicts();
        result = result * 59 + ($elConflicts == null ? 43 : ((Object)$elConflicts).hashCode());
        return result;
    }

    public String toString() {
        return "ConflictDetail(type=" + (Object)((Object)this.getType()) + ", pkConflicts=" + this.getPkConflicts() + ", piConflicts=" + this.getPiConflicts() + ", vlConflicts=" + this.getVlConflicts() + ", elConflicts=" + this.getElConflicts() + ")";
    }

    public ConflictDetail() {
    }

    public ConflictDetail(SchemaType type, List<SchemaConflict<PropertyKeyEntity>> pkConflicts, List<SchemaConflict<PropertyIndex>> piConflicts, List<SchemaConflict<VertexLabelEntity>> vlConflicts, List<SchemaConflict<EdgeLabelEntity>> elConflicts) {
        this.type = type;
        this.pkConflicts = pkConflicts;
        this.piConflicts = piConflicts;
        this.vlConflicts = vlConflicts;
        this.elConflicts = elConflicts;
    }

    public static class ConflictDetailBuilder {
        private SchemaType type;
        private List<SchemaConflict<PropertyKeyEntity>> pkConflicts;
        private List<SchemaConflict<PropertyIndex>> piConflicts;
        private List<SchemaConflict<VertexLabelEntity>> vlConflicts;
        private List<SchemaConflict<EdgeLabelEntity>> elConflicts;

        ConflictDetailBuilder() {
        }

        @JsonProperty(value="type")
        public ConflictDetailBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="propertykey_conflicts")
        public ConflictDetailBuilder pkConflicts(List<SchemaConflict<PropertyKeyEntity>> pkConflicts) {
            this.pkConflicts = pkConflicts;
            return this;
        }

        @JsonProperty(value="propertyindex_conflicts")
        public ConflictDetailBuilder piConflicts(List<SchemaConflict<PropertyIndex>> piConflicts) {
            this.piConflicts = piConflicts;
            return this;
        }

        @JsonProperty(value="vertexlabel_conflicts")
        public ConflictDetailBuilder vlConflicts(List<SchemaConflict<VertexLabelEntity>> vlConflicts) {
            this.vlConflicts = vlConflicts;
            return this;
        }

        @JsonProperty(value="edgelabel_conflicts")
        public ConflictDetailBuilder elConflicts(List<SchemaConflict<EdgeLabelEntity>> elConflicts) {
            this.elConflicts = elConflicts;
            return this;
        }

        public ConflictDetail build() {
            return new ConflictDetail(this.type, this.pkConflicts, this.piConflicts, this.vlConflicts, this.elConflicts);
        }

        public String toString() {
            return "ConflictDetail.ConflictDetailBuilder(type=" + (Object)((Object)this.type) + ", pkConflicts=" + this.pkConflicts + ", piConflicts=" + this.piConflicts + ", vlConflicts=" + this.vlConflicts + ", elConflicts=" + this.elConflicts + ")";
        }
    }
}

