/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.entity.schema.Property;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaStyle;

public interface SchemaLabelEntity
extends SchemaEntity {
    public Set<Property> getProperties();

    public List<PropertyIndex> getPropertyIndexes();

    public boolean isOpenLabelIndex();

    public SchemaStyle getStyle();

    @JsonIgnore
    default public Set<String> getPropNames() {
        if (this.getProperties() == null) {
            return Collections.emptySet();
        }
        return this.getProperties().stream().map(Property::getName).collect(Collectors.toSet());
    }

    @JsonIgnore
    default public Set<String> getNullableProps() {
        if (this.getProperties() == null) {
            return Collections.emptySet();
        }
        return this.getProperties().stream().filter(Property::isNullable).map(Property::getName).collect(Collectors.toSet());
    }

    @JsonIgnore
    default public Set<String> getNonNullableProps() {
        if (this.getProperties() == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(CollectionUtils.subtract(this.getPropNames(), this.getNullableProps()));
    }

    @JsonIgnore
    default public Set<String> getIndexProps() {
        if (this.getPropertyIndexes() == null) {
            return Collections.emptySet();
        }
        return this.getPropertyIndexes().stream().map(PropertyIndex::getName).collect(Collectors.toSet());
    }
}

