/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.mapper.GraphConnectionMapper;
import org.apache.hugegraph.util.SQLUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class GraphConnectionService {
    @Autowired
    private GraphConnectionMapper mapper;

    public List<GraphConnection> listAll() {
        return this.mapper.selectList(null);
    }

    public IPage<GraphConnection> list(String content, long current, long pageSize) {
        Page page = new Page(current, pageSize);
        if (!StringUtils.isEmpty((Object)content)) {
            String value = SQLUtil.escapeLike(content);
            return this.mapper.selectByContentInPage((IPage<GraphConnection>)page, value);
        }
        QueryWrapper query = Wrappers.query();
        query.orderByDesc((Object)"create_time");
        return this.mapper.selectPage((IPage)page, (Wrapper)query);
    }

    public GraphConnection get(int id) {
        return (GraphConnection)this.mapper.selectById(Integer.valueOf(id));
    }

    public int count() {
        return this.mapper.selectCount(null);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void save(GraphConnection connection) {
        if (this.mapper.insert(connection) != 1) {
            throw new InternalException("entity.insert.failed", connection);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(GraphConnection connection) {
        if (this.mapper.updateById(connection) != 1) {
            throw new InternalException("entity.update.failed", connection);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(int id) {
        if (this.mapper.deleteById(Integer.valueOf(id)) != 1) {
            throw new InternalException("entity.delete.failed", id);
        }
    }
}

