/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.List;

public class Clauses {
    public static boolean needAllowFiltering(Clause clause) {
        return clause instanceof Clause.ContainsKeyClause || clause instanceof Clause.ContainsClause;
    }

    public static Clause and(Clause left, Clause right) {
        return new AndClause(left, right);
    }

    public static Clause in(String name, List<?> values) {
        return new Clause.InClause(name, values);
    }

    static class AndClause
    extends BinClause {
        public AndClause(Clause left, Clause right) {
            super(left, "AND", right);
        }
    }

    static class BinClause
    extends Clause {
        private final Clause left;
        private final String op;
        private final Clause right;

        public BinClause(Clause left, String op, Clause right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        String name() {
            return null;
        }

        Object firstValue() {
            return null;
        }

        boolean containsBindMarker() {
            return Utils.containsBindMarker((Object)this.left) || Utils.containsBindMarker((Object)this.right);
        }

        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            this.left.appendTo(sb, variables, codecRegistry);
            sb.append(" ");
            sb.append(this.op);
            sb.append(" ");
            this.right.appendTo(sb, variables, codecRegistry);
        }
    }
}

