/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hugegraph.api.auth.AuthAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.auth.Belong;
import org.apache.hugegraph.structure.constant.HugeType;

public class BelongAPI
extends AuthAPI {
    public BelongAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.BELONG.string();
    }

    public Belong create(Belong belong) {
        RestResult result = this.client.post(this.path(), belong);
        return (Belong)result.readObject(Belong.class);
    }

    public Belong get(Object id) {
        RestResult result = this.client.get(this.path(), BelongAPI.formatRelationId(id));
        return (Belong)result.readObject(Belong.class);
    }

    public List<Belong> list(Object user, Object group, int limit) {
        BelongAPI.checkLimit(limit, "Limit");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("limit", limit);
        params.put("user", BelongAPI.formatEntityId(user));
        params.put("group", BelongAPI.formatEntityId(group));
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Belong.class);
    }

    public Belong update(Belong belong) {
        String id = BelongAPI.formatRelationId(belong.id());
        RestResult result = this.client.put(this.path(), id, belong);
        return (Belong)result.readObject(Belong.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), BelongAPI.formatRelationId(id));
    }
}

