/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.util.CommonUtil;

public class MetricsAPI
extends API {
    public static final String STATISTICS_PATH = "/statistics";

    public MetricsAPI(RestClient client) {
        super(client);
        this.path(this.type());
    }

    @Override
    protected String type() {
        return HugeType.METRICS.string();
    }

    public Map<String, Map<String, Object>> system() {
        RestResult result = this.client.get(this.path(), "system");
        Map map = (Map)result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }

    public Map<String, Map<String, Object>> backend() {
        RestResult result = this.client.get(this.path(), "backend");
        Map map = (Map)result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }

    public Map<String, Object> backend(String graph) {
        return this.backend().get(graph);
    }

    public Map<String, Map<String, Object>> all() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "json");
        RestResult result = this.client.get(this.path(), params);
        Map map = (Map)result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }

    public String allWithPromFormat() {
        RestResult result = this.client.get(this.path());
        return result.content();
    }

    public Map<String, Map<String, Object>> statistics() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "json");
        RestResult result = this.client.get(this.path() + STATISTICS_PATH, params);
        Map map = (Map)result.readObject(Map.class);
        CommonUtil.checkMapClass(map, String.class, Map.class);
        for (Object mapValue : map.values()) {
            CommonUtil.checkMapClass(mapValue, String.class, Object.class);
        }
        return map;
    }

    public String statisticsWithPromFormat() {
        RestResult result = this.client.get(this.path() + STATISTICS_PATH);
        return result.content();
    }
}

