/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.constant.Direction;

public class EdgeStep {
    @JsonProperty(value="direction")
    protected Direction direction = Direction.BOTH;
    @JsonProperty(value="labels")
    protected List<String> labels = new ArrayList<String>();
    @JsonProperty(value="properties")
    protected Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="degree")
    protected long degree = 10000L;
    @JsonProperty(value="skip_degree")
    protected long skipDegree = 100000L;

    protected EdgeStep() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("EdgeStep{direction=%s,labels=%s,properties=%s,degree=%s,skipDegree=%s}", new Object[]{this.direction, this.labels, this.properties, this.degree, this.skipDegree});
    }

    public static class Builder {
        protected EdgeStep step = new EdgeStep();

        private Builder() {
        }

        public Builder direction(Direction direction) {
            this.step.direction = direction;
            return this;
        }

        public Builder labels(List<String> labels) {
            this.step.labels = labels;
            return this;
        }

        public Builder labels(String label) {
            this.step.labels.add(label);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.step.properties = properties;
            return this;
        }

        public Builder properties(String key, Object value) {
            this.step.properties.put(key, value);
            return this;
        }

        public Builder degree(long degree) {
            TraversersAPI.checkDegree(degree);
            this.step.degree = degree;
            return this;
        }

        public Builder skipDegree(long skipDegree) {
            TraversersAPI.checkSkipDegree(skipDegree, this.step.degree, -1L);
            this.step.skipDegree = skipDegree;
            return this;
        }

        public EdgeStep build() {
            TraversersAPI.checkDegree(this.step.degree);
            TraversersAPI.checkSkipDegree(this.step.skipDegree, this.step.degree, -1L);
            return this.step;
        }
    }
}

