/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.spark.sql.Row;

public class EdgeBuilder
extends ElementBuilder<Edge> {
    private final EdgeMapping mapping;
    private final EdgeLabel edgeLabel;
    private final VertexLabel sourceLabel;
    private final VertexLabel targetLabel;
    private final Collection<String> nonNullKeys;
    private VertexIdsIndex vertexIdsIndex;
    private String[] lastNames;

    public EdgeBuilder(LoadContext context, InputStruct struct, EdgeMapping mapping) {
        super(context, struct);
        this.mapping = mapping;
        this.edgeLabel = this.getEdgeLabel(this.mapping.label());
        this.sourceLabel = this.getVertexLabel(this.edgeLabel.sourceLabel());
        this.targetLabel = this.getVertexLabel(this.edgeLabel.targetLabel());
        this.nonNullKeys = this.nonNullableKeys((SchemaLabel)this.edgeLabel);
        this.checkIdFields(this.sourceLabel, this.mapping.sourceFields());
        this.checkIdFields(this.targetLabel, this.mapping.targetFields());
        this.vertexIdsIndex = null;
    }

    @Override
    public EdgeMapping mapping() {
        return this.mapping;
    }

    @Override
    public List<Edge> build(String[] names, Object[] values) {
        if (this.vertexIdsIndex == null || !Arrays.equals(this.lastNames, names)) {
            this.vertexIdsIndex = this.extractVertexIdsIndex(names);
        }
        this.lastNames = names;
        EdgeKVPairs kvPairs = this.newEdgeKVPairs();
        kvPairs.source.extractFromEdge(names, values, this.vertexIdsIndex.sourceIndexes);
        kvPairs.target.extractFromEdge(names, values, this.vertexIdsIndex.targetIndexes);
        kvPairs.extractProperties(names, values);
        List<Vertex> sources = kvPairs.source.buildVertices(false);
        List<Vertex> targets = kvPairs.target.buildVertices(false);
        if (sources.isEmpty() || targets.isEmpty()) {
            return ImmutableList.of();
        }
        E.checkArgument((sources.size() == 1 || targets.size() == 1 || sources.size() == targets.size() ? 1 : 0) != 0, (String)"The elements number of source and target must be: 1 to n, n to 1, n to n", (Object[])new Object[0]);
        int size = Math.max(sources.size(), targets.size());
        ArrayList<Edge> edges = new ArrayList<Edge>(size);
        for (int i = 0; i < size; ++i) {
            Vertex source = i < sources.size() ? sources.get(i) : sources.get(0);
            Vertex target = i < targets.size() ? targets.get(i) : targets.get(0);
            Edge edge = new Edge(this.mapping.label());
            edge.source(source);
            edge.target(target);
            this.addProperties((GraphElement)edge, kvPairs.properties);
            this.checkNonNullableKeys((GraphElement)edge);
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public List<Edge> build(Row row) {
        Object[] names = row.schema().fieldNames();
        Object[] values = new Object[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            values[i] = row.get(i);
        }
        if (this.vertexIdsIndex == null || !Arrays.equals(this.lastNames, names)) {
            this.vertexIdsIndex = this.extractVertexIdsIndex((String[])names);
        }
        this.lastNames = names;
        EdgeKVPairs kvPairs = this.newEdgeKVPairs();
        kvPairs.source.extractFromEdge((String[])names, values, this.vertexIdsIndex.sourceIndexes);
        kvPairs.target.extractFromEdge((String[])names, values, this.vertexIdsIndex.targetIndexes);
        kvPairs.extractProperties((String[])names, values);
        List<Vertex> sources = kvPairs.source.buildVertices(false);
        List<Vertex> targets = kvPairs.target.buildVertices(false);
        if (sources.isEmpty() || targets.isEmpty()) {
            return ImmutableList.of();
        }
        E.checkArgument((sources.size() == 1 || targets.size() == 1 || sources.size() == targets.size() ? 1 : 0) != 0, (String)"The elements number of source and target must be: 1 to n, n to 1, n to n", (Object[])new Object[0]);
        int size = Math.max(sources.size(), targets.size());
        ArrayList<Edge> edges = new ArrayList<Edge>(size);
        for (int i = 0; i < size; ++i) {
            Vertex source = i < sources.size() ? sources.get(i) : sources.get(0);
            Vertex target = i < targets.size() ? targets.get(i) : targets.get(0);
            Edge edge = new Edge(this.mapping.label());
            edge.source(source);
            edge.target(target);
            this.addProperties((GraphElement)edge, kvPairs.properties);
            this.checkNonNullableKeys((GraphElement)edge);
            edges.add(edge);
        }
        return edges;
    }

    private EdgeKVPairs newEdgeKVPairs() {
        EdgeKVPairs kvPairs = new EdgeKVPairs();
        kvPairs.source = this.newKVPairs(this.sourceLabel, this.mapping.unfoldSource());
        kvPairs.target = this.newKVPairs(this.targetLabel, this.mapping.unfoldTarget());
        return kvPairs;
    }

    @Override
    public SchemaLabel schemaLabel() {
        return this.edgeLabel;
    }

    @Override
    protected Collection<String> nonNullableKeys() {
        return this.nonNullKeys;
    }

    @Override
    protected boolean isIdField(String fieldName) {
        return this.mapping.sourceFields().contains(fieldName) || this.mapping.targetFields().contains(fieldName);
    }

    private void checkIdFields(VertexLabel vertexLabel, List<String> fields) {
        if (vertexLabel.idStrategy().isCustomize()) {
            E.checkArgument((fields.size() == 1 ? 1 : 0) != 0, (String)"The source/target field can contains only one column when id strategy is CUSTOMIZE", (Object[])new Object[0]);
        } else if (vertexLabel.idStrategy().isPrimaryKey()) {
            E.checkArgument((fields.size() >= 1 ? 1 : 0) != 0, (String)"The source/target field must contains some columns when id strategy is PrimaryKey", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("Unsupported AUTOMATIC id strategy for hugegraph-loader");
        }
    }

    private VertexIdsIndex extractVertexIdsIndex(String[] names) {
        String name;
        int pos;
        VertexIdsIndex index = new VertexIdsIndex();
        VertexIdsIndex.access$002(index, new int[this.mapping.sourceFields().size()]);
        int idx = 0;
        for (String field : this.mapping.sourceFields()) {
            for (pos = 0; pos < names.length; ++pos) {
                name = names[pos];
                if (!field.equals(name)) continue;
                ((VertexIdsIndex)index).sourceIndexes[idx++] = pos;
            }
        }
        VertexIdsIndex.access$202(index, new int[this.mapping.targetFields().size()]);
        idx = 0;
        for (String field : this.mapping.targetFields()) {
            for (pos = 0; pos < names.length; ++pos) {
                name = names[pos];
                if (!field.equals(name)) continue;
                ((VertexIdsIndex)index).targetIndexes[idx++] = pos;
            }
        }
        return index;
    }

    private static class VertexIdsIndex {
        private int[] sourceIndexes;
        private int[] targetIndexes;

        private VertexIdsIndex() {
        }

        static /* synthetic */ int[] access$002(VertexIdsIndex x0, int[] x1) {
            x0.sourceIndexes = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(VertexIdsIndex x0, int[] x1) {
            x0.targetIndexes = x1;
            return x1;
        }
    }

    public class EdgeKVPairs {
        private ElementBuilder.VertexKVPairs source;
        private ElementBuilder.VertexKVPairs target;
        private Map<String, Object> properties;

        public void extractProperties(String[] names, Object[] values) {
            this.properties = new HashMap<String, Object>();
            Set props = EdgeBuilder.this.schemaLabel().properties();
            for (int i = 0; i < names.length; ++i) {
                String fieldName = names[i];
                Object fieldValue = values[i];
                if (!EdgeBuilder.this.retainField(fieldName, fieldValue)) continue;
                String key = EdgeBuilder.this.mapping.mappingField(fieldName);
                if (EdgeBuilder.this.isIdField(fieldName) && !props.contains(fieldName) && !props.contains(key)) continue;
                Object value = EdgeBuilder.this.mappingValue(fieldName, fieldValue);
                this.properties.put(key, value);
            }
        }
    }
}

