/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.AbstractBackendStore;
import org.apache.hugegraph.backend.store.BackendAction;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.mysql.MysqlBackendEntry;
import org.apache.hugegraph.backend.store.mysql.MysqlFeatures;
import org.apache.hugegraph.backend.store.mysql.MysqlMetrics;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlTable;
import org.apache.hugegraph.backend.store.mysql.MysqlTables;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class MysqlStore
extends AbstractBackendStore<MysqlSessions.Session> {
    private static final Logger LOG = Log.logger(MysqlStore.class);
    private static final BackendFeatures FEATURES = new MysqlFeatures();
    private final String store;
    private final String database;
    private final BackendStoreProvider provider;
    private final Map<HugeType, MysqlTable> tables;
    private MysqlSessions sessions;

    public MysqlStore(BackendStoreProvider provider, String database, String store) {
        E.checkNotNull((Object)database, (String)"database");
        E.checkNotNull((Object)store, (String)"store");
        this.provider = provider;
        this.database = database;
        this.store = store;
        this.sessions = null;
        this.tables = new ConcurrentHashMap<HugeType, MysqlTable>();
        this.registerMetaHandlers();
        LOG.debug("Store loaded: {}", (Object)store);
    }

    private void registerMetaHandlers() {
        this.registerMetaHandler("metrics", (session, meta, args) -> {
            MysqlMetrics metrics = new MysqlMetrics();
            return metrics.metrics();
        });
    }

    protected void registerTableManager(HugeType type, MysqlTable table) {
        this.tables.put(type, table);
    }

    protected MysqlSessions openSessionPool(HugeConfig config) {
        return new MysqlSessions(config, this.database, this.store);
    }

    public String store() {
        return this.store;
    }

    public String database() {
        return this.database;
    }

    public BackendStoreProvider provider() {
        return this.provider;
    }

    public synchronized void open(HugeConfig config) {
        LOG.debug("Store open: {}", (Object)this.store);
        E.checkNotNull((Object)config, (String)"config");
        if (this.sessions != null && !this.sessions.closed()) {
            LOG.debug("Store {} has been opened before", (Object)this.store);
            this.sessions.useSession();
            return;
        }
        this.sessions = this.openSessionPool(config);
        if (this.sessions.existsDatabase()) {
            LOG.debug("Store connect with database: {}", (Object)this.database);
            try {
                this.sessions.open();
            }
            catch (Throwable e) {
                throw new ConnectionException("Failed to connect to MySQL", e);
            }
            try {
                this.sessions.session().open();
            }
            catch (Throwable e) {
                try {
                    this.sessions.close();
                }
                catch (Throwable e2) {
                    LOG.warn("Failed to close connection after an error", e2);
                }
                throw new BackendException("Failed to open database", e);
            }
        }
        if (this.isSchemaStore()) {
            LOG.info("Failed to open database '{}', try to init database later", (Object)this.database);
        }
        this.sessions.session();
        LOG.debug("Store opened: {}", (Object)this.store);
    }

    public void close() {
        LOG.debug("Store close: {}", (Object)this.store);
        this.checkClusterConnected();
        this.sessions.close();
    }

    public boolean opened() {
        this.checkClusterConnected();
        return this.sessions.session().opened();
    }

    public void init() {
        this.checkClusterConnected();
        this.sessions.createDatabase();
        try {
            this.sessions.session().open();
        }
        catch (Exception e) {
            throw new BackendException("Failed to connect database '%s'", new Object[]{this.database});
        }
        this.checkOpened();
        this.initTables();
        LOG.debug("Store initialized: {}", (Object)this.store);
    }

    public void clear(boolean clearSpace) {
        this.checkClusterConnected();
        if (this.sessions.existsDatabase()) {
            if (!clearSpace) {
                this.checkOpened();
                this.clearTables();
                this.sessions.resetConnections();
            } else {
                this.sessions.dropDatabase();
            }
        }
        LOG.debug("Store cleared: {}", (Object)this.store);
    }

    public boolean initialized() {
        this.checkClusterConnected();
        if (!this.sessions.existsDatabase()) {
            return false;
        }
        for (MysqlTable table : this.tables()) {
            if (this.sessions.existsTable(table.table())) continue;
            return false;
        }
        return true;
    }

    public void truncate() {
        this.checkOpened();
        this.truncateTables();
        LOG.debug("Store truncated: {}", (Object)this.store);
    }

    public void mutate(BackendMutation mutation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Store {} mutation: {}", (Object)this.store, (Object)mutation);
        }
        this.checkOpened();
        MysqlSessions.Session session = this.sessions.session();
        Iterator it = mutation.mutation();
        while (it.hasNext()) {
            this.mutate(session, (BackendAction)it.next());
        }
    }

    private void mutate(MysqlSessions.Session session, BackendAction item) {
        MysqlBackendEntry entry = MysqlStore.castBackendEntry(item.entry());
        MysqlTable table = this.table(entry.type());
        switch (item.action()) {
            case INSERT: {
                table.insert(session, entry.row());
                break;
            }
            case DELETE: {
                table.delete(session, entry.row());
                break;
            }
            case APPEND: {
                table.append(session, entry.row());
                break;
            }
            case ELIMINATE: {
                table.eliminate(session, entry.row());
                break;
            }
            case UPDATE_IF_PRESENT: {
                table.updateIfPresent(session, entry.row());
                break;
            }
            case UPDATE_IF_ABSENT: {
                table.updateIfAbsent(session, entry.row());
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported mutate action: %s", item.action()));
            }
        }
    }

    public Iterator<BackendEntry> query(Query query) {
        this.checkOpened();
        MysqlTable table = this.table(MysqlTable.tableType((Query)query));
        return table.query(this.sessions.session(), query);
    }

    public Number queryNumber(Query query) {
        this.checkOpened();
        MysqlTable table = this.table(MysqlTable.tableType((Query)query));
        return table.queryNumber(this.sessions.session(), query);
    }

    public void beginTx() {
        this.checkOpened();
        MysqlSessions.Session session = this.sessions.session();
        try {
            session.begin();
        }
        catch (SQLException e) {
            throw new BackendException("Failed to open transaction", (Throwable)e);
        }
    }

    public void commitTx() {
        this.checkOpened();
        MysqlSessions.Session session = this.sessions.session();
        int count = session.commit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Store {} committed {} items", (Object)this.store, (Object)count);
        }
    }

    public void rollbackTx() {
        this.checkOpened();
        MysqlSessions.Session session = this.sessions.session();
        session.rollback();
    }

    public BackendFeatures features() {
        return FEATURES;
    }

    protected void initTables() {
        MysqlSessions.Session session = this.sessions.session();
        for (MysqlTable table : this.tables()) {
            table.init(session);
        }
    }

    protected void clearTables() {
        MysqlSessions.Session session = this.sessions.session();
        for (MysqlTable table : this.tables()) {
            table.clear(session);
        }
    }

    protected void truncateTables() {
        MysqlSessions.Session session = this.sessions.session();
        for (MysqlTable table : this.tables()) {
            table.truncate(session);
        }
    }

    protected Collection<MysqlTable> tables() {
        return this.tables.values();
    }

    protected final MysqlTable table(HugeType type) {
        assert (type != null);
        MysqlTable table = this.tables.get(type);
        if (table == null) {
            throw new BackendException("Unsupported table type: %s", new Object[]{type});
        }
        return table;
    }

    protected MysqlSessions.Session session(HugeType type) {
        this.checkOpened();
        return this.sessions.session();
    }

    protected final void checkClusterConnected() {
        E.checkState((this.sessions != null ? 1 : 0) != 0, (String)"MySQL store has not been initialized", (Object[])new Object[0]);
    }

    protected static MysqlBackendEntry castBackendEntry(BackendEntry entry) {
        if (!(entry instanceof MysqlBackendEntry)) {
            throw new BackendException("MySQL store only supports MysqlBackendEntry");
        }
        return (MysqlBackendEntry)entry;
    }

    public static class MysqlSystemStore
    extends MysqlGraphStore {
        private final MysqlTables.Meta meta = new MysqlTables.Meta();

        public MysqlSystemStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
        }

        @Override
        public void init() {
            super.init();
            MysqlSessions.Session session = super.session(null);
            String driverVersion = this.provider().driverVersion();
            this.meta.writeVersion(session, driverVersion);
            LOG.info("Write down the backend version: {}", (Object)driverVersion);
        }

        public String storedVersion() {
            super.init();
            MysqlSessions.Session session = super.session(null);
            return this.meta.readVersion(session);
        }

        @Override
        protected Collection<MysqlTable> tables() {
            ArrayList<MysqlTable> tables = new ArrayList<MysqlTable>(super.tables());
            tables.add(this.meta);
            return tables;
        }
    }

    public static class MysqlGraphStore
    extends MysqlStore {
        public MysqlGraphStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX, new MysqlTables.Vertex(store));
            this.registerTableManager(HugeType.EDGE_OUT, MysqlTables.Edge.out(store));
            this.registerTableManager(HugeType.EDGE_IN, MysqlTables.Edge.in(store));
            this.registerTableManager(HugeType.SECONDARY_INDEX, new MysqlTables.SecondaryIndex(store));
            this.registerTableManager(HugeType.RANGE_INT_INDEX, new MysqlTables.RangeIntIndex(store));
            this.registerTableManager(HugeType.RANGE_FLOAT_INDEX, new MysqlTables.RangeFloatIndex(store));
            this.registerTableManager(HugeType.RANGE_LONG_INDEX, new MysqlTables.RangeLongIndex(store));
            this.registerTableManager(HugeType.RANGE_DOUBLE_INDEX, new MysqlTables.RangeDoubleIndex(store));
            this.registerTableManager(HugeType.SEARCH_INDEX, new MysqlTables.SearchIndex(store));
            this.registerTableManager(HugeType.SHARD_INDEX, new MysqlTables.ShardIndex(store));
            this.registerTableManager(HugeType.UNIQUE_INDEX, new MysqlTables.UniqueIndex(store));
        }

        public boolean isSchemaStore() {
            return false;
        }

        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("MysqlGraphStore.nextId()");
        }

        public void increaseCounter(HugeType type, long num) {
            throw new UnsupportedOperationException("MysqlGraphStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("MysqlGraphStore.getCounter()");
        }
    }

    public static class MysqlSchemaStore
    extends MysqlStore {
        private final MysqlTables.Counters counters = new MysqlTables.Counters();

        public MysqlSchemaStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX_LABEL, new MysqlTables.VertexLabel());
            this.registerTableManager(HugeType.EDGE_LABEL, new MysqlTables.EdgeLabel());
            this.registerTableManager(HugeType.PROPERTY_KEY, new MysqlTables.PropertyKey());
            this.registerTableManager(HugeType.INDEX_LABEL, new MysqlTables.IndexLabel());
        }

        @Override
        protected Collection<MysqlTable> tables() {
            ArrayList<MysqlTable> tables = new ArrayList<MysqlTable>(super.tables());
            tables.add(this.counters);
            return tables;
        }

        public void increaseCounter(HugeType type, long increment) {
            this.checkOpened();
            MysqlSessions.Session session = ((MysqlStore)this).sessions.session();
            this.counters.increaseCounter(session, type, increment);
        }

        public long getCounter(HugeType type) {
            this.checkOpened();
            MysqlSessions.Session session = ((MysqlStore)this).sessions.session();
            return this.counters.getCounter(session, type);
        }

        public boolean isSchemaStore() {
            return true;
        }
    }
}

