/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.store.BackendMetrics;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.UnitUtil;

public class RocksDBMetrics
implements BackendMetrics {
    private static final String PREFIX = "rocksdb.";
    private static final String BLOCK_CACHE = "rocksdb.block-cache-usage";
    private static final String BLOCK_CACHE_PINNED = "rocksdb.block-cache-pinned-usage";
    private static final String BLOCK_CACHE_CAPACITY = "rocksdb.block-cache-capacity";
    private static final String INDEX_FILTER = "rocksdb.estimate-table-readers-mem";
    private static final String ALL_MEM_TABLE = "rocksdb.size-all-mem-tables";
    private static final String CUR_MEM_TABLE = "rocksdb.cur-size-all-mem-tables";
    private static final String DISK_USAGE = "rocksdb.disk-usage";
    private static final String LIVE_DATA_SIZE = "rocksdb.estimate-live-data-size";
    private static final String SST_FILE_SIZE = "rocksdb.total-sst-files-size";
    private static final String LIVE_SST_FILE_SIZE = "rocksdb.live-sst-files-size";
    private static final String PENDING_COMPACTION_BYTES = "rocksdb.estimate-pending-compaction-bytes";
    private static final String NUM_KEYS = "rocksdb.estimate-num-keys";
    private static final String NUM_KEYS_MEM_TABLE = "rocksdb.num-entries-active-mem-table";
    private static final String NUM_KEYS_IMM_MEM_TABLE = "rocksdb.num-entries-imm-mem-tables";
    private static final String NUM_DELETES_MEM_TABLE = "rocksdb.num-deletes-active-mem-table";
    private static final String NUM_DELETES_IMM_MEM_TABLE = "rocksdb.num-deletes-imm-mem-tables";
    private static final String RUNNING_FLUSHS = "rocksdb.num-running-flushes";
    private static final String MEM_TABLE_FLUSH_PENDINF = "rocksdb.mem-table-flush-pending";
    private static final String RUNNING_COMPACTIONS = "rocksdb.num-running-compactions";
    private static final String COMPACTION_PENDINF = "rocksdb.compaction-pending";
    private static final String NUM_IMM_MEM_TABLE = "rocksdb.num-immutable-mem-table";
    private static final String NUM_SNAPSHOTS = "rocksdb.num-snapshots";
    private static final String OLDEST_SNAPSHOT_TIME = "rocksdb.oldest-snapshot-time";
    private static final String NUM_LIVE_VERSIONS = "rocksdb.num-live-versions";
    private static final String SUPER_VERSION = "rocksdb.current-super-version-number";
    public static final String KEY_DISK_USAGE = "rocksdb.disk-usage";
    public static final String KEY_NUM_KEYS = "rocksdb.estimate-num-keys";
    private final List<RocksDBSessions> dbs;
    private final RocksDBSessions.Session session;

    public RocksDBMetrics(List<RocksDBSessions> dbs, RocksDBSessions.Session session) {
        this.dbs = dbs;
        this.session = session;
    }

    public Map<String, Object> metrics() {
        Map results = InsertionOrderUtil.newMap();
        results.put("nodes", 1);
        results.put("cluster_id", "local");
        try {
            Map<String, Object> metrics = this.metricsInfo();
            results.put("servers", ImmutableMap.of((Object)"local", metrics));
        }
        catch (Throwable e) {
            results.put("exception", e.toString());
        }
        return results;
    }

    private Map<String, Object> metricsInfo() {
        Map metrics = InsertionOrderUtil.newMap();
        metrics.put("mem_unit", "MB");
        metrics.put("disk_unit", "GB");
        long memUsed = (long)this.getMemUsed();
        metrics.put("mem_used", UnitUtil.bytesToMB((long)memUsed));
        metrics.put("mem_used_readable", UnitUtil.bytesToReadableString((long)memUsed));
        long diskUsage = (long)this.getDiskUsage();
        metrics.put("disk_usage", UnitUtil.bytesToMB((long)diskUsage));
        metrics.put("disk_usage_readable", UnitUtil.bytesToReadableString((long)diskUsage));
        this.appendMetricsMemory(metrics, BLOCK_CACHE);
        this.appendMetricsMemory(metrics, BLOCK_CACHE_PINNED);
        this.appendMetricsMemory(metrics, BLOCK_CACHE_CAPACITY);
        this.appendMetricsMemory(metrics, INDEX_FILTER);
        this.appendMetricsMemory(metrics, ALL_MEM_TABLE);
        this.appendMetricsMemory(metrics, CUR_MEM_TABLE);
        this.appendMetricsDisk(metrics, LIVE_DATA_SIZE);
        this.appendMetricsDisk(metrics, SST_FILE_SIZE);
        this.appendMetricsDisk(metrics, LIVE_SST_FILE_SIZE);
        this.appendMetricsDisk(metrics, PENDING_COMPACTION_BYTES);
        this.appendMetricsNumber(metrics, "rocksdb.estimate-num-keys");
        this.appendMetricsNumber(metrics, NUM_KEYS_MEM_TABLE);
        this.appendMetricsNumber(metrics, NUM_KEYS_IMM_MEM_TABLE);
        this.appendMetricsNumber(metrics, NUM_DELETES_MEM_TABLE);
        this.appendMetricsNumber(metrics, NUM_DELETES_IMM_MEM_TABLE);
        this.appendMetricsNumber(metrics, RUNNING_FLUSHS);
        this.appendMetricsNumber(metrics, MEM_TABLE_FLUSH_PENDINF);
        this.appendMetricsNumber(metrics, RUNNING_COMPACTIONS);
        this.appendMetricsNumber(metrics, COMPACTION_PENDINF);
        this.appendMetricsNumber(metrics, NUM_IMM_MEM_TABLE);
        this.appendMetricsNumber(metrics, NUM_SNAPSHOTS);
        this.appendMetricsNumber(metrics, OLDEST_SNAPSHOT_TIME);
        this.appendMetricsNumber(metrics, NUM_LIVE_VERSIONS);
        this.appendMetricsNumber(metrics, SUPER_VERSION);
        return metrics;
    }

    private void appendMetricsMemory(Map<String, Object> metrics, String key) {
        metrics.put(this.name(key), this.sum(this.session, key) / 1048576.0);
    }

    private void appendMetricsDisk(Map<String, Object> metrics, String key) {
        metrics.put(this.name(key), this.sum(this.session, key) / 1.073741824E9);
    }

    private void appendMetricsNumber(Map<String, Object> metrics, String key) {
        metrics.put(this.name(key), (long)this.sum(this.session, key));
    }

    private String name(String key) {
        return key.replace(PREFIX, "").replace("-", "_");
    }

    private double getMemUsed() {
        double blockCache = this.sum(this.session, BLOCK_CACHE);
        double indexFilter = this.sum(this.session, INDEX_FILTER);
        double memtable = this.sum(this.session, ALL_MEM_TABLE);
        double blockCachePinned = this.sum(this.session, BLOCK_CACHE_PINNED);
        return blockCache + indexFilter + memtable + blockCachePinned;
    }

    private double getDiskUsage() {
        return this.sum("rocksdb.disk-usage");
    }

    private double sum(RocksDBSessions.Session session, String property) {
        double total = 0.0;
        for (RocksDBSessions db : this.dbs) {
            List<String> cfValues = db.property(property);
            for (String value : cfValues) {
                total += Double.parseDouble(value);
            }
            for (String table : db.openedTables()) {
                total += Double.parseDouble(session.property(table, property));
            }
        }
        return total;
    }

    private double sum(String property) {
        double total = 0.0;
        for (RocksDBSessions db : this.dbs) {
            List<String> cfValues = db.property(property);
            for (String value : cfValues) {
                total += Double.parseDouble(value);
            }
        }
        return total;
    }

    public Map<String, Object> compact() {
        Map results = InsertionOrderUtil.newMap();
        results.put("nodes", 1);
        results.put("cluster_id", "local");
        try {
            for (RocksDBSessions db : this.dbs) {
                db.compactRange();
            }
            results.put("servers", ImmutableMap.of((Object)"local", (Object)"OK"));
        }
        catch (Throwable e) {
            results.put("exception", e.toString());
        }
        return results;
    }
}

