/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.apache.iceberg.io.CloseableIterator;

public class ClosingIterator<T>
implements Iterator<T> {
    private final CloseableIterator<T> iterator;
    private boolean shouldClose = false;

    public ClosingIterator(CloseableIterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        this.shouldClose = !hasNext;
        return hasNext;
    }

    @Override
    public T next() {
        Object next = this.iterator.next();
        if (this.shouldClose) {
            try {
                this.iterator.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return (T)next;
    }
}

