/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.Accessors;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.BiMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableBiMap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class Schema
implements Serializable {
    private static final Joiner NEWLINE = Joiner.on((char)'\n');
    private static final String ALL_COLUMNS = "*";
    private final Types.StructType struct;
    private transient BiMap<String, Integer> aliasToId = null;
    private transient Map<Integer, Types.NestedField> idToField = null;
    private transient BiMap<String, Integer> nameToId = null;
    private transient BiMap<String, Integer> lowerCaseNameToId = null;
    private transient Map<Integer, Accessor<StructLike>> idToAccessor = null;

    public Schema(List<Types.NestedField> columns, Map<String, Integer> aliases) {
        this.struct = Types.StructType.of(columns);
        this.aliasToId = aliases != null ? ImmutableBiMap.copyOf(aliases) : null;
        this.lazyNameToId();
    }

    public Schema(List<Types.NestedField> columns) {
        this.struct = Types.StructType.of(columns);
        this.lazyNameToId();
    }

    public Schema(Types.NestedField ... columns) {
        this(Arrays.asList(columns));
    }

    private Map<Integer, Types.NestedField> lazyIdToField() {
        if (this.idToField == null) {
            this.idToField = TypeUtil.indexById(this.struct);
        }
        return this.idToField;
    }

    private BiMap<String, Integer> lazyNameToId() {
        if (this.nameToId == null) {
            this.nameToId = ImmutableBiMap.copyOf(TypeUtil.indexByName(this.struct));
        }
        return this.nameToId;
    }

    private BiMap<String, Integer> lazyLowerCaseNameToId() {
        if (this.lowerCaseNameToId == null) {
            this.lowerCaseNameToId = ImmutableBiMap.copyOf(TypeUtil.indexByLowerCaseName(this.struct));
        }
        return this.lowerCaseNameToId;
    }

    private Map<Integer, Accessor<StructLike>> lazyIdToAccessor() {
        if (this.idToAccessor == null) {
            this.idToAccessor = Accessors.forSchema(this);
        }
        return this.idToAccessor;
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    public Types.StructType asStruct() {
        return this.struct;
    }

    public List<Types.NestedField> columns() {
        return this.struct.fields();
    }

    public Type findType(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = (Integer)this.lazyNameToId().get((Object)name);
        if (id != null) {
            return this.findType(id);
        }
        return null;
    }

    public Type findType(int id) {
        Types.NestedField field = this.lazyIdToField().get(id);
        if (field != null) {
            return field.type();
        }
        return null;
    }

    public Types.NestedField findField(int id) {
        return this.lazyIdToField().get(id);
    }

    public Types.NestedField findField(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = (Integer)this.lazyNameToId().get((Object)name);
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public Types.NestedField caseInsensitiveFindField(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid column name: (empty)");
        Integer id = (Integer)this.lazyLowerCaseNameToId().get((Object)name.toLowerCase(Locale.ROOT));
        if (id != null) {
            return this.lazyIdToField().get(id);
        }
        return null;
    }

    public String findColumnName(int id) {
        return (String)this.lazyNameToId().inverse().get((Object)id);
    }

    public Integer aliasToId(String alias) {
        if (this.aliasToId != null) {
            return (Integer)this.aliasToId.get((Object)alias);
        }
        return null;
    }

    public String idToAlias(Integer fieldId) {
        if (this.aliasToId != null) {
            return (String)this.aliasToId.inverse().get((Object)fieldId);
        }
        return null;
    }

    public Accessor<StructLike> accessorForField(int id) {
        return this.lazyIdToAccessor().get(id);
    }

    public Schema select(String ... names) {
        return this.select(Arrays.asList(names));
    }

    public Schema select(Collection<String> names) {
        return this.internalSelect(names, true);
    }

    public Schema caseInsensitiveSelect(String ... names) {
        return this.caseInsensitiveSelect(Arrays.asList(names));
    }

    public Schema caseInsensitiveSelect(Collection<String> names) {
        return this.internalSelect(names, false);
    }

    private Schema internalSelect(Collection<String> names, boolean caseSensitive) {
        if (names.contains(ALL_COLUMNS)) {
            return this;
        }
        HashSet selected = Sets.newHashSet();
        for (String name : names) {
            Integer id = caseSensitive ? (Integer)this.lazyNameToId().get((Object)name) : (Integer)this.lazyLowerCaseNameToId().get((Object)name.toLowerCase(Locale.ROOT));
            if (id == null) continue;
            selected.add(id);
        }
        return TypeUtil.select(this, (Set<Integer>)selected);
    }

    public String toString() {
        return String.format("table {\n%s\n}", NEWLINE.join((Iterable)this.struct.fields().stream().map(f -> "  " + f).collect(Collectors.toList())));
    }
}

