/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundLiteralPredicate;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundUnaryPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Literals;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Predicate;
import org.apache.iceberg.expressions.Unbound;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;

public class UnboundPredicate<T>
extends Predicate<T, UnboundTerm<T>>
implements Unbound<T, Expression> {
    private static final Joiner COMMA = Joiner.on((String)", ");
    private final List<Literal<T>> literals;

    UnboundPredicate(Expression.Operation op, UnboundTerm<T> term, T value) {
        this(op, term, Literals.from(value));
    }

    UnboundPredicate(Expression.Operation op, UnboundTerm<T> term) {
        super(op, term);
        this.literals = null;
    }

    UnboundPredicate(Expression.Operation op, UnboundTerm<T> term, Literal<T> lit) {
        super(op, term);
        this.literals = Lists.newArrayList((Object[])new Literal[]{lit});
    }

    UnboundPredicate(Expression.Operation op, UnboundTerm<T> term, Iterable<T> values) {
        super(op, term);
        this.literals = Lists.newArrayList((Iterable)Iterables.transform(values, Literals::from));
    }

    private UnboundPredicate(Expression.Operation op, UnboundTerm<T> term, List<Literal<T>> literals) {
        super(op, term);
        this.literals = literals;
    }

    @Override
    public NamedReference<?> ref() {
        return ((UnboundTerm)this.term()).ref();
    }

    @Override
    public Expression negate() {
        return new UnboundPredicate<T>(this.op().negate(), (UnboundTerm)this.term(), this.literals);
    }

    public Literal<T> literal() {
        Preconditions.checkArgument((this.op() != Expression.Operation.IN && this.op() != Expression.Operation.NOT_IN ? 1 : 0) != 0, (String)"%s predicate cannot return a literal", (Object)((Object)this.op()));
        return this.literals == null ? null : (Literal)Iterables.getOnlyElement(this.literals);
    }

    public List<Literal<T>> literals() {
        return this.literals;
    }

    Expression bind(Types.StructType struct) {
        return this.bind(struct, true);
    }

    @Override
    public Expression bind(Types.StructType struct, boolean caseSensitive) {
        BoundTerm bound = (BoundTerm)((UnboundTerm)this.term()).bind(struct, caseSensitive);
        if (this.literals == null) {
            return this.bindUnaryOperation(bound);
        }
        if (this.op() == Expression.Operation.IN || this.op() == Expression.Operation.NOT_IN) {
            return this.bindInOperation(bound);
        }
        return this.bindLiteralOperation(bound);
    }

    private Expression bindUnaryOperation(BoundTerm<T> boundTerm) {
        switch (this.op()) {
            case IS_NULL: {
                if (boundTerm.ref().field().isRequired()) {
                    return Expressions.alwaysFalse();
                }
                return new BoundUnaryPredicate<T>(Expression.Operation.IS_NULL, boundTerm);
            }
            case NOT_NULL: {
                if (boundTerm.ref().field().isRequired()) {
                    return Expressions.alwaysTrue();
                }
                return new BoundUnaryPredicate<T>(Expression.Operation.NOT_NULL, boundTerm);
            }
        }
        throw new ValidationException("Operation must be IS_NULL or NOT_NULL", new Object[0]);
    }

    private Expression bindLiteralOperation(BoundTerm<T> boundTerm) {
        Literal lit = this.literal().to(boundTerm.type());
        if (lit == null) {
            throw new ValidationException(String.format("Invalid value for conversion to type %s: %s (%s)", boundTerm.type(), this.literal().value(), this.literal().value().getClass().getName()), new Object[0]);
        }
        if (lit == Literals.aboveMax()) {
            switch (this.op()) {
                case LT: 
                case LT_EQ: 
                case NOT_EQ: {
                    return Expressions.alwaysTrue();
                }
                case GT: 
                case GT_EQ: 
                case EQ: {
                    return Expressions.alwaysFalse();
                }
            }
        } else if (lit == Literals.belowMin()) {
            switch (this.op()) {
                case NOT_EQ: 
                case GT: 
                case GT_EQ: {
                    return Expressions.alwaysTrue();
                }
                case LT: 
                case LT_EQ: 
                case EQ: {
                    return Expressions.alwaysFalse();
                }
            }
        }
        return new BoundLiteralPredicate<T>(this.op(), boundTerm, lit);
    }

    private Expression bindInOperation(BoundTerm<T> boundTerm) {
        ArrayList convertedLiterals = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.transform(this.literals, lit -> {
            Literal converted = lit.to(boundTerm.type());
            ValidationException.check(converted != null, "Invalid value for conversion to type %s: %s (%s)", boundTerm.type(), lit, lit.getClass().getName());
            return converted;
        }), lit -> lit != Literals.aboveMax() && lit != Literals.belowMin()));
        if (convertedLiterals.isEmpty()) {
            switch (this.op()) {
                case IN: {
                    return Expressions.alwaysFalse();
                }
                case NOT_IN: {
                    return Expressions.alwaysTrue();
                }
            }
            throw new ValidationException("Operation must be IN or NOT_IN", new Object[0]);
        }
        Set<T> literalSet = UnboundPredicate.setOf(convertedLiterals);
        if (literalSet.size() == 1) {
            switch (this.op()) {
                case IN: {
                    return new BoundLiteralPredicate<T>(Expression.Operation.EQ, boundTerm, (Literal)Iterables.get((Iterable)convertedLiterals, (int)0));
                }
                case NOT_IN: {
                    return new BoundLiteralPredicate<T>(Expression.Operation.NOT_EQ, boundTerm, (Literal)Iterables.get((Iterable)convertedLiterals, (int)0));
                }
            }
            throw new ValidationException("Operation must be IN or NOT_IN", new Object[0]);
        }
        return new BoundSetPredicate<T>(this.op(), boundTerm, literalSet);
    }

    public String toString() {
        switch (this.op()) {
            case IS_NULL: {
                return "is_null(" + this.term() + ")";
            }
            case NOT_NULL: {
                return "not_null(" + this.term() + ")";
            }
            case LT: {
                return this.term() + " < " + this.literal();
            }
            case LT_EQ: {
                return this.term() + " <= " + this.literal();
            }
            case GT: {
                return this.term() + " > " + this.literal();
            }
            case GT_EQ: {
                return this.term() + " >= " + this.literal();
            }
            case EQ: {
                return this.term() + " == " + this.literal();
            }
            case NOT_EQ: {
                return this.term() + " != " + this.literal();
            }
            case STARTS_WITH: {
                return this.term() + " startsWith \"" + this.literal() + "\"";
            }
            case IN: {
                return this.term() + " in (" + COMMA.join(this.literals()) + ")";
            }
            case NOT_IN: {
                return this.term() + " not in (" + COMMA.join(this.literals()) + ")";
            }
        }
        return "Invalid predicate: operation = " + (Object)((Object)this.op());
    }

    static <T> Set<T> setOf(Iterable<Literal<T>> literals) {
        Literal lit = (Literal)Iterables.get(literals, (int)0);
        if (lit instanceof Literals.StringLiteral && lit.value() instanceof CharSequence) {
            Iterable values = Iterables.transform(literals, Literal::value);
            Iterable charSeqs = Iterables.transform((Iterable)values, val -> (CharSequence)val);
            return CharSequenceSet.of(charSeqs);
        }
        return Sets.newHashSet((Iterable)Iterables.transform(literals, Literal::value));
    }
}

