/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SQLViewRepresentation", generator="Immutables")
@Immutable
public final class ImmutableSQLViewRepresentation
implements SQLViewRepresentation {
    private final String sql;
    private final String dialect;
    @Nullable
    private final String defaultCatalog;
    @Nullable
    private final Namespace defaultNamespace;
    @Nullable
    private final Integer schemaId;
    private final List<String> fieldComments;
    private final List<String> fieldAliases;

    private ImmutableSQLViewRepresentation(String sql, String dialect, @Nullable String defaultCatalog, @Nullable Namespace defaultNamespace, @Nullable Integer schemaId, List<String> fieldComments, List<String> fieldAliases) {
        this.sql = sql;
        this.dialect = dialect;
        this.defaultCatalog = defaultCatalog;
        this.defaultNamespace = defaultNamespace;
        this.schemaId = schemaId;
        this.fieldComments = fieldComments;
        this.fieldAliases = fieldAliases;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public String dialect() {
        return this.dialect;
    }

    @Override
    @Nullable
    public String defaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    @Nullable
    public Namespace defaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    @Nullable
    public Integer schemaId() {
        return this.schemaId;
    }

    @Override
    public List<String> fieldComments() {
        return this.fieldComments;
    }

    @Override
    public List<String> fieldAliases() {
        return this.fieldAliases;
    }

    public final ImmutableSQLViewRepresentation withSql(String value) {
        String newValue = Objects.requireNonNull(value, "sql");
        if (this.sql.equals(newValue)) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(newValue, this.dialect, this.defaultCatalog, this.defaultNamespace, this.schemaId, this.fieldComments, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withDialect(String value) {
        String newValue = Objects.requireNonNull(value, "dialect");
        if (this.dialect.equals(newValue)) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(this.sql, newValue, this.defaultCatalog, this.defaultNamespace, this.schemaId, this.fieldComments, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withDefaultCatalog(@Nullable String value) {
        if (Objects.equals(this.defaultCatalog, value)) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, value, this.defaultNamespace, this.schemaId, this.fieldComments, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withDefaultNamespace(@Nullable Namespace value) {
        if (this.defaultNamespace == value) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, value, this.schemaId, this.fieldComments, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withSchemaId(@Nullable Integer value) {
        if (Objects.equals(this.schemaId, value)) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, this.defaultNamespace, value, this.fieldComments, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withFieldComments(String ... elements) {
        List<String> newValue = ImmutableSQLViewRepresentation.createUnmodifiableList(false, ImmutableSQLViewRepresentation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, this.defaultNamespace, this.schemaId, newValue, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withFieldComments(Iterable<String> elements) {
        if (this.fieldComments == elements) {
            return this;
        }
        List<String> newValue = ImmutableSQLViewRepresentation.createUnmodifiableList(false, ImmutableSQLViewRepresentation.createSafeList(elements, true, false));
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, this.defaultNamespace, this.schemaId, newValue, this.fieldAliases);
    }

    public final ImmutableSQLViewRepresentation withFieldAliases(String ... elements) {
        List<String> newValue = ImmutableSQLViewRepresentation.createUnmodifiableList(false, ImmutableSQLViewRepresentation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, this.defaultNamespace, this.schemaId, this.fieldComments, newValue);
    }

    public final ImmutableSQLViewRepresentation withFieldAliases(Iterable<String> elements) {
        if (this.fieldAliases == elements) {
            return this;
        }
        List<String> newValue = ImmutableSQLViewRepresentation.createUnmodifiableList(false, ImmutableSQLViewRepresentation.createSafeList(elements, true, false));
        return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, this.defaultNamespace, this.schemaId, this.fieldComments, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSQLViewRepresentation && this.equalTo(0, (ImmutableSQLViewRepresentation)another);
    }

    private boolean equalTo(int synthetic, ImmutableSQLViewRepresentation another) {
        return this.sql.equals(another.sql) && this.dialect.equals(another.dialect) && Objects.equals(this.defaultCatalog, another.defaultCatalog) && Objects.equals(this.defaultNamespace, another.defaultNamespace) && Objects.equals(this.schemaId, another.schemaId) && this.fieldComments.equals(another.fieldComments) && this.fieldAliases.equals(another.fieldAliases);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sql.hashCode();
        h += (h << 5) + this.dialect.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultCatalog);
        h += (h << 5) + Objects.hashCode(this.defaultNamespace);
        h += (h << 5) + Objects.hashCode(this.schemaId);
        h += (h << 5) + this.fieldComments.hashCode();
        h += (h << 5) + this.fieldAliases.hashCode();
        return h;
    }

    public String toString() {
        return "SQLViewRepresentation{sql=" + this.sql + ", dialect=" + this.dialect + ", defaultCatalog=" + this.defaultCatalog + ", defaultNamespace=" + this.defaultNamespace + ", schemaId=" + this.schemaId + ", fieldComments=" + this.fieldComments + ", fieldAliases=" + this.fieldAliases + "}";
    }

    public static ImmutableSQLViewRepresentation copyOf(SQLViewRepresentation instance) {
        if (instance instanceof ImmutableSQLViewRepresentation) {
            return (ImmutableSQLViewRepresentation)instance;
        }
        return ImmutableSQLViewRepresentation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SQLViewRepresentation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SQL = 1L;
        private static final long INIT_BIT_DIALECT = 2L;
        private long initBits = 3L;
        @Nullable
        private String sql;
        @Nullable
        private String dialect;
        @Nullable
        private String defaultCatalog;
        @Nullable
        private Namespace defaultNamespace;
        @Nullable
        private Integer schemaId;
        private List<String> fieldComments = new ArrayList<String>();
        private List<String> fieldAliases = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SQLViewRepresentation instance) {
            Integer schemaIdValue;
            Namespace defaultNamespaceValue;
            Objects.requireNonNull(instance, "instance");
            this.sql(instance.sql());
            this.dialect(instance.dialect());
            String defaultCatalogValue = instance.defaultCatalog();
            if (defaultCatalogValue != null) {
                this.defaultCatalog(defaultCatalogValue);
            }
            if ((defaultNamespaceValue = instance.defaultNamespace()) != null) {
                this.defaultNamespace(defaultNamespaceValue);
            }
            if ((schemaIdValue = instance.schemaId()) != null) {
                this.schemaId(schemaIdValue);
            }
            this.addAllFieldComments(instance.fieldComments());
            this.addAllFieldAliases(instance.fieldAliases());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sql(String sql) {
            this.sql = Objects.requireNonNull(sql, "sql");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dialect(String dialect) {
            this.dialect = Objects.requireNonNull(dialect, "dialect");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCatalog(@Nullable String defaultCatalog) {
            this.defaultCatalog = defaultCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultNamespace(@Nullable Namespace defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaId(@Nullable Integer schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFieldComments(String element) {
            this.fieldComments.add(Objects.requireNonNull(element, "fieldComments element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFieldComments(String ... elements) {
            for (String element : elements) {
                this.fieldComments.add(Objects.requireNonNull(element, "fieldComments element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldComments(Iterable<String> elements) {
            this.fieldComments.clear();
            return this.addAllFieldComments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFieldComments(Iterable<String> elements) {
            for (String element : elements) {
                this.fieldComments.add(Objects.requireNonNull(element, "fieldComments element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFieldAliases(String element) {
            this.fieldAliases.add(Objects.requireNonNull(element, "fieldAliases element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFieldAliases(String ... elements) {
            for (String element : elements) {
                this.fieldAliases.add(Objects.requireNonNull(element, "fieldAliases element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldAliases(Iterable<String> elements) {
            this.fieldAliases.clear();
            return this.addAllFieldAliases(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFieldAliases(Iterable<String> elements) {
            for (String element : elements) {
                this.fieldAliases.add(Objects.requireNonNull(element, "fieldAliases element"));
            }
            return this;
        }

        public ImmutableSQLViewRepresentation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSQLViewRepresentation(this.sql, this.dialect, this.defaultCatalog, this.defaultNamespace, this.schemaId, ImmutableSQLViewRepresentation.createUnmodifiableList(true, this.fieldComments), ImmutableSQLViewRepresentation.createUnmodifiableList(true, this.fieldAliases));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sql");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dialect");
            }
            return "Cannot build SQLViewRepresentation, some of required attributes are not set " + attributes;
        }
    }
}

