/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestAccessors {
    private static Accessor<StructLike> direct(Type type) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)17, (String)("field_" + type.typeId()), (Type)type)});
        return schema.accessorForField(17);
    }

    private static Accessor<StructLike> nested1(Type type) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)11, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)("field_" + type.typeId()), (Type)type)}))});
        return schema.accessorForField(17);
    }

    private static Accessor<StructLike> nested2(Type type) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)11, (String)"s", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)("field_" + type.typeId()), (Type)type)}))}))});
        return schema.accessorForField(17);
    }

    private static Accessor<StructLike> nested3(Type type) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)11, (String)"s", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)33, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)("field_" + type.typeId()), (Type)type)}))}))}))});
        return schema.accessorForField(17);
    }

    private static Accessor<StructLike> nested3optional(Type type) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)11, (String)"s", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)33, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)17, (String)("field_" + type.typeId()), (Type)type)}))}))}))});
        return schema.accessorForField(17);
    }

    private static Accessor<StructLike> nested4(Type type) {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)11, (String)"s", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)33, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)44, (String)"s4", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)("field_" + type.typeId()), (Type)type)}))}))}))}))});
        return schema.accessorForField(17);
    }

    private void assertAccessorReturns(Type type, Object value) {
        Assert.assertEquals((Object)value, (Object)TestAccessors.direct(type).get((Object)TestHelpers.Row.of(value)));
        Assert.assertEquals((Object)value, (Object)TestAccessors.nested1(type).get((Object)TestHelpers.Row.of(TestHelpers.Row.of(value))));
        Assert.assertEquals((Object)value, (Object)TestAccessors.nested2(type).get((Object)TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(value)))));
        Assert.assertEquals((Object)value, (Object)TestAccessors.nested3(type).get((Object)TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(value))))));
        Assert.assertEquals((Object)value, (Object)TestAccessors.nested4(type).get((Object)TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(value)))))));
        Assert.assertEquals((Object)value, (Object)TestAccessors.nested3optional(type).get((Object)TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(value))))));
    }

    @Test
    public void testBoolean() {
        this.assertAccessorReturns((Type)Types.BooleanType.get(), true);
        this.assertAccessorReturns((Type)Types.BooleanType.get(), false);
    }

    @Test
    public void testInt() {
        this.assertAccessorReturns((Type)Types.IntegerType.get(), 123);
    }

    @Test
    public void testLong() {
        this.assertAccessorReturns((Type)Types.LongType.get(), 123L);
    }

    @Test
    public void testFloat() {
        this.assertAccessorReturns((Type)Types.FloatType.get(), Float.valueOf(1.23f));
    }

    @Test
    public void testDouble() {
        this.assertAccessorReturns((Type)Types.DoubleType.get(), 1.23);
    }

    @Test
    public void testDate() {
        this.assertAccessorReturns((Type)Types.DateType.get(), 123);
    }

    @Test
    public void testTime() {
        this.assertAccessorReturns((Type)Types.TimeType.get(), 123L);
    }

    @Test
    public void testTimestamp() {
        this.assertAccessorReturns((Type)Types.TimestampType.withoutZone(), 123L);
        this.assertAccessorReturns((Type)Types.TimestampType.withZone(), 123L);
    }

    @Test
    public void testString() {
        this.assertAccessorReturns((Type)Types.StringType.get(), "abc");
    }

    @Test
    public void testUuid() {
        this.assertAccessorReturns((Type)Types.UUIDType.get(), UUID.randomUUID());
    }

    @Test
    public void testFixed() {
        this.assertAccessorReturns((Type)Types.FixedType.ofLength((int)3), ByteBuffer.wrap(new byte[]{1, 2, 3}));
    }

    @Test
    public void testBinary() {
        this.assertAccessorReturns((Type)Types.BinaryType.get(), ByteBuffer.wrap(new byte[]{1, 2, 3}));
    }

    @Test
    public void testDecimal() {
        this.assertAccessorReturns((Type)Types.DecimalType.of((int)5, (int)7), BigDecimal.valueOf(123.456));
    }

    @Test
    public void testList() {
        this.assertAccessorReturns((Type)Types.ListType.ofRequired((int)18, (Type)Types.IntegerType.get()), ImmutableList.of((Object)1, (Object)2, (Object)3));
        this.assertAccessorReturns((Type)Types.ListType.ofRequired((int)18, (Type)Types.StringType.get()), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    @Test
    public void testMap() {
        this.assertAccessorReturns((Type)Types.MapType.ofRequired((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()), ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
    }

    @Test
    public void testStructAsObject() {
        this.assertAccessorReturns((Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"str19", (Type)Types.StringType.get()), Types.NestedField.optional((int)19, (String)"int19", (Type)Types.IntegerType.get())}), TestHelpers.Row.of("a", 1));
    }

    @Test
    public void testEmptyStructAsObject() {
        this.assertAccessorReturns((Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)19, (String)"int19", (Type)Types.IntegerType.get())}), TestHelpers.Row.of(new Object[0]));
        this.assertAccessorReturns((Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]), TestHelpers.Row.of(new Object[0]));
    }

    @Test
    public void testEmptySchema() {
        Schema emptySchema = new Schema(new Types.NestedField[0]);
        Assert.assertNull((Object)emptySchema.accessorForField(17));
    }
}

