/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.util.ByteBuffers;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class TestHelpers {
    private TestHelpers() {
    }

    public static long waitUntilAfter(long timestampMillis) {
        long current = System.currentTimeMillis();
        while (current <= timestampMillis) {
            current = System.currentTimeMillis();
        }
        return current;
    }

    public static <T> T assertAndUnwrap(Expression expr, Class<T> expected) {
        Assert.assertTrue((String)("Expression should have expected type: " + expected), (boolean)expected.isInstance(expr));
        return expected.cast(expr);
    }

    public static <T> BoundPredicate<T> assertAndUnwrap(Expression expr) {
        Assert.assertTrue((String)("Expression should be a bound predicate: " + expr), (boolean)(expr instanceof BoundPredicate));
        return (BoundPredicate)expr;
    }

    public static <T> BoundSetPredicate<T> assertAndUnwrapBoundSet(Expression expr) {
        Assert.assertTrue((String)("Expression should be a bound set predicate: " + expr), (boolean)(expr instanceof BoundSetPredicate));
        return (BoundSetPredicate)expr;
    }

    public static <T> UnboundPredicate<T> assertAndUnwrapUnbound(Expression expr) {
        Assert.assertTrue((String)("Expression should be an unbound predicate: " + expr), (boolean)(expr instanceof UnboundPredicate));
        return (UnboundPredicate)expr;
    }

    public static void assertAllReferencesBound(String message, Expression expr) {
        ExpressionVisitors.visit((Expression)expr, (ExpressionVisitors.ExpressionVisitor)new CheckReferencesBound(message));
    }

    public static <T> T roundTripSerialize(T type) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(type);
        }
        var3_3 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object object = in.readObject();
            return (T)object;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    public static void assertSameSchemaList(List<Schema> list1, List<Schema> list2) {
        ((ListAssert)Assertions.assertThat(list1).as("Should have same number of schemas in both lists", new Object[0])).hasSameSizeAs(list2);
        IntStream.range(0, list1.size()).forEach(index -> {
            Schema schema1 = (Schema)list1.get(index);
            Schema schema2 = (Schema)list2.get(index);
            Assert.assertEquals((String)"Should have matching schema id", (long)schema1.schemaId(), (long)schema2.schemaId());
            Assert.assertEquals((String)"Should have matching schema struct", (Object)schema1.asStruct(), (Object)schema2.asStruct());
        });
    }

    public static void assertSerializedMetadata(Table expected, Table actual) {
        Assert.assertEquals((String)"Name must match", (Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((String)"Location must match", (Object)expected.location(), (Object)actual.location());
        Assert.assertEquals((String)"Props must match", (Object)expected.properties(), (Object)actual.properties());
        Assert.assertEquals((String)"Schema must match", (Object)expected.schema().asStruct(), (Object)actual.schema().asStruct());
        Assert.assertEquals((String)"Spec must match", (Object)expected.spec(), (Object)actual.spec());
        Assert.assertEquals((String)"Sort order must match", (Object)expected.sortOrder(), (Object)actual.sortOrder());
    }

    public static void assertSerializedAndLoadedMetadata(Table expected, Table actual) {
        TestHelpers.assertSerializedMetadata(expected, actual);
        Assert.assertEquals((String)"Specs must match", (Object)expected.specs(), (Object)actual.specs());
        Assert.assertEquals((String)"Sort orders must match", (Object)expected.sortOrders(), (Object)actual.sortOrders());
        Assert.assertEquals((String)"Current snapshot must match", (Object)expected.currentSnapshot(), (Object)actual.currentSnapshot());
        Assert.assertEquals((String)"Snapshots must match", (Object)expected.snapshots(), (Object)actual.snapshots());
        Assert.assertEquals((String)"History must match", (Object)expected.history(), (Object)actual.history());
    }

    public static void assertSameSchemaMap(Map<Integer, Schema> map1, Map<Integer, Schema> map2) {
        ((MapAssert)Assertions.assertThat(map1).as("Should have same number of schemas in both maps", new Object[0])).hasSameSizeAs(map2);
        map1.forEach((schemaId, schema1) -> {
            Schema schema2 = (Schema)map2.get(schemaId);
            Assert.assertNotNull((String)String.format("Schema ID %s does not exist in map: %s", schemaId, map2), (Object)schema2);
            Assert.assertEquals((String)"Should have matching schema id", (long)schema1.schemaId(), (long)schema2.schemaId());
            Assert.assertTrue((String)String.format("Should be the same schema. Schema 1: %s, schema 2: %s", schema1, schema2), (boolean)schema1.sameSchema(schema2));
        });
    }

    public static class TestDataFile
    implements DataFile {
        private final String path;
        private final StructLike partition;
        private final long recordCount;
        private final Map<Integer, Long> valueCounts;
        private final Map<Integer, Long> nullValueCounts;
        private final Map<Integer, Long> nanValueCounts;
        private final Map<Integer, ByteBuffer> lowerBounds;
        private final Map<Integer, ByteBuffer> upperBounds;

        public TestDataFile(String path, StructLike partition, long recordCount) {
            this(path, partition, recordCount, null, null, null, null, null);
        }

        public TestDataFile(String path, StructLike partition, long recordCount, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts, Map<Integer, ByteBuffer> lowerBounds, Map<Integer, ByteBuffer> upperBounds) {
            this.path = path;
            this.partition = partition;
            this.recordCount = recordCount;
            this.valueCounts = valueCounts;
            this.nullValueCounts = nullValueCounts;
            this.nanValueCounts = nanValueCounts;
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        public Long pos() {
            return null;
        }

        public int specId() {
            return 0;
        }

        public CharSequence path() {
            return this.path;
        }

        public FileFormat format() {
            return FileFormat.fromFileName((CharSequence)this.path());
        }

        public StructLike partition() {
            return this.partition;
        }

        public long recordCount() {
            return this.recordCount;
        }

        public long fileSizeInBytes() {
            return 0L;
        }

        public Map<Integer, Long> columnSizes() {
            return null;
        }

        public Map<Integer, Long> valueCounts() {
            return this.valueCounts;
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.nullValueCounts;
        }

        public Map<Integer, Long> nanValueCounts() {
            return this.nanValueCounts;
        }

        public Map<Integer, ByteBuffer> lowerBounds() {
            return this.lowerBounds;
        }

        public Map<Integer, ByteBuffer> upperBounds() {
            return this.upperBounds;
        }

        public ByteBuffer keyMetadata() {
            return null;
        }

        public DataFile copy() {
            return this;
        }

        public DataFile copyWithoutStats() {
            return this;
        }

        public List<Long> splitOffsets() {
            return null;
        }
    }

    public static class TestManifestFile
    implements ManifestFile {
        private final String path;
        private final long length;
        private final int specId;
        private final ManifestContent content;
        private final Long snapshotId;
        private final Integer addedFiles;
        private final Long addedRows;
        private final Integer existingFiles;
        private final Long existingRows;
        private final Integer deletedFiles;
        private final Long deletedRows;
        private final List<ManifestFile.PartitionFieldSummary> partitions;
        private final byte[] keyMetadata;

        public TestManifestFile(String path, long length, int specId, Long snapshotId, Integer addedFiles, Integer existingFiles, Integer deletedFiles, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata) {
            this.path = path;
            this.length = length;
            this.specId = specId;
            this.content = ManifestContent.DATA;
            this.snapshotId = snapshotId;
            this.addedFiles = addedFiles;
            this.addedRows = null;
            this.existingFiles = existingFiles;
            this.existingRows = null;
            this.deletedFiles = deletedFiles;
            this.deletedRows = null;
            this.partitions = partitions;
            this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)keyMetadata);
        }

        public TestManifestFile(String path, long length, int specId, ManifestContent content, Long snapshotId, Integer addedFiles, Long addedRows, Integer existingFiles, Long existingRows, Integer deletedFiles, Long deletedRows, List<ManifestFile.PartitionFieldSummary> partitions, ByteBuffer keyMetadata) {
            this.path = path;
            this.length = length;
            this.specId = specId;
            this.content = content;
            this.snapshotId = snapshotId;
            this.addedFiles = addedFiles;
            this.addedRows = addedRows;
            this.existingFiles = existingFiles;
            this.existingRows = existingRows;
            this.deletedFiles = deletedFiles;
            this.deletedRows = deletedRows;
            this.partitions = partitions;
            this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)keyMetadata);
        }

        public String path() {
            return this.path;
        }

        public long length() {
            return this.length;
        }

        public int partitionSpecId() {
            return this.specId;
        }

        public ManifestContent content() {
            return this.content;
        }

        public long sequenceNumber() {
            return 0L;
        }

        public long minSequenceNumber() {
            return 0L;
        }

        public Long snapshotId() {
            return this.snapshotId;
        }

        public Integer addedFilesCount() {
            return this.addedFiles;
        }

        public Long addedRowsCount() {
            return this.addedRows;
        }

        public Integer existingFilesCount() {
            return this.existingFiles;
        }

        public Long existingRowsCount() {
            return this.existingRows;
        }

        public Integer deletedFilesCount() {
            return this.deletedFiles;
        }

        public Long deletedRowsCount() {
            return this.deletedRows;
        }

        public List<ManifestFile.PartitionFieldSummary> partitions() {
            return this.partitions;
        }

        public ByteBuffer keyMetadata() {
            return this.keyMetadata == null ? null : ByteBuffer.wrap(this.keyMetadata);
        }

        public ManifestFile copy() {
            return this;
        }
    }

    public static class TestFieldSummary
    implements ManifestFile.PartitionFieldSummary {
        private final boolean containsNull;
        private final Boolean containsNaN;
        private final ByteBuffer lowerBound;
        private final ByteBuffer upperBound;

        public TestFieldSummary(boolean containsNull, ByteBuffer lowerBound, ByteBuffer upperBound) {
            this(containsNull, null, lowerBound, upperBound);
        }

        public TestFieldSummary(boolean containsNull, Boolean containsNaN, ByteBuffer lowerBound, ByteBuffer upperBound) {
            this.containsNull = containsNull;
            this.containsNaN = containsNaN;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public boolean containsNull() {
            return this.containsNull;
        }

        public Boolean containsNaN() {
            return this.containsNaN;
        }

        public ByteBuffer lowerBound() {
            return this.lowerBound;
        }

        public ByteBuffer upperBound() {
            return this.upperBound;
        }

        public ManifestFile.PartitionFieldSummary copy() {
            return this;
        }
    }

    public static class Row
    implements StructLike {
        private final Object[] values;

        public static Row of(Object ... values) {
            return new Row(values);
        }

        private Row(Object ... values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            this.values[pos] = value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Row that = (Row)other;
            return Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }

    private static class CheckReferencesBound
    extends ExpressionVisitors.ExpressionVisitor<Void> {
        private final String message;

        CheckReferencesBound(String message) {
            this.message = message;
        }

        public <T> Void predicate(UnboundPredicate<T> pred) {
            Assert.fail((String)(this.message + ": Found unbound predicate: " + pred));
            return null;
        }
    }

    public static class KryoHelpers {
        private KryoHelpers() {
        }

        public static <T> T roundTripSerialize(T obj) throws IOException {
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            kryo.register(SerializedLambda.class);
            kryo.register(ClosureSerializer.Closure.class, (Serializer)new ClosureSerializer());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (Output out = new Output((OutputStream)new ObjectOutputStream(bytes));){
                kryo.writeClassAndObject(out, obj);
            }
            var4_4 = null;
            try (Input in = new Input((InputStream)new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())));){
                Object object = kryo.readClassAndObject(in);
                return (T)object;
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
        }
    }
}

