/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.iceberg.IcebergBuild;
import org.junit.Assert;
import org.junit.Test;

public class TestIcebergBuild {
    @Test
    public void testFullVersion() {
        Assert.assertEquals((String)"Should build full version from version and commit ID", (Object)("Apache Iceberg " + IcebergBuild.version() + " (commit " + IcebergBuild.gitCommitId() + ")"), (Object)IcebergBuild.fullVersion());
    }

    @Test
    public void testVersion() {
        Assert.assertNotEquals((String)"Should not use unknown version", (Object)"unknown", (Object)IcebergBuild.version());
    }

    @Test
    public void testGitCommitId() {
        Assert.assertNotEquals((String)"Should not use unknown commit ID", (Object)"unknown", (Object)IcebergBuild.gitCommitId());
        Assert.assertTrue((String)"Should be a hexadecimal string of 20 bytes", (boolean)Pattern.compile("[0-9a-f]{40}").matcher(IcebergBuild.gitCommitId().toLowerCase(Locale.ROOT)).matches());
    }
}

