/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestPartitionPaths {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withoutZone())});

    @Test
    public void testPartitionPath() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").bucket("id", 10).build();
        Transform hour = Transforms.hour();
        Transform bucket = Transforms.bucket((int)10);
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194").to((Type)Types.TimestampType.withoutZone());
        Object tsHour = hour.bind((Type)Types.TimestampType.withoutZone()).apply((Object)((Long)ts.value()));
        Object idBucket = bucket.bind((Type)Types.IntegerType.get()).apply((Object)1);
        TestHelpers.Row partition = TestHelpers.Row.of(tsHour, idBucket);
        Assert.assertEquals((String)"Should produce expected partition key", (Object)("ts_hour=2017-12-01-10/id_bucket=" + idBucket), (Object)spec.partitionToPath((StructLike)partition));
    }

    @Test
    public void testEscapedStrings() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("data").truncate("data", 10).build();
        Assert.assertEquals((String)"Should escape / as %2F", (Object)"data=a%2Fb%2Fc%2Fd/data_trunc=a%2Fb%2Fc%2Fd", (Object)spec.partitionToPath((StructLike)TestHelpers.Row.of("a/b/c/d", "a/b/c/d")));
    }
}

