/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotRefType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestSnapshotRef {
    @Test
    public void testTagDefault() {
        SnapshotRef ref = SnapshotRef.tagBuilder((long)1L).build();
        Assert.assertEquals((long)1L, (long)ref.snapshotId());
        Assert.assertEquals((Object)SnapshotRefType.TAG, (Object)ref.type());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
        Assert.assertNull((Object)ref.maxRefAgeMs());
    }

    @Test
    public void testBranchDefault() {
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).build();
        Assert.assertEquals((long)1L, (long)ref.snapshotId());
        Assert.assertEquals((Object)SnapshotRefType.BRANCH, (Object)ref.type());
        Assert.assertNull((Object)ref.minSnapshotsToKeep());
        Assert.assertNull((Object)ref.maxSnapshotAgeMs());
    }

    @Test
    public void testTagWithOverride() {
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).maxRefAgeMs(Long.valueOf(10L)).build();
        Assert.assertEquals((long)1L, (long)ref.snapshotId());
        Assert.assertEquals((Object)SnapshotRefType.BRANCH, (Object)ref.type());
        Assert.assertEquals((long)10L, (long)ref.maxRefAgeMs());
    }

    @Test
    public void testBranchWithOverride() {
        SnapshotRef ref = SnapshotRef.branchBuilder((long)1L).minSnapshotsToKeep(Integer.valueOf(10)).maxSnapshotAgeMs(Long.valueOf(20L)).maxRefAgeMs(Long.valueOf(30L)).build();
        Assert.assertEquals((long)1L, (long)ref.snapshotId());
        Assert.assertEquals((Object)SnapshotRefType.BRANCH, (Object)ref.type());
        Assert.assertEquals((long)10L, (long)ref.minSnapshotsToKeep().intValue());
        Assert.assertEquals((long)20L, (long)ref.maxSnapshotAgeMs());
        Assert.assertEquals((long)30L, (long)ref.maxRefAgeMs());
    }

    @Test
    public void testNoTypeFailure() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.builderFor((long)1L, null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Snapshot reference type must not be null");
    }

    @Test
    public void testTagBuildFailures() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.tagBuilder((long)1L).maxRefAgeMs(Long.valueOf(-1L)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Max reference age must be greater than 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.tagBuilder((long)1L).minSnapshotsToKeep(Integer.valueOf(2)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tags do not support setting minSnapshotsToKeep");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.tagBuilder((long)1L).maxSnapshotAgeMs(Long.valueOf(2L)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tags do not support setting maxSnapshotAgeMs");
    }

    @Test
    public void testBranchBuildFailures() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.branchBuilder((long)1L).maxSnapshotAgeMs(Long.valueOf(-1L)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Max snapshot age must be greater than 0 ms");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.branchBuilder((long)1L).minSnapshotsToKeep(Integer.valueOf(-1)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Min snapshots to keep must be greater than 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnapshotRef.branchBuilder((long)1L).maxRefAgeMs(Long.valueOf(-1L)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Max reference age must be greater than 0");
    }
}

