/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestTableIdentifier {
    @Test
    public void testTableIdentifierParsing() {
        TableIdentifier oneLevelIdentifier = TableIdentifier.parse((String)"tbl");
        Assert.assertFalse((boolean)oneLevelIdentifier.hasNamespace());
        Assert.assertEquals((Object)"tbl", (Object)oneLevelIdentifier.name());
        TableIdentifier twoLevelIdentifier = TableIdentifier.parse((String)"userdb.tbl");
        Assert.assertEquals((long)1L, (long)twoLevelIdentifier.namespace().levels().length);
        Assert.assertEquals((Object)"userdb", (Object)twoLevelIdentifier.namespace().levels()[0]);
        Assert.assertEquals((Object)"tbl", (Object)twoLevelIdentifier.name());
        TableIdentifier threeLevelIdentifier = TableIdentifier.parse((String)"catalog.userdb.tbl");
        Assert.assertEquals((long)2L, (long)threeLevelIdentifier.namespace().levels().length);
        Assert.assertEquals((Object)"catalog", (Object)threeLevelIdentifier.namespace().levels()[0]);
        Assert.assertEquals((Object)"userdb", (Object)threeLevelIdentifier.namespace().levels()[1]);
        Assert.assertEquals((Object)"tbl", (Object)threeLevelIdentifier.name());
    }

    @Test
    public void testToLowerCase() {
        Assert.assertEquals((Object)TableIdentifier.of((String[])new String[]{"Tbl"}).toLowerCase(), (Object)TableIdentifier.of((String[])new String[]{"tbl"}));
        Assert.assertEquals((Object)TableIdentifier.of((String[])new String[]{"dB", "TBL"}).toLowerCase(), (Object)TableIdentifier.of((String[])new String[]{"db", "tbl"}));
        Assert.assertEquals((Object)TableIdentifier.of((String[])new String[]{"Catalog", "dB", "TBL"}).toLowerCase(), (Object)TableIdentifier.of((String[])new String[]{"catalog", "db", "tbl"}));
    }

    @Test
    public void testInvalidTableName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of((Namespace)Namespace.empty(), (String)"")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid table name: null or empty");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of((Namespace)Namespace.empty(), null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid table name: null or empty");
    }

    @Test
    public void testNulls() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of((String[])null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create table identifier from null array");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.parse(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot parse table identifier: null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableIdentifier.of(null, (String)"name")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid Namespace: null");
    }
}

