/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestEvaluator {
    private static final Types.StructType STRUCT = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)14, (String)"y", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)15, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)16, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"s4", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"i", (Type)Types.IntegerType.get())}))}))}))})), Types.NestedField.optional((int)21, (String)"s5", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s6", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)23, (String)"f", (Type)Types.FloatType.get())}))}))});

    @Test
    public void testLessThan() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThan((String)"x", (Object)7));
        Assert.assertFalse((String)"7 < 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, null)));
        Assert.assertTrue((String)"6 < 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThan((String)"s1.s2.s3.s4.i", (Object)7));
        Assert.assertFalse((String)"7 < 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"6 < 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
    }

    @Test
    public void testLessThanOrEqual() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThanOrEqual((String)"x", (Object)7));
        Assert.assertTrue((String)"7 <= 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertTrue((String)"6 <= 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null)));
        Assert.assertFalse((String)"8 <= 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.lessThanOrEqual((String)"s1.s2.s3.s4.i", (Object)7));
        Assert.assertTrue((String)"7 <= 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"6 <= 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
        Assert.assertFalse((String)"8 <= 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
    }

    @Test
    public void testGreaterThan() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThan((String)"x", (Object)7));
        Assert.assertFalse((String)"7 > 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertFalse((String)"6 > 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null)));
        Assert.assertTrue((String)"8 > 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThan((String)"s1.s2.s3.s4.i", (Object)7));
        Assert.assertFalse((String)"7 > 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertFalse((String)"6 > 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
        Assert.assertTrue((String)"8 > 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
    }

    @Test
    public void testGreaterThanOrEqual() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThanOrEqual((String)"x", (Object)7));
        Assert.assertTrue((String)"7 >= 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertFalse((String)"6 >= 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null)));
        Assert.assertTrue((String)"8 >= 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.greaterThanOrEqual((String)"s1.s2.s3.s4.i", (Object)7));
        Assert.assertTrue((String)"7 >= 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertFalse((String)"6 >= 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
        Assert.assertTrue((String)"8 >= 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
    }

    @Test
    public void testEqual() {
        Assert.assertEquals((long)1L, (long)Expressions.equal((String)"x", (Object)5).literals().size());
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.equal((String)"x", (Object)7));
        Assert.assertTrue((String)"7 == 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertFalse((String)"6 == 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7));
        Assert.assertTrue((String)"7 == 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertFalse((String)"6 == 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
    }

    @Test
    public void testNotEqual() {
        Assert.assertEquals((long)1L, (long)Expressions.notEqual((String)"x", (Object)5).literals().size());
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notEqual((String)"x", (Object)7));
        Assert.assertFalse((String)"7 != 7 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertTrue((String)"6 != 7 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notEqual((String)"s1.s2.s3.s4.i", (Object)7));
        Assert.assertFalse((String)"7 != 7 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"6 != 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
    }

    @Test
    public void testStartsWith() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)24, (String)"s", (Type)Types.StringType.get())});
        Evaluator evaluator = new Evaluator(struct, (Expression)Expressions.startsWith((String)"s", (String)"abc"));
        Assert.assertTrue((String)"abc startsWith abc should be true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abc")));
        Assert.assertFalse((String)"xabc startsWith abc should be false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("xabc")));
        Assert.assertFalse((String)"Abc startsWith abc should be false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("Abc")));
        Assert.assertFalse((String)"a startsWith abc should be false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a")));
        Assert.assertTrue((String)"abcd startsWith abc should be true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcd")));
        Assert.assertFalse((String)"null startsWith abc should be false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Object[]{null})));
    }

    @Test
    public void testNotStartsWith() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)24, (String)"s", (Type)Types.StringType.get())});
        Evaluator evaluator = new Evaluator(struct, (Expression)Expressions.notStartsWith((String)"s", (String)"abc"));
        Assert.assertFalse((String)"abc notStartsWith abc should be false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abc")));
        Assert.assertTrue((String)"xabc notStartsWith abc should be true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("xabc")));
        Assert.assertTrue((String)"Abc notStartsWith abc should be true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("Abc")));
        Assert.assertTrue((String)"a notStartsWith abc should be true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("a")));
        Assert.assertFalse((String)"abcde notStartsWith abc should be false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("abcde")));
        Assert.assertTrue((String)"Abcde notStartsWith abc should be true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of("Abcde")));
    }

    @Test
    public void testAlwaysTrue() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.alwaysTrue());
        Assert.assertTrue((String)"always true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Object[0])));
    }

    @Test
    public void testAlwaysFalse() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.alwaysFalse());
        Assert.assertFalse((String)"always false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Object[0])));
    }

    @Test
    public void testIsNull() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.isNull((String)"z"));
        Assert.assertTrue((String)"null is null", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, null)));
        Assert.assertFalse((String)"3 is not null", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.isNull((String)"s1.s2.s3.s4.i"));
        Assert.assertFalse((String)"3 is not null", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(3)))))));
    }

    @Test
    public void testNotNull() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notNull((String)"z"));
        Assert.assertFalse((String)"null is null", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, null)));
        Assert.assertTrue((String)"3 is not null", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notNull((String)"s1.s2.s3.s4.i"));
        Assert.assertTrue((String)"3 is not null", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(3)))))));
    }

    @Test
    public void testIsNan() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.isNaN((String)"y"));
        Assert.assertTrue((String)"NaN is NaN", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, Double.NaN, 3)));
        Assert.assertFalse((String)"2 is not NaN", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2.0, 3)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.isNaN((String)"s5.s6.f"));
        Assert.assertTrue((String)"NaN is NaN", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(Float.NaN))))));
        Assert.assertFalse((String)"4F is not NaN", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(4.0f))))));
    }

    @Test
    public void testNotNaN() {
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notNaN((String)"y"));
        Assert.assertFalse((String)"NaN is NaN", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, Double.NaN, 3)));
        Assert.assertTrue((String)"2 is not NaN", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(1, 2.0, 3)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notNaN((String)"s5.s6.f"));
        Assert.assertFalse((String)"NaN is NaN", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(Float.NaN))))));
        Assert.assertTrue((String)"4F is not NaN", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(1, 2, 3, null, TestHelpers.Row.of(TestHelpers.Row.of(Float.valueOf(4.0f))))));
    }

    @Test
    public void testAnd() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.and((Expression)Expressions.equal((String)"x", (Object)7), (Expression)Expressions.notNull((String)"z")));
        Assert.assertTrue((String)"7, 3 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3)));
        Assert.assertFalse((String)"8, 3 => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3)));
        Assert.assertFalse((String)"7, null => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null)));
        Assert.assertFalse((String)"8, null => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.and((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7), (Expression)Expressions.notNull((String)"s1.s2.s3.s4.i")));
        Assert.assertTrue((String)"7, 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertFalse((String)"8, 8 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
        Assert.assertFalse((String)"7, null => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null, null)));
        Assert.assertFalse((String)"8, notnull => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, 0, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
    }

    @Test
    public void testOr() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.or((Expression)Expressions.equal((String)"x", (Object)7), (Expression)Expressions.notNull((String)"z")));
        Assert.assertTrue((String)"7, 3 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3)));
        Assert.assertTrue((String)"8, 3 => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3)));
        Assert.assertTrue((String)"7, null => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null)));
        Assert.assertFalse((String)"8, null => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8, 0, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.or((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7), (Expression)Expressions.notNull((String)"s1.s2.s3.s4.i")));
        Assert.assertTrue((String)"7, 7 => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"8, 8 => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, 0, 3, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
        Assert.assertTrue((String)"7, notnull => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 0, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
    }

    @Test
    public void testNot() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"x", (Object)7)));
        Assert.assertFalse((String)"not(7 == 7) => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7)));
        Assert.assertTrue((String)"not(8 == 7) => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8)));
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7)));
        Assert.assertFalse((String)"not(7 == 7) => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"not(8 == 7) => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
    }

    @Test
    public void testCaseInsensitiveNot() {
        Evaluator evaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"X", (Object)7)), false);
        Assert.assertFalse((String)"not(7 == 7) => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7)));
        Assert.assertTrue((String)"not(8 == 7) => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(8)));
        Evaluator structEvaluator = new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"s1.s2.s3.s4.i", (Object)7)), false);
        Assert.assertFalse((String)"not(7 == 7) => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"not(8 == 7) => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(8, null, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(8)))))));
    }

    @Test
    public void testCaseSensitiveNot() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, Expressions.not((Expression)Expressions.equal((String)"X", (Object)7)), true)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'X' in struct");
    }

    @Test
    public void testCharSeqValue() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"s", (Type)Types.StringType.get())});
        Evaluator evaluator = new Evaluator(struct, (Expression)Expressions.equal((String)"s", (Object)"abc"));
        Assert.assertTrue((String)"string(abc) == utf8(abc) => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abc"))));
        Assert.assertFalse((String)"string(abc) == utf8(abcd) => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abcd"))));
    }

    @Test
    public void testIn() {
        Assert.assertEquals((long)3L, (long)Expressions.in((String)"s", (Object[])new Integer[]{7, 8, 9}).literals().size());
        Assert.assertEquals((long)3L, (long)Expressions.in((String)"s", (Object[])new Number[]{7, 8.1, Long.MAX_VALUE}).literals().size());
        Assert.assertEquals((long)3L, (long)Expressions.in((String)"s", (Object[])new String[]{"abc", "abd", "abc"}).literals().size());
        Assert.assertEquals((long)0L, (long)Expressions.in((String)"s", (Object[])new Object[0]).literals().size());
        Assert.assertEquals((long)1L, (long)Expressions.in((String)"s", (Object[])new Integer[]{5}).literals().size());
        Assert.assertEquals((long)2L, (long)Expressions.in((String)"s", (Object[])new Integer[]{5, 5}).literals().size());
        Assert.assertEquals((long)2L, (long)Expressions.in((String)"s", Arrays.asList(5, 5)).literals().size());
        Assert.assertEquals((long)0L, (long)Expressions.in((String)"s", Collections.emptyList()).literals().size());
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"x", (Object[])new Number[]{7, 8, Long.MAX_VALUE}));
        Assert.assertTrue((String)"7 in [7, 8] => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertFalse((String)"9 in [7, 8]  => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(9, 8, null)));
        Evaluator intSetEvaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"x", (Object[])new Number[]{Long.MAX_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE}));
        Assert.assertTrue((String)"Integer.MAX_VALUE in [Integer.MAX_VALUE] => true", (boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(Integer.MAX_VALUE, 7.0, null)));
        Assert.assertFalse((String)"6 in [Integer.MAX_VALUE]  => false", (boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null)));
        Evaluator integerEvaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"y", (Object[])new Number[]{7, 8, 9.1}));
        Assert.assertTrue((String)"7.0 in [7, 8, 9.1] => true", (boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(0, 7.0, null)));
        Assert.assertTrue((String)"9.1 in [7, 8, 9.1] => true", (boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(7, 9.1, null)));
        Assert.assertFalse((String)"6.8 in [7, 8, 9.1]  => false", (boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.in((String)"s1.s2.s3.s4.i", (Object[])new Integer[]{7, 8, 9}));
        Assert.assertTrue((String)"7 in [7, 8, 9] => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertFalse((String)"6 in [7, 8, 9]  => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
        Types.StructType charSeqStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"s", (Type)Types.StringType.get())});
        Evaluator charSeqEvaluator = new Evaluator(charSeqStruct, (Expression)Expressions.in((String)"s", (Object[])new String[]{"abc", "abd", "abc"}));
        Assert.assertTrue((String)"utf8(abc) in [string(abc), string(abd)] => true", (boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abc"))));
        Assert.assertFalse((String)"utf8(abcd) in [string(abc), string(abd)] => false", (boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abcd"))));
    }

    @Test
    public void testInExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Object[])new Literal[]{null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Iterable)null)).isInstanceOf(NullPointerException.class)).hasMessage("Values cannot be null for IN predicate.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Object[])new Integer[]{5, 6}).literal()).isInstanceOf(IllegalArgumentException.class)).hasMessage("IN predicate cannot return a literal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.in((String)"x", (Object[])new Integer[]{1, 2, null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.in((String)"x", (Object[])new Number[]{7, 8, 9.1}))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.predicate((Expression.Operation)Expression.Operation.IN, (String)"x")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create IN predicate without a value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.predicate((Expression.Operation)Expression.Operation.IN, (String)"x", (Object)5.1))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
    }

    @Test
    public void testNotIn() {
        Assert.assertEquals((long)3L, (long)Expressions.notIn((String)"s", (Object[])new Integer[]{7, 8, 9}).literals().size());
        Assert.assertEquals((long)3L, (long)Expressions.notIn((String)"s", (Object[])new Number[]{7, 8.1, Long.MAX_VALUE}).literals().size());
        Assert.assertEquals((long)3L, (long)Expressions.notIn((String)"s", (Object[])new String[]{"abc", "abd", "abc"}).literals().size());
        Assert.assertEquals((long)0L, (long)Expressions.notIn((String)"s", (Object[])new Object[0]).literals().size());
        Assert.assertEquals((long)1L, (long)Expressions.notIn((String)"s", (Object[])new Integer[]{5}).literals().size());
        Assert.assertEquals((long)2L, (long)Expressions.notIn((String)"s", (Object[])new Integer[]{5, 5}).literals().size());
        Assert.assertEquals((long)2L, (long)Expressions.notIn((String)"s", Arrays.asList(5, 5)).literals().size());
        Assert.assertEquals((long)0L, (long)Expressions.notIn((String)"s", Collections.emptyList()).literals().size());
        Evaluator evaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"x", (Object[])new Number[]{7, 8, Long.MAX_VALUE}));
        Assert.assertFalse((String)"7 not in [7, 8] => false", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null)));
        Assert.assertTrue((String)"6 not in [7, 8]  => true", (boolean)evaluator.eval((StructLike)TestHelpers.Row.of(9, 8, null)));
        Evaluator intSetEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"x", (Object[])new Number[]{Long.MAX_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE}));
        Assert.assertFalse((String)"Integer.MAX_VALUE not_in [Integer.MAX_VALUE] => false", (boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(Integer.MAX_VALUE, 7.0, null)));
        Assert.assertTrue((String)"6 not_in [Integer.MAX_VALUE]  => true", (boolean)intSetEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null)));
        Evaluator integerEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"y", (Object[])new Number[]{7, 8, 9.1}));
        Assert.assertFalse((String)"7.0 not in [7, 8, 9] => false", (boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(0, 7.0, null)));
        Assert.assertFalse((String)"9.1 not in [7, 8, 9.1] => false", (boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(7, 9.1, null)));
        Assert.assertTrue((String)"6.8 not in [7, 8, 9.1]  => true", (boolean)integerEvaluator.eval((StructLike)TestHelpers.Row.of(6, 6.8, null)));
        Evaluator structEvaluator = new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"s1.s2.s3.s4.i", (Object[])new Integer[]{7, 8, 9}));
        Assert.assertFalse((String)"7 not in [7, 8, 9] => false", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(7, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(7)))))));
        Assert.assertTrue((String)"6 not in [7, 8, 9]  => true", (boolean)structEvaluator.eval((StructLike)TestHelpers.Row.of(6, 8, null, TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(TestHelpers.Row.of(6)))))));
        Types.StructType charSeqStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"s", (Type)Types.StringType.get())});
        Evaluator charSeqEvaluator = new Evaluator(charSeqStruct, (Expression)Expressions.notIn((String)"s", (Object[])new String[]{"abc", "abd", "abc"}));
        Assert.assertFalse((String)"utf8(abc) not in [string(abc), string(abd)] => false", (boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abc"))));
        Assert.assertTrue((String)"utf8(abcd) not in [string(abc), string(abd)] => true", (boolean)charSeqEvaluator.eval((StructLike)TestHelpers.Row.of(new Utf8("abcd"))));
    }

    @Test
    public void testNotInExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Object[])new Literal[]{null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Iterable)null)).isInstanceOf(NullPointerException.class)).hasMessage("Values cannot be null for NOT_IN predicate.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Object[])new Integer[]{5, 6}).literal()).isInstanceOf(IllegalArgumentException.class)).hasMessage("NOT_IN predicate cannot return a literal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.notIn((String)"x", (Object[])new Integer[]{1, 2, null})).isInstanceOf(NullPointerException.class)).hasMessage("Cannot create expression literal from null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.notIn((String)"x", (Object[])new Number[]{7, 8, 9.1}))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.predicate((Expression.Operation)Expression.Operation.NOT_IN, (String)"x")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create NOT_IN predicate without a value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Evaluator(STRUCT, (Expression)Expressions.predicate((Expression.Operation)Expression.Operation.NOT_IN, (String)"x", (Object)5.1))).isInstanceOf(ValidationException.class)).hasMessageContaining("Invalid value for conversion to type int");
    }
}

