/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressionBinding {
    private static final Types.StructType STRUCT = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"z", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"data", (Type)Types.StringType.get())});

    @Test
    public void testMissingReference() {
        Expression expr = Expressions.and((Expression)Expressions.equal((String)"t", (Object)5), (Expression)Expressions.equal((String)"x", (Object)7));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Binder.bind((Types.StructType)STRUCT, (Expression)expr)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 't' in struct");
    }

    @Test
    public void testBoundExpressionFails() {
        Expression expr = Expressions.not((Expression)Expressions.equal((String)"x", (Object)7));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Binder.bind((Types.StructType)STRUCT, (Expression)Binder.bind((Types.StructType)STRUCT, (Expression)expr))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Found already bound predicate");
    }

    @Test
    public void testSingleReference() {
        Expression expr = Expressions.not((Expression)Expressions.equal((String)"x", (Object)7));
        TestHelpers.assertAllReferencesBound("Single reference", Binder.bind((Types.StructType)STRUCT, (Expression)expr, (boolean)true));
    }

    @Test
    public void testCaseInsensitiveReference() {
        Expression expr = Expressions.not((Expression)Expressions.equal((String)"X", (Object)7));
        TestHelpers.assertAllReferencesBound("Single reference", Binder.bind((Types.StructType)STRUCT, (Expression)expr, (boolean)false));
    }

    @Test
    public void testCaseSensitiveReference() {
        Expression expr = Expressions.not((Expression)Expressions.equal((String)"X", (Object)7));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Binder.bind((Types.StructType)STRUCT, (Expression)expr, (boolean)true)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'X' in struct");
    }

    @Test
    public void testMultipleReferences() {
        Expression expr = Expressions.or((Expression)Expressions.and((Expression)Expressions.equal((String)"x", (Object)7), (Expression)Expressions.lessThan((String)"y", (Object)100)), (Expression)Expressions.greaterThan((String)"z", (Object)-100));
        TestHelpers.assertAllReferencesBound("Multiple references", Binder.bind((Types.StructType)STRUCT, (Expression)expr));
    }

    @Test
    public void testAnd() {
        Expression expr = Expressions.and((Expression)Expressions.equal((String)"x", (Object)7), (Expression)Expressions.lessThan((String)"y", (Object)100));
        Expression boundExpr = Binder.bind((Types.StructType)STRUCT, (Expression)expr);
        TestHelpers.assertAllReferencesBound("And", boundExpr);
        And and = TestHelpers.assertAndUnwrap(boundExpr, And.class);
        BoundPredicate left = TestHelpers.assertAndUnwrap(and.left());
        Assert.assertEquals((String)"Should bind x correctly", (long)0L, (long)((BoundTerm)left.term()).ref().fieldId());
        BoundPredicate right = TestHelpers.assertAndUnwrap(and.right());
        Assert.assertEquals((String)"Should bind y correctly", (long)1L, (long)((BoundTerm)right.term()).ref().fieldId());
    }

    @Test
    public void testOr() {
        Expression expr = Expressions.or((Expression)Expressions.greaterThan((String)"z", (Object)-100), (Expression)Expressions.lessThan((String)"y", (Object)100));
        Expression boundExpr = Binder.bind((Types.StructType)STRUCT, (Expression)expr);
        TestHelpers.assertAllReferencesBound("Or", boundExpr);
        Or or = TestHelpers.assertAndUnwrap(boundExpr, Or.class);
        BoundPredicate left = TestHelpers.assertAndUnwrap(or.left());
        Assert.assertEquals((String)"Should bind z correctly", (long)2L, (long)((BoundTerm)left.term()).ref().fieldId());
        BoundPredicate right = TestHelpers.assertAndUnwrap(or.right());
        Assert.assertEquals((String)"Should bind y correctly", (long)1L, (long)((BoundTerm)right.term()).ref().fieldId());
    }

    @Test
    public void testNot() {
        Expression expr = Expressions.not((Expression)Expressions.equal((String)"x", (Object)7));
        Expression boundExpr = Binder.bind((Types.StructType)STRUCT, (Expression)expr);
        TestHelpers.assertAllReferencesBound("Not", boundExpr);
        Not not = TestHelpers.assertAndUnwrap(boundExpr, Not.class);
        BoundPredicate child = TestHelpers.assertAndUnwrap(not.child());
        Assert.assertEquals((String)"Should bind x correctly", (long)0L, (long)((BoundTerm)child.term()).ref().fieldId());
    }

    @Test
    public void testStartsWith() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"s", (Type)Types.StringType.get())});
        UnboundPredicate expr = Expressions.startsWith((String)"s", (String)"abc");
        Expression boundExpr = Binder.bind((Types.StructType)struct, (Expression)expr);
        TestHelpers.assertAllReferencesBound("StartsWith", boundExpr);
        BoundPredicate pred = TestHelpers.assertAndUnwrap(boundExpr, BoundPredicate.class);
        Assert.assertEquals((String)"Should be right operation", (Object)Expression.Operation.STARTS_WITH, (Object)pred.op());
        Assert.assertEquals((String)"Should bind s correctly", (long)0L, (long)((BoundTerm)pred.term()).ref().fieldId());
    }

    @Test
    public void testNotStartsWith() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)21, (String)"s", (Type)Types.StringType.get())});
        UnboundPredicate expr = Expressions.notStartsWith((String)"s", (String)"abc");
        Expression boundExpr = Binder.bind((Types.StructType)struct, (Expression)expr);
        TestHelpers.assertAllReferencesBound("NotStartsWith", boundExpr);
        BoundPredicate pred = TestHelpers.assertAndUnwrap(boundExpr, BoundPredicate.class);
        Assert.assertEquals((String)"Should be right operation", (Object)Expression.Operation.NOT_STARTS_WITH, (Object)pred.op());
        Assert.assertEquals((String)"Should bind term to correct field id", (long)21L, (long)((BoundTerm)pred.term()).ref().fieldId());
    }

    @Test
    public void testAlwaysTrue() {
        Assert.assertEquals((String)"Should not change alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)Binder.bind((Types.StructType)STRUCT, (Expression)Expressions.alwaysTrue()));
    }

    @Test
    public void testAlwaysFalse() {
        Assert.assertEquals((String)"Should not change alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)Binder.bind((Types.StructType)STRUCT, (Expression)Expressions.alwaysFalse()));
    }

    @Test
    public void testBasicSimplification() {
        Assert.assertEquals((String)"Should simplify or expression to alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)Binder.bind((Types.StructType)STRUCT, (Expression)Expressions.or((Expression)Expressions.lessThan((String)"y", (Object)100), (Expression)Expressions.greaterThan((String)"z", (Object)-9999999999L))));
        Assert.assertEquals((String)"Should simplify and expression to predicate", (Object)Expressions.alwaysFalse(), (Object)Binder.bind((Types.StructType)STRUCT, (Expression)Expressions.and((Expression)Expressions.lessThan((String)"y", (Object)100), (Expression)Expressions.lessThan((String)"z", (Object)-9999999999L))));
        Expression bound = Binder.bind((Types.StructType)STRUCT, (Expression)Expressions.not((Expression)Expressions.not((Expression)Expressions.lessThan((String)"y", (Object)100))));
        BoundPredicate pred = TestHelpers.assertAndUnwrap(bound);
        Assert.assertEquals((String)"Should have the correct bound field", (long)1L, (long)((BoundTerm)pred.term()).ref().fieldId());
    }

    @Test
    public void testTransformExpressionBinding() {
        Expression bound = Binder.bind((Types.StructType)STRUCT, (Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"x", (int)16), (Object)10));
        TestHelpers.assertAllReferencesBound("BoundTransform", bound);
        BoundPredicate pred = TestHelpers.assertAndUnwrap(bound);
        ((ObjectAssert)Assertions.assertThat((Object)((BoundTerm)pred.term())).as("Should use a BoundTransform child", new Object[0])).isInstanceOf(BoundTransform.class);
        BoundTransform transformExpr = (BoundTransform)pred.term();
        Assert.assertEquals((String)"Should use a bucket[16] transform", (Object)"bucket[16]", (Object)transformExpr.transform().toString());
    }
}

