/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.concurrent.Callable;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.expressions.UnboundTransform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressionHelpers {
    private final UnboundPredicate<?> pred = Expressions.lessThan((String)"x", (Object)7);

    @Test
    public void testSimplifyOr() {
        Assert.assertEquals((String)"alwaysTrue or pred => alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)Expressions.or((Expression)Expressions.alwaysTrue(), this.pred));
        Assert.assertEquals((String)"pred or alwaysTrue => alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)Expressions.or(this.pred, (Expression)Expressions.alwaysTrue()));
        Assert.assertEquals((String)"alwaysFalse or pred => pred", this.pred, (Object)Expressions.or((Expression)Expressions.alwaysFalse(), this.pred));
        Assert.assertEquals((String)"pred or alwaysTrue => pred", this.pred, (Object)Expressions.or(this.pred, (Expression)Expressions.alwaysFalse()));
    }

    @Test
    public void testSimplifyAnd() {
        Assert.assertEquals((String)"alwaysTrue and pred => pred", this.pred, (Object)Expressions.and((Expression)Expressions.alwaysTrue(), this.pred));
        Assert.assertEquals((String)"pred and alwaysTrue => pred", this.pred, (Object)Expressions.and(this.pred, (Expression)Expressions.alwaysTrue()));
        Assert.assertEquals((String)"alwaysFalse and pred => alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)Expressions.and((Expression)Expressions.alwaysFalse(), this.pred));
        Assert.assertEquals((String)"pred and alwaysFalse => alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)Expressions.and(this.pred, (Expression)Expressions.alwaysFalse()));
    }

    @Test
    public void testSimplifyNot() {
        Assert.assertEquals((String)"not(alwaysTrue) => alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)Expressions.not((Expression)Expressions.alwaysTrue()));
        Assert.assertEquals((String)"not(alwaysFalse) => alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)Expressions.not((Expression)Expressions.alwaysFalse()));
        Assert.assertEquals((String)"not(not(pred)) => pred", this.pred, (Object)Expressions.not((Expression)Expressions.not(this.pred)));
    }

    @Test
    public void testRewriteNot() {
        Expression[][] expressions;
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"s", (Type)Types.StringType.get())});
        for (Expression[] pair : expressions = new Expression[][]{{Expressions.isNull((String)"a"), Expressions.isNull((String)"a")}, {Expressions.notNull((String)"a"), Expressions.not((Expression)Expressions.isNull((String)"a"))}, {Expressions.notNull((String)"a"), Expressions.notNull((String)"a")}, {Expressions.isNull((String)"a"), Expressions.not((Expression)Expressions.notNull((String)"a"))}, {Expressions.equal((String)"a", (Object)5), Expressions.equal((String)"a", (Object)5)}, {Expressions.notEqual((String)"a", (Object)5), Expressions.not((Expression)Expressions.equal((String)"a", (Object)5))}, {Expressions.notEqual((String)"a", (Object)5), Expressions.notEqual((String)"a", (Object)5)}, {Expressions.equal((String)"a", (Object)5), Expressions.not((Expression)Expressions.notEqual((String)"a", (Object)5))}, {Expressions.in((String)"a", (Object[])new Integer[]{5, 6}), Expressions.in((String)"a", (Object[])new Integer[]{5, 6})}, {Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6}), Expressions.not((Expression)Expressions.in((String)"a", (Object[])new Integer[]{5, 6}))}, {Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6}), Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6})}, {Expressions.in((String)"a", (Object[])new Integer[]{5, 6}), Expressions.not((Expression)Expressions.notIn((String)"a", (Object[])new Integer[]{5, 6}))}, {Expressions.lessThan((String)"a", (Object)5), Expressions.lessThan((String)"a", (Object)5)}, {Expressions.greaterThanOrEqual((String)"a", (Object)5), Expressions.not((Expression)Expressions.lessThan((String)"a", (Object)5))}, {Expressions.greaterThanOrEqual((String)"a", (Object)5), Expressions.greaterThanOrEqual((String)"a", (Object)5)}, {Expressions.lessThan((String)"a", (Object)5), Expressions.not((Expression)Expressions.greaterThanOrEqual((String)"a", (Object)5))}, {Expressions.lessThanOrEqual((String)"a", (Object)5), Expressions.lessThanOrEqual((String)"a", (Object)5)}, {Expressions.greaterThan((String)"a", (Object)5), Expressions.not((Expression)Expressions.lessThanOrEqual((String)"a", (Object)5))}, {Expressions.greaterThan((String)"a", (Object)5), Expressions.greaterThan((String)"a", (Object)5)}, {Expressions.lessThanOrEqual((String)"a", (Object)5), Expressions.not((Expression)Expressions.greaterThan((String)"a", (Object)5))}, {Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a")), Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a"))}, {Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")), Expressions.not((Expression)Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a")))}, {Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")), Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a"))}, {Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.isNull((String)"a")), Expressions.not((Expression)Expressions.and((Expression)Expressions.notEqual((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")))}, {Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.notNull((String)"a")), Expressions.or((Expression)Expressions.equal((String)"a", (Object)5), (Expression)Expressions.not((Expression)Expressions.isNull((String)"a")))}, {Expressions.startsWith((String)"s", (String)"hello"), Expressions.not((Expression)Expressions.notStartsWith((String)"s", (String)"hello"))}, {Expressions.notStartsWith((String)"s", (String)"world"), Expressions.not((Expression)Expressions.startsWith((String)"s", (String)"world"))}}) {
            Assert.assertEquals((String)String.format("rewriteNot(%s) should be %s", pair[1], pair[0]), (Object)pair[0].toString(), (Object)Expressions.rewriteNot((Expression)pair[1]).toString());
            Expression expectedBound = Binder.bind((Types.StructType)struct, (Expression)pair[0]);
            Expression toRewriteBound = Binder.bind((Types.StructType)struct, (Expression)pair[1]);
            Assert.assertEquals((String)String.format("rewriteNot(%s) should be %s", toRewriteBound, expectedBound), (Object)expectedBound.toString(), (Object)Expressions.rewriteNot((Expression)toRewriteBound).toString());
        }
    }

    @Test
    public void testTransformExpressions() {
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"year(ref(name=\"ts\")) == \"2019\"", (Object)Expressions.equal((UnboundTerm)Expressions.year((String)"ts"), (Object)"2019").toString());
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"month(ref(name=\"ts\")) == 1234", (Object)Expressions.equal((UnboundTerm)Expressions.month((String)"ts"), (Object)1234).toString());
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"day(ref(name=\"ts\")) == \"2019-12-04\"", (Object)Expressions.equal((UnboundTerm)Expressions.day((String)"ts"), (Object)"2019-12-04").toString());
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"hour(ref(name=\"ts\")) == \"2019-12-04-10\"", (Object)Expressions.equal((UnboundTerm)Expressions.hour((String)"ts"), (Object)"2019-12-04-10").toString());
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"truncate[6](ref(name=\"str\")) == \"abcdef\"", (Object)Expressions.equal((UnboundTerm)Expressions.truncate((String)"str", (int)6), (Object)"abcdef").toString());
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"truncate[5](ref(name=\"i\")) == 10", (Object)Expressions.equal((UnboundTerm)Expressions.truncate((String)"i", (int)5), (Object)10).toString());
        Assert.assertEquals((String)"Should produce the correct expression string", (Object)"bucket[16](ref(name=\"id\")) == 12", (Object)Expressions.equal((UnboundTerm)Expressions.bucket((String)"id", (int)16), (Object)12).toString());
    }

    @Test
    public void testNullName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.equal((String)null, (Object)5)).isInstanceOf(NullPointerException.class)).hasMessage("Name cannot be null");
    }

    @Test
    public void testNullValueExpr() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Expressions.equal((UnboundTerm)null, (Object)5)).isInstanceOf(NullPointerException.class)).hasMessage("Term cannot be null");
    }

    @Test
    public void testMultiAnd() {
        Expression expected = Expressions.and((Expression)Expressions.and((Expression)Expressions.equal((String)"a", (Object)1), (Expression)Expressions.equal((String)"b", (Object)2)), (Expression)Expressions.equal((String)"c", (Object)3));
        Expression actual = Expressions.and((Expression)Expressions.equal((String)"a", (Object)1), (Expression)Expressions.equal((String)"b", (Object)2), (Expression[])new Expression[]{Expressions.equal((String)"c", (Object)3)});
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public void testInvalidateNaNInput() {
        this.assertInvalidateNaNThrows(() -> Expressions.lessThan((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.lessThan(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.lessThanOrEqual((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.lessThanOrEqual(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThan((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThan(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThanOrEqual((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.greaterThanOrEqual(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.equal((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.equal(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.notEqual((String)"a", (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.notEqual(this.self("a"), (Object)Double.NaN));
        this.assertInvalidateNaNThrows(() -> Expressions.in((String)"a", (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.in(this.self("a"), (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.notIn((String)"a", (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.notIn(this.self("a"), (Object[])new Double[]{1.0, 2.0, Double.NaN}));
        this.assertInvalidateNaNThrows(() -> Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"a", (Object)Double.NaN));
    }

    private void assertInvalidateNaNThrows(Callable<UnboundPredicate<Double>> callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(callable::call).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create expression literal from NaN");
    }

    private <T> UnboundTerm<T> self(String name) {
        return new UnboundTransform(Expressions.ref((String)name), Transforms.identity());
    }
}

