/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.expressions.UnboundTransform;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestExpressionUtil {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"val", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"val2", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)5, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)6, (String)"time", (Type)Types.DateType.get()), Types.NestedField.optional((int)7, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"measurement", (Type)Types.DoubleType.get())});
    private static final Types.StructType STRUCT = SCHEMA.asStruct();

    @Test
    public void testUnchangedUnaryPredicates() {
        for (Expression unary : Lists.newArrayList((Object[])new UnboundPredicate[]{Expressions.isNull((String)"test"), Expressions.notNull((String)"test"), Expressions.isNaN((String)"test"), Expressions.notNaN((String)"test")})) {
            this.assertEquals(unary, ExpressionUtil.sanitize((Expression)unary));
        }
    }

    @Test
    public void testSanitizeIn() {
        this.assertEquals((Expression)Expressions.in((String)"test", (Object[])new String[]{"(2-digit-int)", "(3-digit-int)"}), ExpressionUtil.sanitize((Expression)Expressions.in((String)"test", (Object[])new Integer[]{34, 345})));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test IN ((2-digit-int), (3-digit-int))", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.in((String)"test", (Object[])new Integer[]{34, 345})));
    }

    @Test
    public void testSanitizeLongIn() {
        Object[] tooLongRange = IntStream.range(95, 105).boxed().toArray();
        Object[] almostTooLongRange = Arrays.copyOf(tooLongRange, tooLongRange.length - 1);
        Assert.assertEquals((String)"Sanitized string should be abbreviated", (Object)"test IN ((2-digit-int), (2-digit-int), (2-digit-int), (2-digit-int), (2-digit-int), (3-digit-int), (3-digit-int), (3-digit-int), (3-digit-int))", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.in((String)"test", (Object[])almostTooLongRange)));
        Assert.assertEquals((String)"Sanitized string should be abbreviated", (Object)"test IN ((2-digit-int), (3-digit-int), ... (8 values hidden, 10 in total))", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.in((String)"test", (Object[])tooLongRange)));
        ArrayList expectedValues = Lists.newArrayList();
        expectedValues.addAll(Collections.nCopies(5, "(2-digit-int)"));
        expectedValues.addAll(Collections.nCopies(5, "(3-digit-int)"));
        this.assertEquals((Expression)Expressions.in((String)"test", (Iterable)expectedValues), ExpressionUtil.sanitize((Expression)Expressions.in((String)"test", (Object[])tooLongRange)));
    }

    @Test
    public void zeroAndNegativeNumberHandling() {
        Assertions.assertThat((String)ExpressionUtil.toSanitizedString((Expression)Expressions.in((String)"test", (Object[])new Number[]{0, -1, -100, Integer.MIN_VALUE, Integer.MAX_VALUE, -1.2345678912344E12, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE}))).isEqualTo("test IN ((1-digit-int), (1-digit-int), (3-digit-int), (10-digit-int), (10-digit-int), (13-digit-float), (39-digit-float), (309-digit-float))");
    }

    @Test
    public void testSanitizeNotIn() {
        this.assertEquals((Expression)Expressions.notIn((String)"test", (Object[])new String[]{"(2-digit-int)", "(3-digit-int)"}), ExpressionUtil.sanitize((Expression)Expressions.notIn((String)"test", (Object[])new Integer[]{34, 345})));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test NOT IN ((2-digit-int), (3-digit-int))", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.notIn((String)"test", (Object[])new Integer[]{34, 345})));
    }

    @Test
    public void testSanitizeLongNotIn() {
        Object[] tooLongRange = IntStream.range(95, 105).boxed().toArray();
        Object[] almostTooLongRange = Arrays.copyOf(tooLongRange, tooLongRange.length - 1);
        Assert.assertEquals((String)"Sanitized string should be abbreviated", (Object)"test NOT IN ((2-digit-int), (2-digit-int), (2-digit-int), (2-digit-int), (2-digit-int), (3-digit-int), (3-digit-int), (3-digit-int), (3-digit-int))", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.notIn((String)"test", (Object[])almostTooLongRange)));
        Assert.assertEquals((String)"Sanitized string should be abbreviated", (Object)"test NOT IN ((2-digit-int), (3-digit-int), ... (8 values hidden, 10 in total))", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.notIn((String)"test", (Object[])tooLongRange)));
        ArrayList expectedValues = Lists.newArrayList();
        expectedValues.addAll(Collections.nCopies(5, "(2-digit-int)"));
        expectedValues.addAll(Collections.nCopies(5, "(3-digit-int)"));
        this.assertEquals((Expression)Expressions.notIn((String)"test", (Iterable)expectedValues), ExpressionUtil.sanitize((Expression)Expressions.notIn((String)"test", (Object[])tooLongRange)));
    }

    @Test
    public void testSanitizeLessThan() {
        this.assertEquals((Expression)Expressions.lessThan((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.lessThan((String)"test", (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test < (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.lessThan((String)"test", (Object)34)));
    }

    @Test
    public void testSanitizeLessThanOrEqual() {
        this.assertEquals((Expression)Expressions.lessThanOrEqual((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.lessThanOrEqual((String)"test", (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test <= (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.lessThanOrEqual((String)"test", (Object)34)));
    }

    @Test
    public void testSanitizeGreaterThan() {
        this.assertEquals((Expression)Expressions.greaterThan((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.greaterThan((String)"test", (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test > (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.greaterThan((String)"test", (Object)34)));
    }

    @Test
    public void testSanitizeGreaterThanOrEqual() {
        this.assertEquals((Expression)Expressions.greaterThanOrEqual((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.greaterThanOrEqual((String)"test", (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test >= (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.greaterThanOrEqual((String)"test", (Object)34)));
    }

    @Test
    public void testSanitizeEqual() {
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)34)));
    }

    @Test
    public void testSanitizeNotEqual() {
        this.assertEquals((Expression)Expressions.notEqual((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.notEqual((String)"test", (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test != (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.notEqual((String)"test", (Object)34)));
    }

    @Test
    public void testSanitizeStartsWith() {
        this.assertEquals((Expression)Expressions.startsWith((String)"test", (String)"(hash-34d05fb7)"), ExpressionUtil.sanitize((Expression)Expressions.startsWith((String)"test", (String)"aaa")));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test STARTS WITH (hash-34d05fb7)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.startsWith((String)"test", (String)"aaa")));
    }

    @Test
    public void testSanitizeNotStartsWith() {
        this.assertEquals((Expression)Expressions.notStartsWith((String)"test", (String)"(hash-34d05fb7)"), ExpressionUtil.sanitize((Expression)Expressions.notStartsWith((String)"test", (String)"aaa")));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test NOT STARTS WITH (hash-34d05fb7)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.notStartsWith((String)"test", (String)"aaa")));
    }

    @Test
    public void testSanitizeTransformedTerm() {
        this.assertEquals((Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"test", (int)2), (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"test", (int)2), (Object)34)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"truncate[2](test) = (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"test", (int)2), (Object)34)));
    }

    @Test
    public void testSanitizeLong() {
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(2-digit-int)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)34L)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (2-digit-int)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)34L)));
    }

    @Test
    public void testSanitizeFloat() {
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(2-digit-float)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)Float.valueOf(34.12f))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (2-digit-float)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)Float.valueOf(34.12f))));
    }

    @Test
    public void testSanitizeDouble() {
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(2-digit-float)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)34.12)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (2-digit-float)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)34.12)));
    }

    @Test
    public void testSanitizeDate() {
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)"2022-04-29")));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (date)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)"2022-04-29")));
    }

    @Test
    public void testSanitizeTime() {
        long micros = DateTimeUtil.microsFromTimestamptz((OffsetDateTime)OffsetDateTime.now()) / 1000000L;
        String currentTime = DateTimeUtil.microsToIsoTime((long)micros);
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(time)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)currentTime)));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (time)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)currentTime)));
    }

    @Test
    public void testSanitizeTimestamp() {
        for (String timestamp : Lists.newArrayList((Object[])new String[]{"2022-04-29T23:49:51", "2022-04-29T23:49:51.123456", "2022-04-29T23:49:51-07:00", "2022-04-29T23:49:51.123456+01:00"})) {
            this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)timestamp)));
            Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)timestamp)));
        }
    }

    @Test
    public void testSanitizeTimestampAboutNow() {
        String nowLocal = OffsetDateTime.now().atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime().toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-about-now)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)nowLocal)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-about-now)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)nowLocal).to((Type)Types.TimestampType.withoutZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-about-now)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)nowLocal)));
    }

    @Test
    public void testSanitizeTimestampPast() {
        String ninetyMinutesAgoLocal = OffsetDateTime.now().minusMinutes(90L).atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime().toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-ago)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesAgoLocal)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-ago)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)ninetyMinutesAgoLocal).to((Type)Types.TimestampType.withoutZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-1-hours-ago)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesAgoLocal)));
    }

    @Test
    public void testSanitizeTimestampLastWeek() {
        String lastWeekLocal = OffsetDateTime.now().minusHours(180L).atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime().toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-7-days-ago)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)lastWeekLocal)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-7-days-ago)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)lastWeekLocal).to((Type)Types.TimestampType.withoutZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-7-days-ago)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)lastWeekLocal)));
    }

    @Test
    public void testSanitizeTimestampFuture() {
        String ninetyMinutesFromNowLocal = OffsetDateTime.now().plusMinutes(90L).atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime().toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-from-now)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesFromNowLocal)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-from-now)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)ninetyMinutesFromNowLocal).to((Type)Types.TimestampType.withoutZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-1-hours-from-now)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesFromNowLocal)));
    }

    @Test
    public void testSanitizeTimestamptzAboutNow() {
        String nowUtc = OffsetDateTime.now().toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-about-now)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)nowUtc)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-about-now)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)nowUtc).to((Type)Types.TimestampType.withZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-about-now)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)nowUtc)));
    }

    @Test
    public void testSanitizeTimestamptzPast() {
        String ninetyMinutesAgoUtc = OffsetDateTime.now().minusMinutes(90L).toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-ago)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesAgoUtc)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-ago)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)ninetyMinutesAgoUtc).to((Type)Types.TimestampType.withZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-1-hours-ago)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesAgoUtc)));
    }

    @Test
    public void testSanitizeTimestamptzLastWeek() {
        String lastWeekUtc = OffsetDateTime.now().minusHours(180L).toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-7-days-ago)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)lastWeekUtc)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-7-days-ago)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)lastWeekUtc).to((Type)Types.TimestampType.withZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-7-days-ago)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)lastWeekUtc)));
    }

    @Test
    public void testSanitizeTimestamptzFuture() {
        String ninetyMinutesFromNowUtc = OffsetDateTime.now().plusMinutes(90L).toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-from-now)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesFromNowUtc)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(timestamp-1-hours-from-now)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)ninetyMinutesFromNowUtc).to((Type)Types.TimestampType.withZone()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (timestamp-1-hours-from-now)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)ninetyMinutesFromNowUtc)));
    }

    @Test
    public void testSanitizeDateToday() {
        String today = LocalDate.now(ZoneOffset.UTC).toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date-today)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)today)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date-today)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)today).to((Type)Types.DateType.get()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (date-today)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)today)));
    }

    @Test
    public void testSanitizeDateLastWeek() {
        String lastWeek = LocalDate.now(ZoneOffset.UTC).minusWeeks(1L).toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date-7-days-ago)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)lastWeek)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date-7-days-ago)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)lastWeek).to((Type)Types.DateType.get()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (date-7-days-ago)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)lastWeek)));
    }

    @Test
    public void testSanitizeDateNextWeek() {
        String nextWeek = LocalDate.now(ZoneOffset.UTC).plusWeeks(1L).toString();
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date-7-days-from-now)"), ExpressionUtil.sanitize((Expression)Expressions.equal((String)"test", (Object)nextWeek)));
        this.assertEquals((Expression)Expressions.equal((String)"test", (Object)"(date-7-days-from-now)"), ExpressionUtil.sanitize((Expression)Expressions.predicate((Expression.Operation)Expression.Operation.EQ, (String)"test", (Literal)Literal.of((CharSequence)nextWeek).to((Type)Types.DateType.get()))));
        Assert.assertEquals((String)"Sanitized string should be identical except for descriptive literal", (Object)"test = (date-7-days-from-now)", (Object)ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)nextWeek)));
    }

    @Test
    public void testSanitizeStringFallback() {
        Pattern filterPattern = Pattern.compile("^test = \\(hash-[0-9a-fA-F]{8}\\)$");
        for (String filter : Lists.newArrayList((Object[])new String[]{"2022-20-29", "2022-04-29T40:49:51.123456", "2022-04-29T23:70:51-07:00", "2022-04-29T23:49:51.123456+100:00"})) {
            String sanitizedFilter = ExpressionUtil.toSanitizedString((Expression)Expressions.equal((String)"test", (Object)filter));
            Assertions.assertThat((Matcher)filterPattern.matcher(sanitizedFilter)).matches();
        }
    }

    @Test
    public void testIdenticalExpressionIsEquivalent() {
        Expression[] exprs;
        for (Expression expr : exprs = new Expression[]{Expressions.isNull((String)"data"), Expressions.notNull((String)"data"), Expressions.isNaN((String)"measurement"), Expressions.notNaN((String)"measurement"), Expressions.lessThan((String)"id", (Object)5), Expressions.lessThanOrEqual((String)"id", (Object)5), Expressions.greaterThan((String)"id", (Object)5), Expressions.greaterThanOrEqual((String)"id", (Object)5), Expressions.equal((String)"id", (Object)5), Expressions.notEqual((String)"id", (Object)5), Expressions.in((String)"id", (Object[])new Integer[]{5, 6}), Expressions.notIn((String)"id", (Object[])new Integer[]{5, 6}), Expressions.startsWith((String)"data", (String)"aaa"), Expressions.notStartsWith((String)"data", (String)"aaa"), Expressions.alwaysTrue(), Expressions.alwaysFalse(), Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.notNull((String)"data")), Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.notNull((String)"data"))}) {
            Assert.assertTrue((String)("Should accept identical expression: " + expr), (boolean)ExpressionUtil.equivalent((Expression)expr, (Expression)expr, (Types.StructType)STRUCT, (boolean)true));
            for (Expression other : exprs) {
                if (expr == other) continue;
                Assert.assertFalse((boolean)ExpressionUtil.equivalent((Expression)expr, (Expression)other, (Types.StructType)STRUCT, (boolean)true));
            }
        }
    }

    @Test
    public void testIdenticalTermIsEquivalent() {
        UnboundTerm[] terms;
        for (UnboundTerm term : terms = new UnboundTerm[]{Expressions.ref((String)"id"), Expressions.truncate((String)"id", (int)2), Expressions.bucket((String)"id", (int)16), Expressions.year((String)"ts"), Expressions.month((String)"ts"), Expressions.day((String)"ts"), Expressions.hour((String)"ts")}) {
            BoundTerm bound = (BoundTerm)term.bind(STRUCT, true);
            Assert.assertTrue((String)("Should accept identical expression: " + term), (boolean)bound.isEquivalentTo(bound));
            for (UnboundTerm other : terms) {
                if (term == other) continue;
                Assert.assertFalse((boolean)bound.isEquivalentTo((BoundTerm)other.bind(STRUCT, true)));
            }
        }
    }

    @Test
    public void testRefEquivalence() {
        Assert.assertFalse((String)"Should not find different refs equivalent", (boolean)Expressions.ref((String)"val").bind(STRUCT, true).isEquivalentTo((BoundTerm)Expressions.ref((String)"val2").bind(STRUCT, true)));
    }

    @Test
    public void testInEquivalence() {
        Assert.assertTrue((String)"Should ignore duplicate longs (in)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.in((String)"id", (Object[])new Integer[]{1, 2, 1}), (Expression)Expressions.in((String)"id", (Object[])new Integer[]{2, 1, 2}), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertTrue((String)"Should ignore duplicate longs (notIn)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{1, 2, 1}), (Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{2, 1, 2}), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertTrue((String)"Should ignore duplicate strings (in)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.in((String)"data", (Object[])new String[]{"a", "b", "a"}), (Expression)Expressions.in((String)"data", (Object[])new String[]{"b", "a"}), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertTrue((String)"Should ignore duplicate strings (notIn)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.notIn((String)"data", (Object[])new String[]{"b", "b"}), (Expression)Expressions.notIn((String)"data", (Object[])new String[]{"b"}), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertTrue((String)"Should detect equivalence with equal (in, string)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.in((String)"data", (Object[])new String[]{"a"}), (Expression)Expressions.equal((String)"data", (Object)"a"), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertTrue((String)"Should detect equivalence with notEqual (notIn, long)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{1}), (Expression)Expressions.notEqual((String)"id", (Object)1), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertFalse((String)"Should detect different sets (in, long)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.in((String)"id", (Object[])new Integer[]{1, 2, 3}), (Expression)Expressions.in((String)"id", (Object[])new Integer[]{1, 2}), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertFalse((String)"Should detect different sets (notIn, string)", (boolean)ExpressionUtil.equivalent((Expression)Expressions.notIn((String)"data", (Object[])new String[]{"a", "b"}), (Expression)Expressions.notIn((String)"data", (Object[])new String[]{"a"}), (Types.StructType)STRUCT, (boolean)true));
    }

    @Test
    public void testInequalityEquivalence() {
        String[] cols;
        for (String col : cols = new String[]{"id", "val", "ts", "date", "time"}) {
            Assert.assertTrue((String)("Should detect < to <= equivalence: " + col), (boolean)ExpressionUtil.equivalent((Expression)Expressions.lessThan((String)col, (Object)34L), (Expression)Expressions.lessThanOrEqual((String)col, (Object)33L), (Types.StructType)STRUCT, (boolean)true));
            Assert.assertTrue((String)("Should detect <= to < equivalence: " + col), (boolean)ExpressionUtil.equivalent((Expression)Expressions.lessThanOrEqual((String)col, (Object)34L), (Expression)Expressions.lessThan((String)col, (Object)35L), (Types.StructType)STRUCT, (boolean)true));
            Assert.assertTrue((String)("Should detect > to >= equivalence: " + col), (boolean)ExpressionUtil.equivalent((Expression)Expressions.greaterThan((String)col, (Object)34L), (Expression)Expressions.greaterThanOrEqual((String)col, (Object)35L), (Types.StructType)STRUCT, (boolean)true));
            Assert.assertTrue((String)("Should detect >= to > equivalence: " + col), (boolean)ExpressionUtil.equivalent((Expression)Expressions.greaterThanOrEqual((String)col, (Object)34L), (Expression)Expressions.greaterThan((String)col, (Object)33L), (Types.StructType)STRUCT, (boolean)true));
        }
        Assert.assertFalse((String)"Should not detect equivalence for different columns", (boolean)ExpressionUtil.equivalent((Expression)Expressions.lessThan((String)"val", (Object)34L), (Expression)Expressions.lessThanOrEqual((String)"val2", (Object)33L), (Types.StructType)STRUCT, (boolean)true));
        Assert.assertFalse((String)"Should not detect equivalence for different types", (boolean)ExpressionUtil.equivalent((Expression)Expressions.lessThan((String)"val", (Object)34L), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)33L), (Types.StructType)STRUCT, (boolean)true));
    }

    @Test
    public void testAndEquivalence() {
        Assert.assertTrue((String)"Should detect and equivalence in any order", (boolean)ExpressionUtil.equivalent((Expression)Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)34), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)20)), (Expression)Expressions.and((Expression)Expressions.greaterThan((String)"id", (Object)19L), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)33L)), (Types.StructType)STRUCT, (boolean)true));
    }

    @Test
    public void testOrEquivalence() {
        Assert.assertTrue((String)"Should detect or equivalence in any order", (boolean)ExpressionUtil.equivalent((Expression)Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)20), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)34)), (Expression)Expressions.or((Expression)Expressions.greaterThan((String)"id", (Object)33L), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)19L)), (Types.StructType)STRUCT, (boolean)true));
    }

    @Test
    public void testNotEquivalence() {
        Assert.assertTrue((String)"Should detect not equivalence by rewriting", (boolean)ExpressionUtil.equivalent((Expression)Expressions.not((Expression)Expressions.or((Expression)Expressions.in((String)"data", (Object[])new String[]{"a"}), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)34))), (Expression)Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)34L), (Expression)Expressions.notEqual((String)"data", (Object)"a")), (Types.StructType)STRUCT, (boolean)true));
    }

    @Test
    public void testSelectsPartitions() {
        Assert.assertTrue((String)"Should select partitions, on boundary", (boolean)ExpressionUtil.selectsPartitions((Expression)Expressions.lessThan((String)"ts", (Object)"2021-03-09T10:00:00.000000"), (PartitionSpec)PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").build(), (boolean)true));
        Assert.assertFalse((String)"Should not select partitions, 1 ms off boundary", (boolean)ExpressionUtil.selectsPartitions((Expression)Expressions.lessThanOrEqual((String)"ts", (Object)"2021-03-09T10:00:00.000000"), (PartitionSpec)PartitionSpec.builderFor((Schema)SCHEMA).hour("ts").build(), (boolean)true));
        Assert.assertFalse((String)"Should not select partitions, on hour not day boundary", (boolean)ExpressionUtil.selectsPartitions((Expression)Expressions.lessThan((String)"ts", (Object)"2021-03-09T10:00:00.000000"), (PartitionSpec)PartitionSpec.builderFor((Schema)SCHEMA).day("ts").build(), (boolean)true));
    }

    private void assertEquals(Expression expected, Expression actual) {
        Assertions.assertThat((Object)expected).isInstanceOf(UnboundPredicate.class);
        this.assertEquals((UnboundPredicate)expected, (UnboundPredicate)actual);
    }

    private void assertEquals(UnboundPredicate<?> expected, UnboundPredicate<?> actual) {
        Assert.assertEquals((String)"Operation should match", (Object)expected.op(), (Object)actual.op());
        this.assertEquals((UnboundTerm)expected.term(), (UnboundTerm)actual.term());
        Assert.assertEquals((String)"Literals should match", (Object)expected.literals(), (Object)actual.literals());
    }

    private void assertEquals(UnboundTerm<?> expected, UnboundTerm<?> actual) {
        ((ObjectAssert)Assertions.assertThat(expected).as("Unknown expected term: " + expected, new Object[0])).isOfAnyClassIn(new Class[]{NamedReference.class, UnboundTransform.class});
        if (expected instanceof NamedReference) {
            Assert.assertTrue((String)"Should be a NamedReference", (boolean)(actual instanceof NamedReference));
            this.assertEquals((NamedReference)expected, (NamedReference)actual);
        } else if (expected instanceof UnboundTransform) {
            Assert.assertTrue((String)"Should be an UnboundTransform", (boolean)(actual instanceof UnboundTransform));
            this.assertEquals((UnboundTransform)expected, (UnboundTransform)actual);
        }
    }

    private void assertEquals(NamedReference<?> expected, NamedReference<?> actual) {
        Assert.assertEquals((String)"Should reference the same field name", (Object)expected.name(), (Object)actual.name());
    }

    private void assertEquals(UnboundTransform<?, ?> expected, UnboundTransform<?, ?> actual) {
        Assert.assertEquals((String)"Should apply the same transform", (Object)expected.transform().toString(), (Object)actual.transform().toString());
        this.assertEquals(expected.ref(), actual.ref());
    }
}

