/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestInclusiveManifestEvaluator {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)4, (String)"all_nulls_missing_nan", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)8, (String)"all_nulls_double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)9, (String)"all_nulls_no_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)10, (String)"all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)11, (String)"both_nan_and_null", (Type)Types.FloatType.get()), Types.NestedField.optional((int)12, (String)"no_nan_or_null", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)13, (String)"all_nulls_missing_nan_float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)14, (String)"all_same_value_or_null", (Type)Types.StringType.get()), Types.NestedField.optional((int)15, (String)"no_nulls_same_value_a", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).withSpecId(0).identity("id").identity("all_nulls_missing_nan").identity("some_nulls").identity("no_nulls").identity("float").identity("all_nulls_double").identity("all_nulls_no_nans").identity("all_nans").identity("both_nan_and_null").identity("no_nan_or_null").identity("all_nulls_missing_nan_float").identity("all_same_value_or_null").identity("no_nulls_same_value_a").build();
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 79;
    private static final ByteBuffer INT_MIN = Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)30);
    private static final ByteBuffer INT_MAX = Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)79);
    private static final ByteBuffer STRING_MIN = Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"a");
    private static final ByteBuffer STRING_MAX = Conversions.toByteBuffer((Type)Types.StringType.get(), (Object)"z");
    private static final ManifestFile NO_STATS = new TestHelpers.TestManifestFile("manifest-list.avro", 1024L, 0, System.currentTimeMillis(), null, null, null, null, null);
    private static final ManifestFile FILE = new TestHelpers.TestManifestFile("manifest-list.avro", 1024L, 0, System.currentTimeMillis(), 5, 10, 0, (List<ManifestFile.PartitionFieldSummary>)ImmutableList.of((Object)new TestHelpers.TestFieldSummary(false, INT_MIN, INT_MAX), (Object)new TestHelpers.TestFieldSummary(true, null, null), (Object)new TestHelpers.TestFieldSummary(true, STRING_MIN, STRING_MAX), (Object)new TestHelpers.TestFieldSummary(false, STRING_MIN, STRING_MAX), (Object)new TestHelpers.TestFieldSummary(false, Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(0.0f)), Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(20.0f))), (Object)new TestHelpers.TestFieldSummary(true, null, null), (Object)new TestHelpers.TestFieldSummary(true, false, null, null), (Object)new TestHelpers.TestFieldSummary(false, true, null, null), (Object)new TestHelpers.TestFieldSummary(true, true, null, null), (Object)new TestHelpers.TestFieldSummary(false, false, Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(0.0f)), Conversions.toByteBuffer((Type)Types.FloatType.get(), (Object)Float.valueOf(20.0f))), (Object)new TestHelpers.TestFieldSummary(true, null, null), (Object)new TestHelpers.TestFieldSummary(true, STRING_MIN, STRING_MIN), (Object[])new ManifestFile.PartitionFieldSummary[]{new TestHelpers.TestFieldSummary(false, STRING_MIN, STRING_MIN)}), null);

    @Test
    public void testAllNulls() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNull((String)"all_nulls_missing_nan"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: all nulls column with non-floating type contains all null", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNull((String)"all_nulls_missing_nan_float"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no NaN information may indicate presence of NaN value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNull((String)"some_nulls"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: column with some nulls contains a non-null value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNull((String)"no_nulls"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: non-null column contains a non-null value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"all_nulls_missing_nan", (String)"asad"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: startsWith on all null column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"all_nulls_missing_nan", (String)"asad"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: notStartsWith on all null column", (boolean)shouldRead);
    }

    @Test
    public void testNoNulls() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNull((String)"all_nulls_missing_nan"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: at least one null value in all null column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNull((String)"some_nulls"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: column with some nulls contains a null value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNull((String)"no_nulls"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: non-null column contains no null values", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNull((String)"both_nan_and_null"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: both_nan_and_null column contains no null values", (boolean)shouldRead);
    }

    @Test
    public void testIsNaN() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"float"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no information on if there are nan value in float column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"all_nulls_double"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no NaN information may indicate presence of NaN value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"all_nulls_missing_nan_float"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no NaN information may indicate presence of NaN value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"all_nulls_no_nans"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: no nan column doesn't contain nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"all_nans"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: all_nans column contains nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"both_nan_and_null"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: both_nan_and_null column contains nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.isNaN((String)"no_nan_or_null"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: no_nan_or_null column doesn't contain nan value", (boolean)shouldRead);
    }

    @Test
    public void testNotNaN() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNaN((String)"float"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no information on if there are nan value in float column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNaN((String)"all_nulls_double"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: all null column contains non nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNaN((String)"all_nulls_no_nans"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no_nans column contains non nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNaN((String)"all_nans"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: all nans column doesn't contain non nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNaN((String)"both_nan_and_null"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: both_nan_and_null nans column contains non nan value", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notNaN((String)"no_nan_or_null"), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: no_nan_or_null column contains non nan value", (boolean)shouldRead);
    }

    @Test
    public void testMissingColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ManifestEvaluator.forRowFilter((Expression)Expressions.lessThan((String)"missing", (Object)5), (PartitionSpec)SPEC, (boolean)true).eval(FILE)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing'");
    }

    @Test
    public void testMissingStats() {
        Expression[] exprs;
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"id", (Object)5), Expressions.lessThanOrEqual((String)"id", (Object)30), Expressions.equal((String)"id", (Object)70), Expressions.greaterThan((String)"id", (Object)78), Expressions.greaterThanOrEqual((String)"id", (Object)90), Expressions.notEqual((String)"id", (Object)101), Expressions.isNull((String)"id"), Expressions.notNull((String)"id"), Expressions.startsWith((String)"all_nulls_missing_nan", (String)"a"), Expressions.isNaN((String)"float"), Expressions.notNaN((String)"float"), Expressions.notStartsWith((String)"all_nulls_missing_nan", (String)"a")}) {
            boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)expr, (PartitionSpec)SPEC, (boolean)true).eval(NO_STATS);
            Assert.assertTrue((String)("Should read when missing stats for expr: " + expr), (boolean)shouldRead);
        }
    }

    @Test
    public void testNot() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.lessThan((String)"id", (Object)5)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: not(false)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.greaterThan((String)"id", (Object)5)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: not(true)", (boolean)shouldRead);
    }

    @Test
    public void testAnd() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)0)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: and(false, true)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: and(false, false)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.and((Expression)Expressions.greaterThan((String)"id", (Object)5), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: and(true, true)", (boolean)shouldRead);
    }

    @Test
    public void testOr() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: or(false, false)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)60)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: or(false, true)", (boolean)shouldRead);
    }

    @Test
    public void testIntegerLt() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThan((String)"id", (Object)5), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range below lower bound (5 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThan((String)"id", (Object)30), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range below lower bound (30 is not < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThan((String)"id", (Object)31), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: one possible id", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThan((String)"id", (Object)79), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: may possible ids", (boolean)shouldRead);
    }

    @Test
    public void testIntegerLtEq() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThanOrEqual((String)"id", (Object)5), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range below lower bound (5 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThanOrEqual((String)"id", (Object)29), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range below lower bound (29 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThanOrEqual((String)"id", (Object)30), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: one possible id", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.lessThanOrEqual((String)"id", (Object)79), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: many possible ids", (boolean)shouldRead);
    }

    @Test
    public void testIntegerGt() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThan((String)"id", (Object)85), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range above upper bound (85 < 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThan((String)"id", (Object)79), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range above upper bound (79 is not > 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThan((String)"id", (Object)78), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: one possible id", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThan((String)"id", (Object)75), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: may possible ids", (boolean)shouldRead);
    }

    @Test
    public void testIntegerGtEq() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)85), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range above upper bound (85 < 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id range above upper bound (80 > 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)79), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: one possible id", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)75), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: may possible ids", (boolean)shouldRead);
    }

    @Test
    public void testIntegerEq() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)5), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)29), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)30), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)75), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id between lower and upper bounds", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)79), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)80), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id above upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.equal((String)"id", (Object)85), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id above upper bound", (boolean)shouldRead);
    }

    @Test
    public void testIntegerNotEq() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)5), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)29), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)30), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)75), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id between lower and upper bounds", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)79), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)80), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notEqual((String)"id", (Object)85), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound", (boolean)shouldRead);
    }

    @Test
    public void testIntegerNotEqRewritten() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)5)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)29)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)30)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)75)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id between lower and upper bounds", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)79)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)80)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"id", (Object)85)), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound", (boolean)shouldRead);
    }

    @Test
    public void testCaseInsensitiveIntegerNotEqRewritten() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)5)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)29)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)30)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to lower bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)75)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id between lower and upper bounds", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)79)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)80)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)85)), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound", (boolean)shouldRead);
    }

    @Test
    public void testCaseSensitiveIntegerNotEqRewritten() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ManifestEvaluator.forRowFilter((Expression)Expressions.not((Expression)Expressions.equal((String)"ID", (Object)5)), (PartitionSpec)SPEC, (boolean)true).eval(FILE)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'ID'");
    }

    @Test
    public void testStringStartsWith() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"some_nulls", (String)"a"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"some_nulls", (String)"aa"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"some_nulls", (String)"dddd"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"some_nulls", (String)"z"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"no_nulls", (String)"a"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"some_nulls", (String)"zzzz"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertFalse((String)"Should skip: range doesn't match", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.startsWith((String)"some_nulls", (String)"1"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertFalse((String)"Should skip: range doesn't match", (boolean)shouldRead);
    }

    @Test
    public void testStringNotStartsWith() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"a"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"aa"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"dddd"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"z"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"no_nulls", (String)"a"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"zzzz"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"1"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"all_same_value_or_null", (String)"a"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches on null", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"all_same_value_or_null", (String)"aa"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"all_same_value_or_null", (String)"A"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"all_nulls_missing_nan", (String)"A"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertTrue((String)"Should read: range matches", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notStartsWith((String)"no_nulls_same_value_a", (String)"a"), (PartitionSpec)SPEC, (boolean)false).eval(FILE);
        Assert.assertFalse((String)"Should not read: all values start with the prefix", (boolean)shouldRead);
    }

    @Test
    public void testIntegerIn() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{5, 6}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id below lower bound (5 < 30, 6 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{28, 29}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id below lower bound (28 < 30, 29 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{29, 30}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to lower bound (30 == 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{75, 76}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id between lower and upper bounds (30 < 75 < 79, 30 < 76 < 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{79, 80}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to upper bound (79 == 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{80, 81}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id above upper bound (80 > 79, 81 > 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"id", (Object[])new Integer[]{85, 86}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should not read: id above upper bound (85 > 79, 86 > 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"all_nulls_missing_nan", (Object[])new String[]{"abc", "def"}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertFalse((String)"Should skip: in on all nulls column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"abc", "def"}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: in on some nulls column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"abc", "def"}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: in on no nulls column", (boolean)shouldRead);
    }

    @Test
    public void testIntegerNotIn() {
        boolean shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{5, 6}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound (5 < 30, 6 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{28, 29}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id below lower bound (28 < 30, 29 < 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{29, 30}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to lower bound (30 == 30)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{75, 76}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id between lower and upper bounds (30 < 75 < 79, 30 < 76 < 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{79, 80}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id equal to upper bound (79 == 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{80, 81}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound (80 > 79, 81 > 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{85, 86}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: id above upper bound (85 > 79, 86 > 79)", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"all_nulls_missing_nan", (Object[])new String[]{"abc", "def"}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: notIn on all nulls column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"some_nulls", (Object[])new String[]{"abc", "def"}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: notIn on some nulls column", (boolean)shouldRead);
        shouldRead = ManifestEvaluator.forRowFilter((Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"abc", "def"}), (PartitionSpec)SPEC, (boolean)true).eval(FILE);
        Assert.assertTrue((String)"Should read: notIn on no nulls column", (boolean)shouldRead);
    }
}

