/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestMiscLiteralConversions {
    @Test
    public void testIdentityConversions() {
        List<Pair> pairs = Arrays.asList(Pair.of(Literal.of((boolean)true), Types.BooleanType.get()), Pair.of(Literal.of((int)34), Types.IntegerType.get()), Pair.of(Literal.of((long)34L), Types.LongType.get()), Pair.of(Literal.of((float)34.11f), Types.FloatType.get()), Pair.of(Literal.of((double)34.55), Types.DoubleType.get()), Pair.of(Literal.of((CharSequence)"34.55"), Types.DecimalType.of((int)9, (int)2)), Pair.of(Literal.of((CharSequence)"2017-08-18"), Types.DateType.get()), Pair.of(Literal.of((CharSequence)"14:21:01.919"), Types.TimeType.get()), Pair.of(Literal.of((CharSequence)"2017-08-18T14:21:01.919"), Types.TimestampType.withoutZone()), Pair.of(Literal.of((CharSequence)"abc"), Types.StringType.get()), Pair.of(Literal.of((UUID)UUID.randomUUID()), Types.UUIDType.get()), Pair.of(Literal.of((byte[])new byte[]{0, 1, 2}), Types.FixedType.ofLength((int)3)), Pair.of(Literal.of((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 1, 2})), Types.BinaryType.get()));
        for (Pair pair : pairs) {
            Literal lit = (Literal)pair.first();
            Type type = (Type)pair.second();
            Literal expected = lit.to(type);
            Assert.assertSame((String)"Converting twice should produce identical values", (Object)expected, (Object)expected.to(type));
        }
    }

    @Test
    public void testBinaryToFixed() {
        Literal lit = Literal.of((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 1, 2}));
        Literal fixedLit = lit.to((Type)Types.FixedType.ofLength((int)3));
        Assert.assertNotNull((String)"Should allow conversion to correct fixed length", (Object)fixedLit);
        Assert.assertEquals((String)"Conversion should not change value", (Object)((ByteBuffer)lit.value()).duplicate(), (Object)((ByteBuffer)fixedLit.value()).duplicate());
        Assert.assertNull((String)"Should not allow conversion to different fixed length", (Object)lit.to((Type)Types.FixedType.ofLength((int)4)));
        Assert.assertNull((String)"Should not allow conversion to different fixed length", (Object)lit.to((Type)Types.FixedType.ofLength((int)2)));
    }

    @Test
    public void testFixedToBinary() {
        Literal lit = Literal.of((byte[])new byte[]{0, 1, 2});
        Literal binaryLit = lit.to((Type)Types.BinaryType.get());
        Assert.assertNotNull((String)"Should allow conversion to binary", (Object)binaryLit);
        Assert.assertEquals((String)"Conversion should not change value", (Object)((ByteBuffer)lit.value()).duplicate(), (Object)((ByteBuffer)binaryLit.value()).duplicate());
    }

    @Test
    public void testInvalidBooleanConversions() {
        this.testInvalidConversions(Literal.of((boolean)true), new Type[]{Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.DecimalType.of((int)9, (int)2), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidIntegerConversions() {
        this.testInvalidConversions(Literal.of((int)34), new Type[]{Types.BooleanType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidLongConversions() {
        this.testInvalidConversions(Literal.of((long)34L), new Type[]{Types.BooleanType.get(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidFloatConversions() {
        this.testInvalidConversions(Literal.of((float)34.11f), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidDoubleConversions() {
        this.testInvalidConversions(Literal.of((double)34.11), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidDateConversions() {
        this.testInvalidConversions(Literal.of((CharSequence)"2017-08-18").to((Type)Types.DateType.get()), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.DecimalType.of((int)9, (int)4), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidTimeConversions() {
        this.testInvalidConversions(Literal.of((CharSequence)"14:21:01.919").to((Type)Types.TimeType.get()), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.DecimalType.of((int)9, (int)4), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidTimestampConversions() {
        this.testInvalidConversions(Literal.of((CharSequence)"2017-08-18T14:21:01.919").to((Type)Types.TimestampType.withoutZone()), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.TimeType.get(), Types.DecimalType.of((int)9, (int)4), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidDecimalConversions() {
        this.testInvalidConversions(Literal.of((BigDecimal)new BigDecimal("34.11")), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidStringConversions() {
        this.testInvalidConversions(Literal.of((CharSequence)"abc"), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidUUIDConversions() {
        this.testInvalidConversions(Literal.of((UUID)UUID.randomUUID()), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.DecimalType.of((int)9, (int)2), Types.StringType.get(), Types.FixedType.ofLength((int)1), Types.BinaryType.get()});
    }

    @Test
    public void testInvalidFixedConversions() {
        this.testInvalidConversions(Literal.of((byte[])new byte[]{0, 1, 2}), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.DecimalType.of((int)9, (int)2), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1)});
    }

    @Test
    public void testInvalidBinaryConversions() {
        this.testInvalidConversions(Literal.of((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 1, 2})), new Type[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.DecimalType.of((int)9, (int)2), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.ofLength((int)1)});
    }

    private void testInvalidConversions(Literal<?> lit, Type ... invalidTypes) {
        for (Type type : invalidTypes) {
            Assert.assertNull((String)(lit.value().getClass().getName() + " literal to " + type + " is not allowed"), (Object)lit.to(type));
        }
    }

    private static class Pair<X, Y> {
        private final X first;
        private final Y second;

        public static <X, Y> Pair<X, Y> of(X first, Y second) {
            return new Pair<X, Y>(first, second);
        }

        private Pair(X first, Y second) {
            this.first = first;
            this.second = second;
        }

        public X first() {
            return this.first;
        }

        public Y second() {
            return this.second;
        }
    }
}

