/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.util.stream.IntStream;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Literals;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestNumericLiteralConversions {
    @Test
    public void testIntegerToLongConversion() {
        Literal lit = Literal.of((int)34);
        Literal longLit = lit.to((Type)Types.LongType.get());
        Assert.assertEquals((String)"Value should match", (long)34L, (long)((Long)longLit.value()));
    }

    @Test
    public void testIntegerToFloatConversion() {
        Literal lit = Literal.of((int)34);
        Literal floatLit = lit.to((Type)Types.FloatType.get());
        Assert.assertEquals((String)"Value should match", (double)34.0, (double)((Float)floatLit.value()).floatValue(), (double)1.0E-10);
    }

    @Test
    public void testIntegerToDoubleConversion() {
        Literal lit = Literal.of((int)34);
        Literal doubleLit = lit.to((Type)Types.DoubleType.get());
        Assert.assertEquals((String)"Value should match", (double)34.0, (double)((Double)doubleLit.value()), (double)1.0E-10);
    }

    @Test
    public void testIntegerToDecimalConversion() {
        Literal lit = Literal.of((int)34);
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)0)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.00"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.0000"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value());
    }

    @Test
    public void testLongToIntegerConversion() {
        Literal lit = Literal.of((long)34L);
        Literal intLit = lit.to((Type)Types.IntegerType.get());
        Assert.assertEquals((String)"Value should match", (long)34L, (long)((Integer)intLit.value()).intValue());
        Assert.assertEquals((String)"Values above Integer.MAX_VALUE should be Literals.aboveMax()", (Object)Literals.aboveMax(), (Object)Literal.of((long)0x80000000L).to((Type)Types.IntegerType.get()));
        Assert.assertEquals((String)"Values below Integer.MIN_VALUE should be Literals.belowMin()", (Object)Literals.belowMin(), (Object)Literal.of((long)-2147483649L).to((Type)Types.IntegerType.get()));
    }

    @Test
    public void testLongToFloatConversion() {
        Literal lit = Literal.of((long)34L);
        Literal floatLit = lit.to((Type)Types.FloatType.get());
        Assert.assertEquals((String)"Value should match", (double)34.0, (double)((Float)floatLit.value()).floatValue(), (double)1.0E-10);
    }

    @Test
    public void testLongToDoubleConversion() {
        Literal lit = Literal.of((long)34L);
        Literal doubleLit = lit.to((Type)Types.DoubleType.get());
        Assert.assertEquals((String)"Value should match", (double)34.0, (double)((Double)doubleLit.value()), (double)1.0E-10);
    }

    @Test
    public void testLongToDecimalConversion() {
        Literal lit = Literal.of((long)34L);
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)0)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.00"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.0000"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value());
    }

    @Test
    public void testFloatToDoubleConversion() {
        Literal lit = Literal.of((float)34.56f);
        Literal doubleLit = lit.to((Type)Types.DoubleType.get());
        Assert.assertEquals((String)"Value should match", (double)34.56, (double)((Double)doubleLit.value()), (double)0.001);
    }

    @Test
    public void testFloatToDecimalConversion() {
        Literal lit = Literal.of((float)34.56f);
        Assert.assertEquals((String)"Value should round using HALF_UP", (Object)new BigDecimal("34.6"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)1)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.56"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.5600"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value());
    }

    @Test
    public void testDoubleToFloatConversion() {
        Literal lit = Literal.of((double)34.56);
        Literal doubleLit = lit.to((Type)Types.FloatType.get());
        Assert.assertEquals((String)"Value should match", (double)34.56f, (double)((Float)doubleLit.value()).floatValue(), (double)0.001);
        Assert.assertEquals((String)"Values above Float.MAX_VALUE should be Literals.aboveMax()", (Object)Literals.aboveMax(), (Object)Literal.of((double)6.805646932770577E38).to((Type)Types.FloatType.get()));
        Assert.assertEquals((String)"Values below Float.MIN_VALUE should be Literals.belowMin()", (Object)Literals.belowMin(), (Object)Literal.of((double)-6.805646932770577E38).to((Type)Types.FloatType.get()));
    }

    @Test
    public void testDoubleToDecimalConversion() {
        Literal lit = Literal.of((double)34.56);
        Assert.assertEquals((String)"Value should round using HALF_UP", (Object)new BigDecimal("34.6"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)1)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.56"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)2)).value());
        Assert.assertEquals((String)"Value should match", (Object)new BigDecimal("34.5600"), (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)4)).value());
    }

    @Test
    public void testDecimalToDecimalConversion() {
        Literal lit = Literal.of((BigDecimal)new BigDecimal("34.11"));
        IntStream.range(0, 10).forEach(scale -> {
            Assert.assertSame((String)"Should return identical object", (Object)lit, (Object)lit.to((Type)Types.DecimalType.of((int)9, (int)scale)));
            Assert.assertSame((String)"Should return identical object", (Object)lit, (Object)lit.to((Type)Types.DecimalType.of((int)11, (int)scale)));
        });
    }

    @Test
    public void testIntegerToDateConversion() {
        Literal lit = Literal.of((int)0);
        Assert.assertEquals((String)"Dates should be equal", (Object)lit.to((Type)Types.DateType.get()), (Object)new Literals.DateLiteral(Integer.valueOf(0)));
        lit = Literal.of((int)18250);
        Assert.assertEquals((String)"Dates should be equal", (Object)lit.to((Type)Types.DateType.get()), (Object)new Literals.DateLiteral(Integer.valueOf(18250)));
    }

    @Test
    public void testLongToDateConversion() {
        Literal lit = Literal.of((long)0L);
        Assert.assertEquals((String)"Dates should be equal", (Object)lit.to((Type)Types.DateType.get()), (Object)new Literals.DateLiteral(Integer.valueOf(0)));
        lit = Literal.of((long)18250L);
        Assert.assertEquals((String)"Dates should be equal", (Object)lit.to((Type)Types.DateType.get()), (Object)new Literals.DateLiteral(Integer.valueOf(18250)));
    }
}

