/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestPredicateBinding {
    private static final List<Expression.Operation> COMPARISONS = Arrays.asList(Expression.Operation.LT, Expression.Operation.LT_EQ, Expression.Operation.GT, Expression.Operation.GT_EQ, Expression.Operation.EQ, Expression.Operation.NOT_EQ);

    @Test
    public void testMultipleFields() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"z", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"y"), (Object)6);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should reference correct field ID", (long)11L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should not change the comparison operation", (Object)Expression.Operation.LT, (Object)bound.op());
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should not alter literal value", (Object)6, (Object)bound.asLiteralPredicate().literal().value());
    }

    @Test
    public void testMissingField() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"missing"), (Object)6);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> unbound.bind(struct)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'missing' in struct:");
    }

    @Test
    public void testComparisonPredicateBinding() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        for (Expression.Operation op : COMPARISONS) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"x"), (Object)5);
            Expression expr = unbound.bind(struct);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
            Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
            Assert.assertEquals((String)"Should not alter literal value", (Object)5, (Object)bound.asLiteralPredicate().literal().value());
            Assert.assertEquals((String)"Should reference correct field ID", (long)14L, (long)bound.ref().fieldId());
            Assert.assertEquals((String)"Should not change the comparison operation", (Object)op, (Object)bound.op());
        }
    }

    @Test
    public void testPredicateBindingForStringPrefixComparisons() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"x", (Type)Types.StringType.get())});
        for (Expression.Operation op : Arrays.asList(Expression.Operation.STARTS_WITH, Expression.Operation.NOT_STARTS_WITH)) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"x"), (Object)"s");
            Expression expr = unbound.bind(struct);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
            Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
            Assert.assertEquals((String)"Should not alter literal value", (Object)"s", (Object)bound.asLiteralPredicate().literal().value());
            Assert.assertEquals((String)"Should reference correct field ID", (long)17L, (long)bound.ref().fieldId());
            Assert.assertEquals((String)"Should not change the comparison operation", (Object)op, (Object)bound.op());
        }
    }

    @Test
    public void testLiteralConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        for (Expression.Operation op : COMPARISONS) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"d"), (Object)"12.40");
            Expression expr = unbound.bind(struct);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
            Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
            Assert.assertEquals((String)"Should convert literal value to decimal", (Object)new BigDecimal("12.40"), (Object)bound.asLiteralPredicate().literal().value());
            Assert.assertEquals((String)"Should reference correct field ID", (long)15L, (long)bound.ref().fieldId());
            Assert.assertEquals((String)"Should not change the comparison operation", (Object)op, (Object)bound.op());
        }
    }

    @Test
    public void testInvalidConversions() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)16, (String)"f", (Type)Types.FloatType.get())});
        for (Expression.Operation op : COMPARISONS) {
            UnboundPredicate unbound = new UnboundPredicate(op, (UnboundTerm)Expressions.ref((String)"f"), (Object)"12.40");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> unbound.bind(struct)).isInstanceOf(ValidationException.class)).hasMessage("Invalid value for conversion to type float: 12.40 (java.lang.String)");
        }
    }

    @Test
    public void testLongToIntegerConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)17, (String)"i", (Type)Types.IntegerType.get())});
        UnboundPredicate lt = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        Assert.assertEquals((String)"Less than above max should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)lt.bind(struct));
        UnboundPredicate lteq = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        Assert.assertEquals((String)"Less than or equal above max should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)lteq.bind(struct));
        UnboundPredicate gt = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        Assert.assertEquals((String)"Greater than below min should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)gt.bind(struct));
        UnboundPredicate gteq = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        Assert.assertEquals((String)"Greater than or equal below min should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)gteq.bind(struct));
        UnboundPredicate gtMax = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        Assert.assertEquals((String)"Greater than above max should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)gtMax.bind(struct));
        UnboundPredicate gteqMax = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)0x80000000L);
        Assert.assertEquals((String)"Greater than or equal above max should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)gteqMax.bind(struct));
        UnboundPredicate ltMin = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        Assert.assertEquals((String)"Less than below min should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)ltMin.bind(struct));
        UnboundPredicate lteqMin = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)-2147483649L);
        Assert.assertEquals((String)"Less than or equal below min should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)lteqMin.bind(struct));
        Expression ltExpr = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MAX_VALUE).bind(struct, true);
        BoundPredicate ltMax = TestHelpers.assertAndUnwrap(ltExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)ltMax.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Integer", (Object)Integer.MAX_VALUE, (Object)ltMax.asLiteralPredicate().literal().value());
        Expression lteqExpr = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MAX_VALUE).bind(struct);
        BoundPredicate lteqMax = TestHelpers.assertAndUnwrap(lteqExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)lteqMax.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Integer", (Object)Integer.MAX_VALUE, (Object)lteqMax.asLiteralPredicate().literal().value());
        Expression gtExpr = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MIN_VALUE).bind(struct);
        BoundPredicate gtMin = TestHelpers.assertAndUnwrap(gtExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)gtMin.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Integer", (Object)Integer.MIN_VALUE, (Object)gtMin.asLiteralPredicate().literal().value());
        Expression gteqExpr = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"i"), (Object)Integer.MIN_VALUE).bind(struct);
        BoundPredicate gteqMin = TestHelpers.assertAndUnwrap(gteqExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)gteqMin.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Integer", (Object)Integer.MIN_VALUE, (Object)gteqMin.asLiteralPredicate().literal().value());
    }

    @Test
    public void testDoubleToFloatConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)18, (String)"f", (Type)Types.FloatType.get())});
        UnboundPredicate lt = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        Assert.assertEquals((String)"Less than above max should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)lt.bind(struct));
        UnboundPredicate lteq = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        Assert.assertEquals((String)"Less than or equal above max should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)lteq.bind(struct));
        UnboundPredicate gt = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        Assert.assertEquals((String)"Greater than below min should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)gt.bind(struct));
        UnboundPredicate gteq = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        Assert.assertEquals((String)"Greater than or equal below min should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)gteq.bind(struct));
        UnboundPredicate gtMax = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        Assert.assertEquals((String)"Greater than above max should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)gtMax.bind(struct));
        UnboundPredicate gteqMax = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)6.805646932770577E38);
        Assert.assertEquals((String)"Greater than or equal above max should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)gteqMax.bind(struct));
        UnboundPredicate ltMin = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        Assert.assertEquals((String)"Less than below min should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)ltMin.bind(struct));
        UnboundPredicate lteqMin = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)-6.805646932770577E38);
        Assert.assertEquals((String)"Less than or equal below min should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)lteqMin.bind(struct));
        Expression ltExpr = new UnboundPredicate(Expression.Operation.LT, (UnboundTerm)Expressions.ref((String)"f"), (Object)3.4028234663852886E38).bind(struct);
        BoundPredicate ltMax = TestHelpers.assertAndUnwrap(ltExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)ltMax.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Float", (Object)Float.valueOf(Float.MAX_VALUE), (Object)ltMax.asLiteralPredicate().literal().value());
        Expression lteqExpr = new UnboundPredicate(Expression.Operation.LT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)3.4028234663852886E38).bind(struct);
        BoundPredicate lteqMax = TestHelpers.assertAndUnwrap(lteqExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)lteqMax.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Float", (Object)Float.valueOf(Float.MAX_VALUE), (Object)lteqMax.asLiteralPredicate().literal().value());
        Expression gtExpr = new UnboundPredicate(Expression.Operation.GT, (UnboundTerm)Expressions.ref((String)"f"), (Object)-3.4028234663852886E38).bind(struct);
        BoundPredicate gtMin = TestHelpers.assertAndUnwrap(gtExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)gtMin.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Float", (Object)Float.valueOf(-3.4028235E38f), (Object)gtMin.asLiteralPredicate().literal().value());
        Expression gteqExpr = new UnboundPredicate(Expression.Operation.GT_EQ, (UnboundTerm)Expressions.ref((String)"f"), (Object)-3.4028234663852886E38).bind(struct);
        BoundPredicate gteqMin = TestHelpers.assertAndUnwrap(gteqExpr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)gteqMin.isLiteralPredicate());
        Assert.assertEquals((String)"Should translate bound to Float", (Object)Float.valueOf(-3.4028235E38f), (Object)gteqMin.asLiteralPredicate().literal().value());
    }

    @Test
    public void testIsNull() {
        Types.StructType optional = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)19, (String)"s", (Type)Types.StringType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.IS_NULL, (UnboundTerm)Expressions.ref((String)"s"));
        Expression expr = unbound.bind(optional);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should use the same operation", (Object)Expression.Operation.IS_NULL, (Object)bound.op());
        Assert.assertEquals((String)"Should use the correct field", (long)19L, (long)bound.ref().fieldId());
        Assert.assertTrue((String)"Should be a unary predicate", (boolean)bound.isUnaryPredicate());
        Types.StructType required = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"s", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"IsNull inclusive a required field should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)unbound.bind(required));
    }

    @Test
    public void testNotNull() {
        Types.StructType optional = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"s", (Type)Types.StringType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.NOT_NULL, (UnboundTerm)Expressions.ref((String)"s"));
        Expression expr = unbound.bind(optional);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should use the same operation", (Object)Expression.Operation.NOT_NULL, (Object)bound.op());
        Assert.assertEquals((String)"Should use the correct field", (long)21L, (long)bound.ref().fieldId());
        Assert.assertTrue((String)"Should be a unary predicate", (boolean)bound.isUnaryPredicate());
        Types.StructType required = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"s", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"NotNull inclusive a required field should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)unbound.bind(required));
    }

    @Test
    public void testIsNaN() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"d", (Type)Types.DoubleType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.IS_NAN, (UnboundTerm)Expressions.ref((String)"d"));
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should use the same operation", (Object)Expression.Operation.IS_NAN, (Object)bound.op());
        Assert.assertEquals((String)"Should use the correct field", (long)21L, (long)bound.ref().fieldId());
        Assert.assertTrue((String)"Should be a unary predicate", (boolean)bound.isUnaryPredicate());
        struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"f", (Type)Types.FloatType.get())});
        unbound = new UnboundPredicate(Expression.Operation.IS_NAN, (UnboundTerm)Expressions.ref((String)"f"));
        expr = unbound.bind(struct);
        bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should use the same operation", (Object)Expression.Operation.IS_NAN, (Object)bound.op());
        Assert.assertEquals((String)"Should use the correct field", (long)21L, (long)bound.ref().fieldId());
        Assert.assertTrue((String)"Should be a unary predicate", (boolean)bound.isUnaryPredicate());
        Types.StructType strStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"s", (Type)Types.StringType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new UnboundPredicate(Expression.Operation.IS_NAN, (UnboundTerm)Expressions.ref((String)"s")).bind(strStruct)).isInstanceOf(ValidationException.class)).hasMessage("IsNaN cannot be used with a non-floating-point column");
    }

    @Test
    public void testNotNaN() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"d", (Type)Types.DoubleType.get())});
        UnboundPredicate unbound = new UnboundPredicate(Expression.Operation.NOT_NAN, (UnboundTerm)Expressions.ref((String)"d"));
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should use the same operation", (Object)Expression.Operation.NOT_NAN, (Object)bound.op());
        Assert.assertEquals((String)"Should use the correct field", (long)21L, (long)bound.ref().fieldId());
        Assert.assertTrue((String)"Should be a unary predicate", (boolean)bound.isUnaryPredicate());
        struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"f", (Type)Types.FloatType.get())});
        unbound = new UnboundPredicate(Expression.Operation.NOT_NAN, (UnboundTerm)Expressions.ref((String)"f"));
        expr = unbound.bind(struct);
        bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertEquals((String)"Should use the same operation", (Object)Expression.Operation.NOT_NAN, (Object)bound.op());
        Assert.assertEquals((String)"Should use the correct field", (long)21L, (long)bound.ref().fieldId());
        Assert.assertTrue((String)"Should be a unary predicate", (boolean)bound.isUnaryPredicate());
        Types.StructType strStruct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)21, (String)"s", (Type)Types.StringType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new UnboundPredicate(Expression.Operation.NOT_NAN, (UnboundTerm)Expressions.ref((String)"s")).bind(strStruct)).isInstanceOf(ValidationException.class)).hasMessage("NotNaN cannot be used with a non-floating-point column");
    }

    @Test
    public void testInPredicateBinding() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"z", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"y", (Object[])new Integer[]{6, 7, 11});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        Assert.assertEquals((String)"Should reference correct field ID", (long)11L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should not change the IN operation", (Object)Expression.Operation.IN, (Object)bound.op());
        Assert.assertArrayEquals((String)"Should not alter literal set values", (Object[])new Integer[]{6, 7, 11}, (Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new Integer[2]));
    }

    @Test
    public void testInPredicateBindingConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.in((String)"d", (Object[])new String[]{"12.40", "1.23", "99.99", "1.23"});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        Assert.assertArrayEquals((String)"Should convert literal set values to decimal", (Object[])new BigDecimal[]{new BigDecimal("1.23"), new BigDecimal("12.40"), new BigDecimal("99.99")}, (Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new BigDecimal[2]));
        Assert.assertEquals((String)"Should reference correct field ID", (long)15L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should not change the IN operation", (Object)Expression.Operation.IN, (Object)bound.op());
    }

    @Test
    public void testInToEqPredicate() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"x", (Object[])new Integer[]{5});
        Assert.assertEquals((String)"Should create an IN predicate with a single item", (Object)Expression.Operation.IN, (Object)unbound.op());
        Assert.assertEquals((String)"Should create an IN predicate with a single item", (long)1L, (long)unbound.literals().size());
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should not alter literal value", (Object)5, (Object)bound.asLiteralPredicate().literal().value());
        Assert.assertEquals((String)"Should reference correct field ID", (long)14L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should change the operation from IN to EQ", (Object)Expression.Operation.EQ, (Object)bound.op());
    }

    @Test
    public void testInPredicateBindingConversionToEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"x", (Object[])new Long[]{5L, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        Assert.assertEquals((String)"Should create an IN unbound predicate", (Object)Expression.Operation.IN, (Object)op);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should remove aboveMax literal value", (Object)5, (Object)bound.asLiteralPredicate().literal().value());
        Assert.assertEquals((String)"Should reference correct field ID", (long)14L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should change the IN operation to EQ", (Object)Expression.Operation.EQ, (Object)bound.op());
    }

    @Test
    public void testInPredicateBindingConversionDedupToEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.in((String)"d", (Object[])new Double[]{12.4, 12.401, 12.402});
        Assert.assertEquals((String)"Should create an IN unbound predicate", (Object)Expression.Operation.IN, (Object)unbound.op());
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should convert literal set values to a single decimal", (Object)new BigDecimal("12.40"), (Object)bound.asLiteralPredicate().literal().value());
        Assert.assertEquals((String)"Should reference correct field ID", (long)15L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should change the IN operation to EQ", (Object)Expression.Operation.EQ, (Object)bound.op());
    }

    @Test
    public void testInPredicateBindingConversionToExpression() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.in((String)"x", (Object[])new Long[]{0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        Assert.assertEquals((String)"Should create an IN predicate", (Object)Expression.Operation.IN, (Object)op);
        Expression expr = unbound.bind(struct);
        Assert.assertEquals((String)"Should change IN to alwaysFalse expression", (Object)Expressions.alwaysFalse(), (Object)expr);
    }

    @Test
    public void testNotInPredicateBinding() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)11, (String)"y", (Type)Types.IntegerType.get()), Types.NestedField.required((int)12, (String)"z", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"y", (Object[])new Integer[]{6, 7, 11});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        Assert.assertEquals((String)"Should reference correct field ID", (long)11L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should not change the NOT_IN operation", (Object)Expression.Operation.NOT_IN, (Object)bound.op());
        Assert.assertArrayEquals((String)"Should not alter literal set values", (Object[])new Integer[]{6, 7, 11}, (Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new Integer[2]));
    }

    @Test
    public void testNotInPredicateBindingConversion() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.notIn((String)"d", (Object[])new String[]{"12.40", "1.23", "99.99", "1.23"});
        Expression expr = unbound.bind(struct);
        BoundSetPredicate bound = TestHelpers.assertAndUnwrapBoundSet(expr);
        Assert.assertArrayEquals((String)"Should convert literal set values to decimal", (Object[])new BigDecimal[]{new BigDecimal("1.23"), new BigDecimal("12.40"), new BigDecimal("99.99")}, (Object[])bound.literalSet().stream().sorted().collect(Collectors.toList()).toArray(new BigDecimal[2]));
        Assert.assertEquals((String)"Should reference correct field ID", (long)15L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should not change the NOT_IN operation", (Object)Expression.Operation.NOT_IN, (Object)bound.op());
    }

    @Test
    public void testNotInToNotEqPredicate() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"x", (Object[])new Integer[]{5});
        Assert.assertEquals((String)"Should create a NOT_IN predicate with a single item", (Object)Expression.Operation.NOT_IN, (Object)unbound.op());
        Assert.assertEquals((String)"Should create a NOT_IN predicate with a single item", (long)1L, (long)unbound.literals().size());
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should not alter literal value", (Object)5, (Object)bound.asLiteralPredicate().literal().value());
        Assert.assertEquals((String)"Should reference correct field ID", (long)14L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should change the operation from NOT_IN to NOT_EQ", (Object)Expression.Operation.NOT_EQ, (Object)bound.op());
    }

    @Test
    public void testNotInPredicateBindingConversionToNotEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"x", (Object[])new Long[]{5L, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        Assert.assertEquals((String)"Should create a NOT_IN unbound predicate", (Object)Expression.Operation.NOT_IN, (Object)op);
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should remove aboveMax literal value", (Object)5, (Object)bound.asLiteralPredicate().literal().value());
        Assert.assertEquals((String)"Should reference correct field ID", (long)14L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should change the NOT_IN operation to NOT_EQ", (Object)Expression.Operation.NOT_EQ, (Object)bound.op());
    }

    @Test
    public void testNotInPredicateBindingConversionDedupToNotEq() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"d", (Type)Types.DecimalType.of((int)9, (int)2))});
        UnboundPredicate unbound = Expressions.notIn((String)"d", (Object[])new Double[]{12.4, 12.401, 12.402});
        Assert.assertEquals((String)"Should create a NOT_IN unbound predicate", (Object)Expression.Operation.NOT_IN, (Object)unbound.op());
        Expression expr = unbound.bind(struct);
        BoundPredicate bound = TestHelpers.assertAndUnwrap(expr);
        Assert.assertTrue((String)"Should be a literal predicate", (boolean)bound.isLiteralPredicate());
        Assert.assertEquals((String)"Should convert literal set values to a single decimal", (Object)new BigDecimal("12.40"), (Object)bound.asLiteralPredicate().literal().value());
        Assert.assertEquals((String)"Should reference correct field ID", (long)15L, (long)bound.ref().fieldId());
        Assert.assertEquals((String)"Should change the NOT_IN operation to NOT_EQ", (Object)Expression.Operation.NOT_EQ, (Object)bound.op());
    }

    @Test
    public void testNotInPredicateBindingConversionToExpression() {
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)14, (String)"x", (Type)Types.IntegerType.get())});
        UnboundPredicate unbound = Expressions.notIn((String)"x", (Object[])new Long[]{0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE});
        Expression.Operation op = unbound.op();
        Assert.assertEquals((String)"Should create an NOT_IN predicate", (Object)Expression.Operation.NOT_IN, (Object)op);
        Expression expr = unbound.bind(struct);
        Assert.assertEquals((String)"Should change NOT_IN to alwaysTrue expression", (Object)Expressions.alwaysTrue(), (Object)expr);
    }
}

