/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestStringLiteralConversions {
    @Test
    public void testStringToStringLiteral() {
        Literal string = Literal.of((CharSequence)"abc");
        Assert.assertSame((String)"Should return same instance", (Object)string, (Object)string.to((Type)Types.StringType.get()));
    }

    @Test
    public void testStringToDateLiteral() {
        Literal dateStr = Literal.of((CharSequence)"2017-08-18");
        Literal date = dateStr.to((Type)Types.DateType.get());
        Schema avroSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TimeConversions.DateConversion avroConversion = new TimeConversions.DateConversion();
        int avroValue = avroConversion.toInt(LocalDate.of(2017, 8, 18), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Date should match", (long)avroValue, (long)((Integer)date.value()).intValue());
    }

    @Test
    public void testNegativeStringToDateLiteral() {
        Literal dateStr = Literal.of((CharSequence)"1969-12-30");
        Literal date = dateStr.to((Type)Types.DateType.get());
        Schema avroSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TimeConversions.DateConversion avroConversion = new TimeConversions.DateConversion();
        int avroValue = avroConversion.toInt(LocalDate.of(1969, 12, 30), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Date should be -2", (long)-2L, (long)((Integer)date.value()).intValue());
        Assert.assertEquals((String)"Date should match", (long)avroValue, (long)((Integer)date.value()).intValue());
    }

    @Test
    public void testStringToTimeLiteral() {
        Schema avroSchema = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Literal timeStr = Literal.of((CharSequence)"14:21:01.919");
        Literal time = timeStr.to((Type)Types.TimeType.get());
        long avroValue = new TimeConversions.TimeMicrosConversion().toLong(LocalTime.of(14, 21, 1, 919000000), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Time should match", (long)avroValue, (long)((Long)time.value()));
    }

    @Test
    public void testStringToTimestampLiteral() {
        Schema avroSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TimeConversions.TimestampMicrosConversion avroConversion = new TimeConversions.TimestampMicrosConversion();
        Literal timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919+00:00");
        Literal timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        long avroValue = avroConversion.toLong(LocalDateTime.of(2017, 8, 18, 14, 21, 1, 919000000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Timestamp should match", (long)avroValue, (long)((Long)timestamp.value()));
        timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919");
        timestamp = timestampStr.to((Type)Types.TimestampType.withoutZone());
        Assert.assertEquals((String)"Timestamp without zone should match UTC", (long)avroValue, (long)((Long)timestamp.value()));
        timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919-07:00");
        timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        avroValue = avroConversion.toLong(LocalDateTime.of(2017, 8, 18, 21, 21, 1, 919000000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Timestamp without zone should match UTC", (long)avroValue, (long)((Long)timestamp.value()));
    }

    @Test
    public void testNegativeStringToTimestampLiteral() {
        Schema avroSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TimeConversions.TimestampMicrosConversion avroConversion = new TimeConversions.TimestampMicrosConversion();
        Literal timestampStr = Literal.of((CharSequence)"1969-12-31T23:59:58.999999+00:00");
        Literal timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        long avroValue = avroConversion.toLong(LocalDateTime.of(1969, 12, 31, 23, 59, 58, 999999000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Timestamp should match", (long)avroValue, (long)((Long)timestamp.value()));
        Assert.assertEquals((String)"Timestamp should be -1_000_001", (long)-1000001L, (long)((Long)timestamp.value()));
        timestampStr = Literal.of((CharSequence)"1969-12-31T23:59:58.999999");
        timestamp = timestampStr.to((Type)Types.TimestampType.withoutZone());
        Assert.assertEquals((String)"Timestamp without zone should match UTC", (long)avroValue, (long)((Long)timestamp.value()));
        timestampStr = Literal.of((CharSequence)"1969-12-31T16:59:58.999999-07:00");
        timestamp = timestampStr.to((Type)Types.TimestampType.withZone());
        avroValue = avroConversion.toLong(LocalDateTime.of(1969, 12, 31, 23, 59, 58, 999999000).toInstant(ZoneOffset.UTC), avroSchema, avroSchema.getLogicalType());
        Assert.assertEquals((String)"Timestamp without zone should match UTC", (long)avroValue, (long)((Long)timestamp.value()));
        Assert.assertEquals((String)"Timestamp without zone should be -1_000_001", (long)-1000001L, (long)((Long)timestamp.value()));
    }

    @Test
    public void testTimestampWithZoneWithoutZoneInLiteral() {
        Literal timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> timestampStr.to((Type)Types.TimestampType.withZone())).isInstanceOf(DateTimeException.class)).hasMessageContaining("could not be parsed");
    }

    @Test
    public void testTimestampWithoutZoneWithZoneInLiteral() {
        Literal timestampStr = Literal.of((CharSequence)"2017-08-18T14:21:01.919+07:00");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> timestampStr.to((Type)Types.TimestampType.withoutZone())).isInstanceOf(DateTimeException.class)).hasMessageContaining("could not be parsed");
    }

    @Test
    public void testStringToUUIDLiteral() {
        UUID expected = UUID.randomUUID();
        Literal uuidStr = Literal.of((CharSequence)expected.toString());
        Literal uuid = uuidStr.to((Type)Types.UUIDType.get());
        Assert.assertEquals((String)"UUID should match", (Object)expected, (Object)uuid.value());
    }

    @Test
    public void testStringToDecimalLiteral() {
        BigDecimal expected = new BigDecimal("34.560");
        Literal decimalStr = Literal.of((CharSequence)"34.560");
        IntStream.range(0, 10).forEach(scale -> {
            Literal decimal = decimalStr.to((Type)Types.DecimalType.of((int)9, (int)scale));
            Assert.assertEquals((String)"Decimal should have scale 3", (long)3L, (long)((BigDecimal)decimal.value()).scale());
            Assert.assertEquals((String)"Decimal should match", (Object)expected, (Object)decimal.value());
        });
    }
}

