/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.DefaultCounter;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.MetricsContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestDefaultCounter {
    @Test
    public void nullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultMetricsContext().counter("test", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid count unit: null");
    }

    @Test
    public void noop() {
        Assertions.assertThat((Comparable)DefaultCounter.NOOP.unit()).isEqualTo((Object)MetricsContext.Unit.UNDEFINED);
        Assertions.assertThat((boolean)DefaultCounter.NOOP.isNoop()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Counter)DefaultCounter.NOOP).value()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("NOOP counter has no value");
    }

    @Test
    public void count() {
        DefaultCounter counter = new DefaultCounter(MetricsContext.Unit.BYTES);
        counter.increment();
        counter.increment(5L);
        Assertions.assertThat((long)counter.value()).isEqualTo(6L);
        Assertions.assertThat((Comparable)counter.unit()).isEqualTo((Object)MetricsContext.Unit.BYTES);
        Assertions.assertThat((boolean)counter.isNoop()).isFalse();
    }

    @Test
    public void counterOverflow() {
        DefaultCounter counter = new DefaultCounter(MetricsContext.Unit.COUNT);
        counter.increment(Long.MAX_VALUE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Counter)counter).increment()).isInstanceOf(ArithmeticException.class)).hasMessage("long overflow");
        Assertions.assertThat((long)counter.value()).isEqualTo(Long.MAX_VALUE);
    }
}

