/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.DefaultMetricsContext;
import org.apache.iceberg.metrics.Histogram;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.Timer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestDefaultMetricsContext {
    @Test
    public void unsupportedCounter() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestDefaultMetricsContext.lambda$unsupportedCounter$0((MetricsContext)metricsContext)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Counter for type java.lang.Double is not supported");
    }

    @Test
    public void intCounterNullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultMetricsContext().counter("name", Integer.class, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid count unit: null");
    }

    @Test
    public void intCounter() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        MetricsContext.Counter counter = metricsContext.counter("intCounter", Integer.class, MetricsContext.Unit.BYTES);
        counter.increment((Number)5);
        Assertions.assertThat((Integer)((Integer)counter.value())).isEqualTo(5);
        Assertions.assertThat((Comparable)counter.unit()).isEqualTo((Object)MetricsContext.Unit.BYTES);
    }

    @Test
    public void intCounterOverflow() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        MetricsContext.Counter counter = metricsContext.counter("test", Integer.class, MetricsContext.Unit.COUNT);
        counter.increment((Number)Integer.MAX_VALUE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MetricsContext.Counter)counter).increment()).isInstanceOf(ArithmeticException.class)).hasMessage("integer overflow");
        Assertions.assertThat((Integer)((Integer)counter.value())).isEqualTo(Integer.MAX_VALUE);
    }

    @Test
    public void longCounterNullCheck() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultMetricsContext().counter("name", Long.class, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid count unit: null");
    }

    @Test
    public void longCounter() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        MetricsContext.Counter counter = metricsContext.counter("longCounter", Long.class, MetricsContext.Unit.COUNT);
        counter.increment((Number)5L);
        Assertions.assertThat((Long)((Long)counter.value())).isEqualTo(5L);
        Assertions.assertThat((Comparable)counter.unit()).isEqualTo((Object)MetricsContext.Unit.COUNT);
    }

    @Test
    public void longCounterOverflow() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        MetricsContext.Counter counter = metricsContext.counter("test", Long.class, MetricsContext.Unit.COUNT);
        counter.increment((Number)Long.MAX_VALUE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MetricsContext.Counter)counter).increment()).isInstanceOf(ArithmeticException.class)).hasMessage("long overflow");
        Assertions.assertThat((Long)((Long)counter.value())).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    public void timer() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        Timer timer = metricsContext.timer("test", TimeUnit.MICROSECONDS);
        timer.record(10L, TimeUnit.MINUTES);
        Assertions.assertThat((Duration)timer.totalDuration()).isEqualTo((Object)Duration.ofMinutes(10L));
    }

    @Test
    public void histogram() {
        DefaultMetricsContext metricsContext = new DefaultMetricsContext();
        int reservoirSize = 1000;
        Histogram histogram = metricsContext.histogram("test");
        for (int i = 1; i <= reservoirSize; ++i) {
            histogram.update((long)i);
        }
        Assertions.assertThat((int)histogram.count()).isEqualTo(reservoirSize);
        Histogram.Statistics statistics = histogram.statistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(reservoirSize);
        Assertions.assertThat((double)statistics.mean()).isEqualTo(500.5);
        Assertions.assertThat((double)statistics.stdDev()).isCloseTo(288.67499, Assertions.withinPercentage((Double)0.001));
        Assertions.assertThat((long)statistics.max()).isEqualTo(1000L);
        Assertions.assertThat((long)statistics.min()).isEqualTo(1L);
        Assertions.assertThat((long)statistics.percentile(0.5)).isEqualTo(500L);
        Assertions.assertThat((long)statistics.percentile(0.75)).isEqualTo(750L);
        Assertions.assertThat((long)statistics.percentile(0.9)).isEqualTo(900L);
        Assertions.assertThat((long)statistics.percentile(0.95)).isEqualTo(950L);
        Assertions.assertThat((long)statistics.percentile(0.99)).isEqualTo(990L);
        Assertions.assertThat((long)statistics.percentile(0.999)).isEqualTo(999L);
    }

    private static /* synthetic */ void lambda$unsupportedCounter$0(MetricsContext metricsContext) throws Throwable {
        metricsContext.counter("test", Double.class, MetricsContext.Unit.COUNT);
    }
}

