/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestBucketingProjection {
    public void assertProjectionStrict(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Assert.assertEquals((Object)expectedOp, (Object)predicate.op());
        Assert.assertNotEquals((String)"Strict projection never runs for IN", (Object)Expression.Operation.IN, (Object)predicate.op());
        if (predicate.op() == Expression.Operation.NOT_IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(String::valueOf).collect(Collectors.toList()).toString();
            Assert.assertEquals((Object)expectedLiteral, (Object)actual);
        } else {
            Literal literal = predicate.literal();
            String output = String.valueOf(literal.value());
            Assert.assertEquals((Object)expectedLiteral, (Object)output);
        }
    }

    public void assertProjectionStrictValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        Assert.assertEquals((Object)projection.op(), (Object)expectedOp);
    }

    public void assertProjectionInclusiveValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        Assert.assertEquals((Object)projection.op(), (Object)expectedOp);
    }

    public void assertProjectionInclusive(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Assert.assertEquals((Object)predicate.op(), (Object)expectedOp);
        Assert.assertNotEquals((String)"Inclusive projection never runs for NOT_IN", (Object)Expression.Operation.NOT_IN, (Object)predicate.op());
        if (predicate.op() == Expression.Operation.IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(String::valueOf).collect(Collectors.toList()).toString();
            Assert.assertEquals((Object)expectedLiteral, (Object)actual);
        } else {
            Literal literal = predicate.literal();
            String output = String.valueOf(literal.value());
            Assert.assertEquals((Object)expectedLiteral, (Object)output);
        }
    }

    @Test
    public void testBucketIntegerStrict() {
        Integer value = 100;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "6");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new Integer[]{value - 1, value, value + 1}), Expression.Operation.NOT_IN, "[6, 7, 8]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new Integer[]{value, value + 1}), Expression.Operation.FALSE);
    }

    @Test
    public void testBucketIntegerInclusive() {
        Integer value = 100;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "6");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new Integer[]{value - 1, value, value + 1}), Expression.Operation.IN, "[6, 7, 8]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new Integer[]{value, value + 1}), Expression.Operation.TRUE);
    }

    @Test
    public void testBucketLongStrict() {
        Long value = 100L;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "6");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new Long[]{value - 1L, value, value + 1L}), Expression.Operation.NOT_IN, "[6, 7, 8]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new Long[]{value, value + 1L}), Expression.Operation.FALSE);
    }

    @Test
    public void testBucketLongInclusive() {
        Long value = 100L;
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.LongType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "6");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new Long[]{value - 1L, value, value + 1L}), Expression.Operation.IN, "[6, 7, 8]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new Long[]{value, value + 1L}), Expression.Operation.TRUE);
    }

    @Test
    public void testBucketDecimalStrict() {
        Types.DecimalType type = Types.DecimalType.of((int)9, (int)2);
        BigDecimal value = (BigDecimal)Literal.of((CharSequence)"100.00").to((Type)type).value();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)type)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "2");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        BigDecimal delta = new BigDecimal(1);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new BigDecimal[]{value.add(delta), value, value.subtract(delta)}), Expression.Operation.NOT_IN, "[2, 2, 6]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new BigDecimal[]{value, value.add(delta)}), Expression.Operation.FALSE);
    }

    @Test
    public void testBucketDecimalInclusive() {
        Types.DecimalType type = Types.DecimalType.of((int)9, (int)2);
        BigDecimal value = (BigDecimal)Literal.of((CharSequence)"100.00").to((Type)type).value();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)type)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "2");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        BigDecimal delta = new BigDecimal(1);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new BigDecimal[]{value.add(delta), value, value.subtract(delta)}), Expression.Operation.IN, "[2, 2, 6]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new BigDecimal[]{value, value.add(delta)}), Expression.Operation.TRUE);
    }

    @Test
    public void testBucketStringStrict() {
        String value = "abcdefg";
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "4");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.NOT_IN, "[4, 9]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.FALSE);
    }

    @Test
    public void testBucketStringInclusive() {
        String value = "abcdefg";
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "4");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.IN, "[4, 9]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new String[]{value, value + "abc"}), Expression.Operation.TRUE);
    }

    @Test
    public void testBucketByteBufferStrict() throws Exception {
        ByteBuffer value = ByteBuffer.wrap("abcdefg".getBytes("UTF-8"));
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.BinaryType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "4");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        ByteBuffer anotherValue = ByteBuffer.wrap("abcdehij".getBytes("UTF-8"));
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.NOT_IN, "[4, 6]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.FALSE);
    }

    @Test
    public void testBucketByteBufferInclusive() throws Exception {
        ByteBuffer value = ByteBuffer.wrap("abcdefg".getBytes("UTF-8"));
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.BinaryType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "4");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        ByteBuffer anotherValue = ByteBuffer.wrap("abcdehij".getBytes("UTF-8"));
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.IN, "[4, 6]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new ByteBuffer[]{value, anotherValue}), Expression.Operation.TRUE);
    }

    @Test
    public void testBucketUUIDStrict() {
        UUID value = new UUID(123L, 456L);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.UUIDType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.NOT_EQ, "4");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.FALSE);
        this.assertProjectionStrictValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.FALSE);
        UUID anotherValue = new UUID(456L, 123L);
        this.assertProjectionStrict(spec, Expressions.notIn((String)"value", (Object[])new UUID[]{value, anotherValue}), Expression.Operation.NOT_IN, "[4, 6]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"value", (Object[])new UUID[]{value, anotherValue}), Expression.Operation.FALSE);
    }

    @Test
    public void testBucketUUIDInclusive() {
        UUID value = new UUID(123L, 456L);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"value", (Type)Types.UUIDType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("value", 10).build();
        this.assertProjectionInclusive(spec, Expressions.equal((String)"value", (Object)value), Expression.Operation.EQ, "4");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.lessThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThan((String)"value", (Object)value), Expression.Operation.TRUE);
        this.assertProjectionInclusiveValue(spec, Expressions.greaterThanOrEqual((String)"value", (Object)value), Expression.Operation.TRUE);
        UUID anotherValue = new UUID(456L, 123L);
        this.assertProjectionInclusive(spec, Expressions.in((String)"value", (Object[])new UUID[]{value, anotherValue}), Expression.Operation.IN, "[4, 6]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"value", (Object[])new UUID[]{value, anotherValue}), Expression.Operation.TRUE);
    }
}

