/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestDates {
    @Test
    public void testDeprecatedDateTransform() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"2017-12-01").to((Type)type);
        Literal pd = Literal.of((CharSequence)"1970-01-01").to((Type)type);
        Literal nd = Literal.of((CharSequence)"1969-12-31").to((Type)type);
        Transform years = Transforms.year((Type)type);
        Assert.assertEquals((String)"Should produce 2017 - 1970 = 47", (long)47L, (long)((Integer)years.apply((Object)((Integer)date.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1970 - 1970 = 0", (long)0L, (long)((Integer)years.apply((Object)((Integer)pd.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1969 - 1970 = -1", (long)-1L, (long)((Integer)years.apply((Object)((Integer)nd.value()))).intValue());
        Transform months = Transforms.month((Type)type);
        Assert.assertEquals((String)"Should produce 47 * 12 + 11 = 575", (long)575L, (long)((Integer)months.apply((Object)((Integer)date.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 12 + 0 = 0", (long)0L, (long)((Integer)months.apply((Object)((Integer)pd.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)months.apply((Object)((Integer)nd.value()))).intValue());
        Transform days = Transforms.day((Type)type);
        Assert.assertEquals((String)"Should produce 17501", (long)17501L, (long)((Integer)days.apply((Object)((Integer)date.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 365 + 0 = 0", (long)0L, (long)((Integer)days.apply((Object)((Integer)pd.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)days.apply((Object)((Integer)nd.value()))).intValue());
    }

    @Test
    public void testDateTransform() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"2017-12-01").to((Type)type);
        Literal pd = Literal.of((CharSequence)"1970-01-01").to((Type)type);
        Literal nd = Literal.of((CharSequence)"1969-12-31").to((Type)type);
        Transform years = Transforms.year();
        Assert.assertEquals((String)"Should produce 2017 - 1970 = 47", (long)47L, (long)((Integer)years.bind((Type)type).apply((Object)((Integer)date.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1970 - 1970 = 0", (long)0L, (long)((Integer)years.bind((Type)type).apply((Object)((Integer)pd.value()))).intValue());
        Assert.assertEquals((String)"Should produce 1969 - 1970 = -1", (long)-1L, (long)((Integer)years.bind((Type)type).apply((Object)((Integer)nd.value()))).intValue());
        Transform months = Transforms.month();
        Assert.assertEquals((String)"Should produce 47 * 12 + 11 = 575", (long)575L, (long)((Integer)months.bind((Type)type).apply((Object)((Integer)date.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 12 + 0 = 0", (long)0L, (long)((Integer)months.bind((Type)type).apply((Object)((Integer)pd.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)months.bind((Type)type).apply((Object)((Integer)nd.value()))).intValue());
        Transform days = Transforms.day();
        Assert.assertEquals((String)"Should produce 17501", (long)17501L, (long)((Integer)days.bind((Type)type).apply((Object)((Integer)date.value()))).intValue());
        Assert.assertEquals((String)"Should produce 0 * 365 + 0 = 0", (long)0L, (long)((Integer)days.bind((Type)type).apply((Object)((Integer)pd.value()))).intValue());
        Assert.assertEquals((String)"Should produce -1", (long)-1L, (long)((Integer)days.bind((Type)type).apply((Object)((Integer)nd.value()))).intValue());
    }

    @Test
    public void testDateToHumanString() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"2017-12-01").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"2017-12-01", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value())))));
    }

    @Test
    public void testNegativeDateToHumanString() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1969-12-30").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-30", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value())))));
    }

    @Test
    public void testDateToHumanStringLowerBound() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1970-01-01").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1970", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1970-01", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1970-01-01", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value())))));
    }

    @Test
    public void testNegativeDateToHumanStringLowerBound() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1969-01-01").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-01", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-01-01", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value())))));
    }

    @Test
    public void testNegativeDateToHumanStringUpperBound() {
        Types.DateType type = Types.DateType.get();
        Literal date = Literal.of((CharSequence)"1969-12-31").to((Type)type);
        Transform year = Transforms.year();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969", (Object)year.toHumanString((Type)type, (Object)((Integer)year.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform month = Transforms.month();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12", (Object)month.toHumanString((Type)type, (Object)((Integer)month.bind((Type)type).apply((Object)((Integer)date.value())))));
        Transform day = Transforms.day();
        Assert.assertEquals((String)"Should produce the correct Human string", (Object)"1969-12-31", (Object)day.toHumanString((Type)type, (Object)((Integer)day.bind((Type)type).apply((Object)((Integer)date.value())))));
    }

    @Test
    public void testNullHumanString() {
        Types.DateType type = Types.DateType.get();
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.year().toHumanString((Type)type, null));
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.month().toHumanString((Type)type, null));
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)Transforms.day().toHumanString((Type)type, null));
    }

    @Test
    public void testDatesReturnType() {
        Types.DateType type = Types.DateType.get();
        Transform year = Transforms.year();
        Type yearResultType = year.getResultType((Type)type);
        Assert.assertEquals((Object)Types.IntegerType.get(), (Object)yearResultType);
        Transform month = Transforms.month();
        Type monthResultType = month.getResultType((Type)type);
        Assert.assertEquals((Object)Types.IntegerType.get(), (Object)monthResultType);
        Transform day = Transforms.day();
        Type dayResultType = day.getResultType((Type)type);
        Assert.assertEquals((Object)Types.DateType.get(), (Object)dayResultType);
    }
}

