/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestDatesProjection {
    private static final Types.DateType TYPE = Types.DateType.get();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"date", (Type)TYPE)});

    public void assertProjectionStrict(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Assert.assertEquals((Object)expectedOp, (Object)predicate.op());
        Assert.assertNotEquals((String)"Strict projection never runs for IN", (Object)Expression.Operation.IN, (Object)predicate.op());
        Transform transform = ((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        Type type = spec.partitionType().field(((PartitionField)spec.getFieldsBySourceId(1).get(0)).fieldId()).type();
        if (predicate.op() == Expression.Operation.NOT_IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(v -> transform.toHumanString(type, v)).collect(Collectors.toList()).toString();
            Assert.assertEquals((Object)expectedLiteral, (Object)actual);
        } else {
            Literal literal = predicate.literal();
            String output = transform.toHumanString(type, (Object)((Integer)literal.value()));
            Assert.assertEquals((Object)expectedLiteral, (Object)output);
        }
    }

    public void assertProjectionStrictValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.strict((PartitionSpec)spec).project(filter);
        Assert.assertEquals((Object)expectedOp, (Object)projection.op());
    }

    public void assertProjectionInclusiveValue(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        Assert.assertEquals((Object)expectedOp, (Object)projection.op());
    }

    public void assertProjectionInclusive(PartitionSpec spec, UnboundPredicate<?> filter, Expression.Operation expectedOp, String expectedLiteral) {
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        UnboundPredicate predicate = TestHelpers.assertAndUnwrapUnbound(projection);
        Assert.assertEquals((Object)expectedOp, (Object)predicate.op());
        Assert.assertNotEquals((String)"Inclusive projection never runs for NOT_IN", (Object)Expression.Operation.NOT_IN, (Object)predicate.op());
        Transform transform = ((PartitionField)spec.getFieldsBySourceId(1).get(0)).transform();
        Type type = spec.partitionType().field(((PartitionField)spec.getFieldsBySourceId(1).get(0)).fieldId()).type();
        if (predicate.op() == Expression.Operation.IN) {
            Iterable values = Iterables.transform((Iterable)predicate.literals(), Literal::value);
            String actual = Lists.newArrayList((Iterable)values).stream().sorted().map(v -> transform.toHumanString(type, v)).collect(Collectors.toList()).toString();
            Assert.assertEquals((Object)expectedLiteral, (Object)actual);
        } else {
            Literal literal = predicate.literal();
            String output = transform.toHumanString(type, (Object)((Integer)literal.value()));
            Assert.assertEquals((Object)expectedLiteral, (Object)output);
        }
    }

    @Test
    public void testMonthStrictEpoch() {
        Integer date = (Integer)Literal.of((CharSequence)"1970-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "1970-02");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "1970-01");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969-12, 1970-01]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testMonthInclusiveEpoch() {
        Integer date = (Integer)Literal.of((CharSequence)"1970-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "1970-01");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[1969-12, 1970-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testMonthStrictLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "2017-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "2017-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "2017-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "2016-12");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "2017-01");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2017-12-02").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{anotherDate, date}), Expression.Operation.NOT_IN, "[2017-01, 2017-12]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{anotherDate, date}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeMonthStrictLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "1969-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "1969-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "1969-02");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "1969-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_IN, "[1969-01, 1969-02]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969-01, 1969-02, 1969-12, 1970-01]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testMonthStrictUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "2018-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "2017-12");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "2017-12");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{anotherDate, date}), Expression.Operation.NOT_IN, "[2017-01, 2017-12]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{anotherDate, date}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeMonthStrictUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "1969-12");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "1970-01");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_IN, "[1969-12, 1970-01]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-11-01").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969-11, 1969-12, 1970-01]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testMonthInclusiveLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-12-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017-11");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "2017-12");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[2017-01, 2017-12]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeMonthInclusiveLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "1969-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "1969-02");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "1969-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "1969-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.IN, "[1969-01, 1969-02]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[1969-01, 1969-02, 1969-12, 1970-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testMonthInclusiveUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "2018-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017-12");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "2017-12");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[2017-01, 2017-12]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeMonthInclusiveUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).month("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "1970-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "1969-12");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.IN, "[1969-12, 1970-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-01-01").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[1969-01, 1969-02, 1969-12, 1970-01]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testDayStrict() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "2017-01-01");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "2017-01-02");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "2017-01-01");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "2016-12-31");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "2017-01-01");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2017-12-31").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2017-01-01, 2017-12-31]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeDayStrict() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-12-30").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "1969-12-30");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "1969-12-31");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "1969-12-30");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "1969-12-29");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "1969-12-30");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-28").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969-12-28, 1969-12-30]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testDayInclusive() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "2016-12-31");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017-01-01");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017-01-02");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017-01-01");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "2017-01-01");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2017-12-31").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[2017-01-01, 2017-12-31]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeDayInclusive() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-12-30").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).day("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "1969-12-29");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "1969-12-30");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "1969-12-31");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "1969-12-30");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "1969-12-30");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-28").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[1969-12-28, 1969-12-30]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testYearStrictLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "2017");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "2017");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "2017");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "2016");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "2017");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2016-12-31").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2016, 2017]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeYearStrictLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1970-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "1970");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "1970");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "1971");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "1970");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "1970");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969, 1970]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testYearStrictUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "2017");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "2018");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "2017");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "2017");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_EQ, "2017");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2016-01-01").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[2016, 2017]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testNegativeYearStrictUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionStrict(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT, "1969");
        this.assertProjectionStrict(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT, "1970");
        this.assertProjectionStrict(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT, "1970");
        this.assertProjectionStrict(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT, "1970");
        this.assertProjectionStrict(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.NOT_IN, "[1969, 1970]");
        this.assertProjectionStrictValue(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.FALSE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1970-01-01").to((Type)TYPE).value();
        this.assertProjectionStrict(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.NOT_IN, "[1969, 1970]");
        this.assertProjectionStrictValue(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.FALSE);
    }

    @Test
    public void testYearInclusiveLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "2016");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "2017");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2016-12-31").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[2016, 2017]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeYearInclusiveLowerBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1970-01-01").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "1970");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[1969, 1970]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testYearInclusiveUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"2017-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "2018");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "2017");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.EQ, "2017");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"2016-01-01").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[2016, 2017]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }

    @Test
    public void testNegativeYearInclusiveUpperBound() {
        Integer date = (Integer)Literal.of((CharSequence)"1969-12-31").to((Type)TYPE).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).year("date").build();
        this.assertProjectionInclusive(spec, Expressions.lessThan((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.lessThanOrEqual((String)"date", (Object)date), Expression.Operation.LT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.greaterThan((String)"date", (Object)date), Expression.Operation.GT_EQ, "1970");
        this.assertProjectionInclusive(spec, Expressions.greaterThanOrEqual((String)"date", (Object)date), Expression.Operation.GT_EQ, "1969");
        this.assertProjectionInclusive(spec, Expressions.equal((String)"date", (Object)date), Expression.Operation.IN, "[1969, 1970]");
        this.assertProjectionInclusiveValue(spec, Expressions.notEqual((String)"date", (Object)date), Expression.Operation.TRUE);
        Integer anotherDate = (Integer)Literal.of((CharSequence)"1969-01-01").to((Type)TYPE).value();
        this.assertProjectionInclusive(spec, Expressions.in((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.IN, "[1969, 1970]");
        this.assertProjectionInclusiveValue(spec, Expressions.notIn((String)"date", (Object[])new Integer[]{date, anotherDate}), Expression.Operation.TRUE);
    }
}

