/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestIdentity {
    @Test
    public void testNullHumanString() {
        Types.LongType longType = Types.LongType.get();
        Transform identity = Transforms.identity();
        Assert.assertEquals((String)"Should produce \"null\" for null", (Object)"null", (Object)identity.toHumanString((Type)longType, null));
    }

    @Test
    public void testBinaryHumanString() {
        Types.BinaryType binary = Types.BinaryType.get();
        Transform identity = Transforms.identity();
        Assert.assertEquals((String)"Should base64-encode binary", (Object)"AQID", (Object)identity.toHumanString((Type)binary, (Object)ByteBuffer.wrap(new byte[]{1, 2, 3})));
    }

    @Test
    public void testFixedHumanString() {
        Types.FixedType fixed3 = Types.FixedType.ofLength((int)3);
        Transform identity = Transforms.identity();
        Assert.assertEquals((String)"Should base64-encode binary", (Object)"AQID", (Object)identity.toHumanString((Type)fixed3, (Object)new byte[]{1, 2, 3}));
    }

    @Test
    public void testDateHumanString() {
        Types.DateType date = Types.DateType.get();
        Transform identity = Transforms.identity();
        String dateString = "2017-12-01";
        Literal dateLit = Literal.of((CharSequence)dateString).to((Type)date);
        Assert.assertEquals((String)"Should produce identical date", (Object)dateString, (Object)identity.toHumanString((Type)date, (Object)((Integer)dateLit.value())));
    }

    @Test
    public void testDateHumanStringDeprecated() {
        Types.DateType date = Types.DateType.get();
        Transform identity = Transforms.identity((Type)date);
        String dateString = "2017-12-01";
        Literal dateLit = Literal.of((CharSequence)dateString).to((Type)date);
        Assert.assertEquals((String)"Should produce identical date", (Object)dateString, (Object)identity.toHumanString((Object)((Integer)dateLit.value())));
    }

    @Test
    public void testTimeHumanString() {
        Types.TimeType time = Types.TimeType.get();
        Transform identity = Transforms.identity();
        String timeString = "10:12:55.038194";
        Literal timeLit = Literal.of((CharSequence)timeString).to((Type)time);
        Assert.assertEquals((String)"Should produce identical time", (Object)timeString, (Object)identity.toHumanString((Type)time, (Object)((Long)timeLit.value())));
    }

    @Test
    public void testTimestampWithZoneHumanString() {
        Types.TimestampType timestamptz = Types.TimestampType.withZone();
        Transform identity = Transforms.identity();
        Literal ts = Literal.of((CharSequence)"2017-12-01T10:12:55.038194-08:00").to((Type)timestamptz);
        Assert.assertEquals((String)"Should produce timestamp with time zone adjusted to UTC", (Object)"2017-12-01T18:12:55.038194Z", (Object)identity.toHumanString((Type)timestamptz, (Object)((Long)ts.value())));
    }

    @Test
    public void testTimestampWithoutZoneHumanString() {
        Types.TimestampType timestamp = Types.TimestampType.withoutZone();
        Transform identity = Transforms.identity();
        String tsString = "2017-12-01T10:12:55.038194";
        Literal ts = Literal.of((CharSequence)tsString).to((Type)timestamp);
        Assert.assertEquals((String)"Should produce identical timestamp without time zone", (Object)tsString, (Object)identity.toHumanString((Type)timestamp, (Object)((Long)ts.value())));
    }

    @Test
    public void testLongToHumanString() {
        Types.LongType longType = Types.LongType.get();
        Transform identity = Transforms.identity();
        Assert.assertEquals((String)"Should use Long toString", (Object)"-1234567890000", (Object)identity.toHumanString((Type)longType, (Object)-1234567890000L));
    }

    @Test
    public void testStringToHumanString() {
        Types.StringType string = Types.StringType.get();
        Transform identity = Transforms.identity();
        String withSlash = "a/b/c=d";
        Assert.assertEquals((String)"Should not modify Strings", (Object)withSlash, (Object)identity.toHumanString((Type)string, (Object)withSlash));
    }

    @Test
    public void testBigDecimalToHumanString() {
        Types.DecimalType decimal = Types.DecimalType.of((int)9, (int)2);
        Transform identity = Transforms.identity();
        String decimalString = "-1.50";
        BigDecimal bigDecimal = new BigDecimal(decimalString);
        Assert.assertEquals((String)"Should not modify Strings", (Object)decimalString, (Object)identity.toHumanString((Type)decimal, (Object)bigDecimal));
    }
}

