/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.ArrayList;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestProjection {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)16, (String)"id", (Type)Types.LongType.get())});

    @Test
    public void testIdentityProjection() {
        ArrayList predicates = Lists.newArrayList((Object[])new UnboundPredicate[]{Expressions.notNull((String)"id"), Expressions.isNull((String)"id"), Expressions.lessThan((String)"id", (Object)100), Expressions.lessThanOrEqual((String)"id", (Object)101), Expressions.greaterThan((String)"id", (Object)102), Expressions.greaterThanOrEqual((String)"id", (Object)103), Expressions.equal((String)"id", (Object)104), Expressions.notEqual((String)"id", (Object)105)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        for (UnboundPredicate predicate : predicates) {
            Expression expr = Projections.inclusive((PartitionSpec)spec).project((Expression)predicate);
            UnboundPredicate projected = TestHelpers.assertAndUnwrapUnbound(expr);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(predicate.bind(spec.schema().asStruct(), true));
            Assert.assertEquals((String)"Field name should match partition struct field", (Object)"id", (Object)projected.ref().name());
            Assert.assertEquals((String)"Operation should match", (Object)bound.op(), (Object)projected.op());
            if (bound.isLiteralPredicate()) {
                Assert.assertEquals((String)"Literal should be equal", (Object)bound.asLiteralPredicate().literal().value(), (Object)projected.literal().value());
                continue;
            }
            Assert.assertNull((String)"Literal should be null", (Object)projected.literal());
        }
    }

    @Test
    public void testCaseInsensitiveIdentityProjection() {
        ArrayList predicates = Lists.newArrayList((Object[])new UnboundPredicate[]{Expressions.notNull((String)"ID"), Expressions.isNull((String)"ID"), Expressions.lessThan((String)"ID", (Object)100), Expressions.lessThanOrEqual((String)"ID", (Object)101), Expressions.greaterThan((String)"ID", (Object)102), Expressions.greaterThanOrEqual((String)"ID", (Object)103), Expressions.equal((String)"ID", (Object)104), Expressions.notEqual((String)"ID", (Object)105)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        for (UnboundPredicate predicate : predicates) {
            Expression expr = Projections.inclusive((PartitionSpec)spec, (boolean)false).project((Expression)predicate);
            UnboundPredicate projected = TestHelpers.assertAndUnwrapUnbound(expr);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(predicate.bind(spec.schema().asStruct(), false));
            Assert.assertEquals((String)"Field name should match partition struct field", (Object)"id", (Object)projected.ref().name());
            Assert.assertEquals((String)"Operation should match", (Object)bound.op(), (Object)projected.op());
            if (bound.isLiteralPredicate()) {
                Assert.assertEquals((String)"Literal should be equal", (Object)bound.asLiteralPredicate().literal().value(), (Object)projected.literal().value());
                continue;
            }
            Assert.assertNull((String)"Literal should be null", (Object)projected.literal());
        }
    }

    @Test
    public void testCaseSensitiveIdentityProjection() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Projections.inclusive((PartitionSpec)spec, (boolean)true).project((Expression)Expressions.notNull((String)"ID"))).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'ID' in struct");
    }

    @Test
    public void testStrictIdentityProjection() {
        ArrayList predicates = Lists.newArrayList((Object[])new UnboundPredicate[]{Expressions.notNull((String)"id"), Expressions.isNull((String)"id"), Expressions.lessThan((String)"id", (Object)100), Expressions.lessThanOrEqual((String)"id", (Object)101), Expressions.greaterThan((String)"id", (Object)102), Expressions.greaterThanOrEqual((String)"id", (Object)103), Expressions.equal((String)"id", (Object)104), Expressions.notEqual((String)"id", (Object)105)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        for (UnboundPredicate predicate : predicates) {
            Expression expr = Projections.strict((PartitionSpec)spec).project((Expression)predicate);
            UnboundPredicate projected = TestHelpers.assertAndUnwrapUnbound(expr);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(predicate.bind(spec.schema().asStruct(), true));
            Assert.assertEquals((String)"Field name should match partition struct field", (Object)"id", (Object)projected.ref().name());
            Assert.assertEquals((String)"Operation should match", (Object)bound.op(), (Object)projected.op());
            if (bound.isLiteralPredicate()) {
                Assert.assertEquals((String)"Literal should be equal", (Object)bound.asLiteralPredicate().literal().value(), (Object)projected.literal().value());
                continue;
            }
            Assert.assertNull((String)"Literal should be null", (Object)projected.literal());
        }
    }

    @Test
    public void testCaseInsensitiveStrictIdentityProjection() {
        ArrayList predicates = Lists.newArrayList((Object[])new UnboundPredicate[]{Expressions.notNull((String)"ID"), Expressions.isNull((String)"ID"), Expressions.lessThan((String)"ID", (Object)100), Expressions.lessThanOrEqual((String)"ID", (Object)101), Expressions.greaterThan((String)"ID", (Object)102), Expressions.greaterThanOrEqual((String)"ID", (Object)103), Expressions.equal((String)"ID", (Object)104), Expressions.notEqual((String)"ID", (Object)105)});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        for (UnboundPredicate predicate : predicates) {
            Expression expr = Projections.strict((PartitionSpec)spec, (boolean)false).project((Expression)predicate);
            UnboundPredicate projected = TestHelpers.assertAndUnwrapUnbound(expr);
            BoundPredicate bound = TestHelpers.assertAndUnwrap(predicate.bind(spec.schema().asStruct(), false));
            Assert.assertEquals((String)"Field name should match partition struct field", (Object)"id", (Object)projected.ref().name());
            Assert.assertEquals((String)"Operation should match", (Object)bound.op(), (Object)projected.op());
            if (bound.isLiteralPredicate()) {
                Assert.assertEquals((String)"Literal should be equal", (Object)bound.asLiteralPredicate().literal().value(), (Object)projected.literal().value());
                continue;
            }
            Assert.assertNull((String)"Literal should be null", (Object)projected.literal());
        }
    }

    @Test
    public void testCaseSensitiveStrictIdentityProjection() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Projections.strict((PartitionSpec)spec, (boolean)true).project((Expression)Expressions.notNull((String)"ID"))).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'ID' in struct");
    }

    @Test
    public void testBadSparkPartitionFilter() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"hour", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"dateint", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("dateint").build();
        Expression filter = Expressions.or((Expression)Expressions.equal((String)"dateint", (Object)20180416), (Expression)Expressions.or((Expression)Expressions.and((Expression)Expressions.equal((String)"dateint", (Object)20180415), (Expression)Expressions.greaterThanOrEqual((String)"hour", (Object)20)), (Expression)Expressions.and((Expression)Expressions.equal((String)"dateint", (Object)20180417), (Expression)Expressions.lessThanOrEqual((String)"hour", (Object)4))));
        Expression projection = Projections.inclusive((PartitionSpec)spec).project(filter);
        Assertions.assertThat((Object)projection).isInstanceOf(Or.class);
        Or or1 = (Or)projection;
        UnboundPredicate dateint1 = TestHelpers.assertAndUnwrapUnbound(or1.left());
        Assert.assertEquals((String)"Should be a dateint predicate", (Object)"dateint", (Object)dateint1.ref().name());
        Assert.assertEquals((String)"Should be dateint=20180416", (Object)20180416, (Object)dateint1.literal().value());
        Assertions.assertThat((Object)or1.right()).isInstanceOf(Or.class);
        Or or2 = (Or)or1.right();
        UnboundPredicate dateint2 = TestHelpers.assertAndUnwrapUnbound(or2.left());
        Assert.assertEquals((String)"Should be a dateint predicate", (Object)"dateint", (Object)dateint2.ref().name());
        Assert.assertEquals((String)"Should be dateint=20180415", (Object)20180415, (Object)dateint2.literal().value());
        UnboundPredicate dateint3 = TestHelpers.assertAndUnwrapUnbound(or2.right());
        Assert.assertEquals((String)"Should be a dateint predicate", (Object)"dateint", (Object)dateint3.ref().name());
        Assert.assertEquals((String)"Should be dateint=20180417", (Object)20180417, (Object)dateint3.literal().value());
    }

    @Test
    public void testProjectionNames() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"timestamp1", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)2, (String)"timestamp2", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)3, (String)"timestamp3", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)4, (String)"timestamp4", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)5, (String)"date1", (Type)Types.DateType.get()), Types.NestedField.optional((int)6, (String)"date2", (Type)Types.DateType.get()), Types.NestedField.optional((int)7, (String)"date3", (Type)Types.DateType.get()), Types.NestedField.optional((int)8, (String)"long", (Type)Types.LongType.get()), Types.NestedField.optional((int)9, (String)"string", (Type)Types.StringType.get())});
        PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)schema).withSpecId(0).hour("timestamp1").day("timestamp2").month("timestamp3").year("timestamp4").day("date1").month("date2").year("date3").bucket("long", 10).truncate("string", 10).build();
        UnboundPredicate predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.hour((String)"timestamp1"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp1_hour", (Object)"timestamp1_hour", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.hour((String)"timestamp1"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp1_hour", (Object)"timestamp1_hour", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.day((String)"timestamp2"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp2_day", (Object)"timestamp2_day", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.day((String)"timestamp2"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp2_day", (Object)"timestamp2_day", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.month((String)"timestamp3"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp3_month", (Object)"timestamp3_month", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.month((String)"timestamp3"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp3_month", (Object)"timestamp3_month", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.year((String)"timestamp4"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp4_year", (Object)"timestamp4_year", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.year((String)"timestamp4"), (Object)20));
        Assert.assertEquals((String)"should expected timestamp4_year", (Object)"timestamp4_year", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.day((String)"date1"), (Object)20));
        Assert.assertEquals((String)"should expected date1_day", (Object)"date1_day", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.day((String)"date1"), (Object)20));
        Assert.assertEquals((String)"should expected date1_day", (Object)"date1_day", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.month((String)"date2"), (Object)20));
        Assert.assertEquals((String)"should expected date2_month", (Object)"date2_month", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.month((String)"date2"), (Object)20));
        Assert.assertEquals((String)"should expected date2_month", (Object)"date2_month", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.year((String)"date3"), (Object)20));
        Assert.assertEquals((String)"should expected date3_year", (Object)"date3_year", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.year((String)"date3"), (Object)20));
        Assert.assertEquals((String)"should expected date3_year", (Object)"date3_year", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"long", (int)10), (Object)20));
        Assert.assertEquals((String)"should expected long_bucket", (Object)"long_bucket", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"long", (int)10), (Object)20));
        Assert.assertEquals((String)"should expected long_bucket", (Object)"long_bucket", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.strict((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"string", (int)10), (Object)"abc"));
        Assert.assertEquals((String)"should expected string_trunc", (Object)"string_trunc", (Object)predicate.ref().name());
        predicate = (UnboundPredicate)Projections.inclusive((PartitionSpec)partitionSpec).project((Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"string", (int)10), (Object)"abc"));
        Assert.assertEquals((String)"should expected string_trunc", (Object)"string_trunc", (Object)predicate.ref().name());
    }
}

