/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestResiduals {
    @Test
    public void testIdentityTransformResiduals() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"dateint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)51, (String)"hour", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("dateint").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.or((Expression)Expressions.or((Expression)Expressions.and((Expression)Expressions.lessThan((String)"dateint", (Object)20170815), (Expression)Expressions.greaterThan((String)"dateint", (Object)20170801)), (Expression)Expressions.and((Expression)Expressions.equal((String)"dateint", (Object)20170815), (Expression)Expressions.lessThan((String)"hour", (Object)12))), (Expression)Expressions.and((Expression)Expressions.equal((String)"dateint", (Object)20170801), (Expression)Expressions.greaterThan((String)"hour", (Object)11))), (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170815));
        UnboundPredicate unbound = TestHelpers.assertAndUnwrapUnbound(residual);
        Assert.assertEquals((String)"Residual should be hour < 12", (Object)Expression.Operation.LT, (Object)unbound.op());
        Assert.assertEquals((String)"Residual should be hour < 12", (Object)"hour", (Object)unbound.ref().name());
        Assert.assertEquals((String)"Residual should be hour < 12", (Object)12, (Object)unbound.literal().value());
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170801));
        unbound = TestHelpers.assertAndUnwrapUnbound(residual);
        Assert.assertEquals((String)"Residual should be hour > 11", (Object)Expression.Operation.GT, (Object)unbound.op());
        Assert.assertEquals((String)"Residual should be hour > 11", (Object)"hour", (Object)unbound.ref().name());
        Assert.assertEquals((String)"Residual should be hour > 11", (Object)11, (Object)unbound.literal().value());
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170812));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170817));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
    }

    @Test
    public void testCaseInsensitiveIdentityTransformResiduals() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"dateint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)51, (String)"hour", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("dateint").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.or((Expression)Expressions.or((Expression)Expressions.and((Expression)Expressions.lessThan((String)"DATEINT", (Object)20170815), (Expression)Expressions.greaterThan((String)"dateint", (Object)20170801)), (Expression)Expressions.and((Expression)Expressions.equal((String)"dateint", (Object)20170815), (Expression)Expressions.lessThan((String)"HOUR", (Object)12))), (Expression)Expressions.and((Expression)Expressions.equal((String)"DateInt", (Object)20170801), (Expression)Expressions.greaterThan((String)"hOUr", (Object)11))), (boolean)false);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170815));
        UnboundPredicate unbound = TestHelpers.assertAndUnwrapUnbound(residual);
        Assert.assertEquals((String)"Residual should be hour < 12", (Object)Expression.Operation.LT, (Object)unbound.op());
        Assert.assertEquals((String)"Residual should be hour < 12", (Object)"HOUR", (Object)unbound.ref().name());
        Assert.assertEquals((String)"Residual should be hour < 12", (Object)12, (Object)unbound.literal().value());
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170801));
        unbound = TestHelpers.assertAndUnwrapUnbound(residual);
        Assert.assertEquals((String)"Residual should be hour > 11", (Object)Expression.Operation.GT, (Object)unbound.op());
        Assert.assertEquals((String)"Residual should be hour > 11", (Object)"hOUr", (Object)unbound.ref().name());
        Assert.assertEquals((String)"Residual should be hour > 11", (Object)11, (Object)unbound.literal().value());
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170812));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170817));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
    }

    @Test
    public void testCaseSensitiveIdentityTransformResiduals() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"dateint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)51, (String)"hour", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("dateint").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.lessThan((String)"DATEINT", (Object)20170815), (boolean)true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> resEval.residualFor((StructLike)TestHelpers.Row.of(20170815))).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot find field 'DATEINT' in struct");
    }

    @Test
    public void testUnpartitionedResiduals() {
        Expression[] expressions;
        for (Expression expr : expressions = new Expression[]{Expressions.alwaysTrue(), Expressions.alwaysFalse(), Expressions.lessThan((String)"a", (Object)5), Expressions.greaterThanOrEqual((String)"b", (Object)16), Expressions.notNull((String)"c"), Expressions.isNull((String)"d"), Expressions.in((String)"e", (Object[])new Integer[]{1, 2, 3}), Expressions.notIn((String)"f", (Object[])new Integer[]{1, 2, 3}), Expressions.notNaN((String)"g"), Expressions.isNaN((String)"h"), Expressions.startsWith((String)"data", (String)"abcd"), Expressions.notStartsWith((String)"data", (String)"abcd")}) {
            ResidualEvaluator residualEvaluator = ResidualEvaluator.of((PartitionSpec)PartitionSpec.unpartitioned(), (Expression)expr, (boolean)true);
            Assert.assertEquals((String)"Should return expression", (Object)expr, (Object)residualEvaluator.residualFor((StructLike)TestHelpers.Row.of(new Object[0])));
        }
    }

    @Test
    public void testIn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"dateint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)51, (String)"hour", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("dateint").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.in((String)"dateint", (Object[])new Integer[]{20170815, 20170816, 20170817}), (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170815));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20180815));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
    }

    @Test
    public void testInTimestamp() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)51, (String)"dateint", (Type)Types.IntegerType.get())});
        Long date20191201 = (Long)Literal.of((CharSequence)"2019-12-01T00:00:00.00000").to((Type)Types.TimestampType.withoutZone()).value();
        Long date20191202 = (Long)Literal.of((CharSequence)"2019-12-02T00:00:00.00000").to((Type)Types.TimestampType.withoutZone()).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).day("ts").build();
        SerializableFunction day = Transforms.day().bind((Type)Types.TimestampType.withoutZone());
        Integer tsDay = (Integer)day.apply(date20191201);
        UnboundPredicate pred = Expressions.in((String)"ts", (Object[])new Long[]{date20191201, date20191202});
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)pred, (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(tsDay));
        Assert.assertEquals((String)"Residual should be the original in predicate", (Object)pred, (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(tsDay + 3));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
    }

    @Test
    public void testNotIn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"dateint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)51, (String)"hour", (Type)Types.IntegerType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("dateint").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.notIn((String)"dateint", (Object[])new Integer[]{20170815, 20170816, 20170817}), (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20180815));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(20170815));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
    }

    @Test
    public void testIsNaN() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)51, (String)"float", (Type)Types.FloatType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("double").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.isNaN((String)"double"), (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(Double.NaN));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(2.0));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
        spec = PartitionSpec.builderFor((Schema)schema).identity("float").build();
        resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.isNaN((String)"float"), (boolean)true);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(Float.valueOf(Float.NaN)));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(Float.valueOf(3.0f)));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
    }

    @Test
    public void testNotNaN() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)51, (String)"float", (Type)Types.FloatType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("double").build();
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.notNaN((String)"double"), (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(Double.NaN));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(2.0));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
        spec = PartitionSpec.builderFor((Schema)schema).identity("float").build();
        resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)Expressions.notNaN((String)"float"), (boolean)true);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(Float.valueOf(Float.NaN)));
        Assert.assertEquals((String)"Residual should be alwaysFalse", (Object)Expressions.alwaysFalse(), (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(Float.valueOf(3.0f)));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
    }

    @Test
    public void testNotInTimestamp() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)50, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)51, (String)"dateint", (Type)Types.IntegerType.get())});
        Long date20191201 = (Long)Literal.of((CharSequence)"2019-12-01T00:00:00.00000").to((Type)Types.TimestampType.withoutZone()).value();
        Long date20191202 = (Long)Literal.of((CharSequence)"2019-12-02T00:00:00.00000").to((Type)Types.TimestampType.withoutZone()).value();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).day("ts").build();
        SerializableFunction day = Transforms.day().bind((Type)Types.TimestampType.withoutZone());
        Integer tsDay = (Integer)day.apply(date20191201);
        UnboundPredicate pred = Expressions.notIn((String)"ts", (Object[])new Long[]{date20191201, date20191202});
        ResidualEvaluator resEval = ResidualEvaluator.of((PartitionSpec)spec, (Expression)pred, (boolean)true);
        Expression residual = resEval.residualFor((StructLike)TestHelpers.Row.of(tsDay));
        Assert.assertEquals((String)"Residual should be the original notIn predicate", (Object)pred, (Object)residual);
        residual = resEval.residualFor((StructLike)TestHelpers.Row.of(tsDay + 3));
        Assert.assertEquals((String)"Residual should be alwaysTrue", (Object)Expressions.alwaysTrue(), (Object)residual);
    }
}

